/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.util.dns.DNSResolver;
import org.jivesoftware.smack.util.dns.HostAddress;
import org.jivesoftware.smack.util.dns.SRVRecord;

public class DNSUtil {
    private static final Logger LOGGER = Logger.getLogger(DNSUtil.class.getName());
    private static DNSResolver dnsResolver = null;

    public static void init() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"javax.JavaxResolver", "minidns.MiniDnsResolver", "dnsjava.DNSJavaResolver"}) {
            DNSResolver dNSResolver = null;
            String string2 = "org.jivesoftware.smack.util.dns." + string;
            try {
                Class<?> clazz = Class.forName(string2);
                Method method = clazz.getMethod("getInstance", new Class[0]);
                dNSResolver = (DNSResolver)method.invoke(null, new Object[0]);
                if (dNSResolver == null) continue;
                DNSUtil.setDNSResolver(dNSResolver);
                break;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                LOGGER.log(Level.FINE, "Exception on init", exception);
            }
        }
    }

    public static void setDNSResolver(DNSResolver dNSResolver) {
        dnsResolver = dNSResolver;
    }

    public static DNSResolver getDNSResolver() {
        return dnsResolver;
    }

    public static List<HostAddress> resolveXMPPDomain(String string) {
        if (dnsResolver == null) {
            ArrayList<HostAddress> arrayList = new ArrayList<HostAddress>(1);
            arrayList.add(new HostAddress(string, 5222));
            return arrayList;
        }
        return DNSUtil.resolveDomain(string, 'c');
    }

    public static List<HostAddress> resolveXMPPServerDomain(String string) {
        if (dnsResolver == null) {
            ArrayList<HostAddress> arrayList = new ArrayList<HostAddress>(1);
            arrayList.add(new HostAddress(string, 5269));
            return arrayList;
        }
        return DNSUtil.resolveDomain(string, 's');
    }

    private static List<HostAddress> resolveDomain(String string, char c) {
        ArrayList<HostAddress> arrayList = new ArrayList<HostAddress>();
        String string2 = c == 's' ? "_xmpp-server._tcp." + string : (c == 'c' ? "_xmpp-client._tcp." + string : string);
        try {
            Object object;
            List<SRVRecord> list = dnsResolver.lookupSRVRecords(string2);
            if (LOGGER.isLoggable(Level.FINE)) {
                object = "Resolved SRV RR for " + string2 + ":";
                for (SRVRecord sRVRecord : list) {
                    object = (String)object + " " + sRVRecord;
                }
                LOGGER.fine((String)object);
            }
            object = DNSUtil.sortSRVRecords(list);
            arrayList.addAll((Collection<HostAddress>)object);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Exception while resovling SRV records for " + string + ". Consider adding '_xmpp-(server|client)._tcp' DNS SRV Records");
        }
        arrayList.add(new HostAddress(string));
        return arrayList;
    }

    private static List<HostAddress> sortSRVRecords(List<SRVRecord> list) {
        List list2;
        if (list.size() == 1 && list.get(0).getFQDN().equals(".")) {
            return Collections.emptyList();
        }
        Collections.sort(list);
        TreeMap<Integer, LinkedList<SRVRecord>> treeMap = new TreeMap<Integer, LinkedList<SRVRecord>>();
        for (SRVRecord object : list) {
            Integer n = object.getPriority();
            list2 = (LinkedList<SRVRecord>)treeMap.get(n);
            if (list2 == null) {
                list2 = new LinkedList<SRVRecord>();
                treeMap.put(n, (LinkedList<SRVRecord>)list2);
            }
            list2.add(object);
        }
        ArrayList arrayList = new ArrayList(list.size());
        for (Integer n : treeMap.keySet()) {
            int n2;
            list2 = (List)treeMap.get(n);
            while ((n2 = list2.size()) > 0) {
                int n3;
                SRVRecord d2;
                int[] nArray = new int[list2.size()];
                int n4 = 0;
                int n5 = 0;
                int n6 = 1;
                for (SRVRecord d2 : list2) {
                    if (d2.getWeight() <= 0) continue;
                    n6 = 0;
                }
                for (SRVRecord d2 : list2) {
                    nArray[n5] = n4 += d2.getWeight() + n6;
                    ++n5;
                }
                if (n4 == 0) {
                    n3 = (int)(Math.random() * (double)n2);
                } else {
                    double d3 = Math.random() * (double)n4;
                    n3 = DNSUtil.bisect(nArray, d3);
                }
                d2 = (SRVRecord)list2.remove(n3);
                arrayList.add(d2);
            }
        }
        return arrayList;
    }

    private static int bisect(int[] nArray, double d) {
        int n = 0;
        for (int n2 : nArray) {
            if (d < (double)n2) break;
            ++n;
        }
        return n;
    }
}

