/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XmppDateTime {
    private static final DateFormatType dateFormatter = DateFormatType.XEP_0082_DATE_PROFILE;
    private static final Pattern datePattern = Pattern.compile("^\\d+-\\d+-\\d+$");
    private static final DateFormatType timeFormatter = DateFormatType.XEP_0082_TIME_MILLIS_ZONE_PROFILE;
    private static final Pattern timePattern = Pattern.compile("^(\\d+:){2}\\d+.\\d+(Z|([+-](\\d+:\\d+)))$");
    private static final DateFormatType timeNoZoneFormatter = DateFormatType.XEP_0082_TIME_MILLIS_PROFILE;
    private static final Pattern timeNoZonePattern = Pattern.compile("^(\\d+:){2}\\d+.\\d+$");
    private static final DateFormatType timeNoMillisFormatter = DateFormatType.XEP_0082_TIME_ZONE_PROFILE;
    private static final Pattern timeNoMillisPattern = Pattern.compile("^(\\d+:){2}\\d+(Z|([+-](\\d+:\\d+)))$");
    private static final DateFormatType timeNoMillisNoZoneFormatter = DateFormatType.XEP_0082_TIME_PROFILE;
    private static final Pattern timeNoMillisNoZonePattern = Pattern.compile("^(\\d+:){2}\\d+$");
    private static final DateFormatType dateTimeFormatter = DateFormatType.XEP_0082_DATETIME_MILLIS_PROFILE;
    private static final Pattern dateTimePattern = Pattern.compile("^\\d+(-\\d+){2}+T(\\d+:){2}\\d+.\\d+(Z|([+-](\\d+:\\d+)))?$");
    private static final DateFormatType dateTimeNoMillisFormatter = DateFormatType.XEP_0082_DATETIME_PROFILE;
    private static final Pattern dateTimeNoMillisPattern = Pattern.compile("^\\d+(-\\d+){2}+T(\\d+:){2}\\d+(Z|([+-](\\d+:\\d+)))?$");
    private static final DateFormat xep0091Formatter = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    private static final DateFormat xep0091Date6DigitFormatter = new SimpleDateFormat("yyyyMd'T'HH:mm:ss");
    private static final DateFormat xep0091Date7Digit1MonthFormatter = new SimpleDateFormat("yyyyMdd'T'HH:mm:ss");
    private static final DateFormat xep0091Date7Digit2MonthFormatter = new SimpleDateFormat("yyyyMMd'T'HH:mm:ss");
    private static final Pattern xep0091Pattern = Pattern.compile("^\\d+T\\d+:\\d+:\\d+$");
    private static final List<PatternCouplings> couplings = new ArrayList<PatternCouplings>();

    public static Date parseXEP0082Date(String string) throws ParseException {
        return XmppDateTime.parseDate(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Date parseDate(String string) throws ParseException {
        Matcher matcher = xep0091Pattern.matcher(string);
        if (matcher.matches()) {
            int n = string.split("T")[0].length();
            if (n >= 8) {
                DateFormat dateFormat = xep0091Formatter;
                // MONITORENTER : dateFormat
                // MONITOREXIT : dateFormat
                return xep0091Formatter.parse(string);
            }
            Date date = XmppDateTime.handleDateWithMissingLeadingZeros(string, n);
            if (date != null) {
                return date;
            }
        } else {
            for (PatternCouplings patternCouplings : couplings) {
                matcher = patternCouplings.pattern.matcher(string);
                if (!matcher.matches()) continue;
                return patternCouplings.formatter.parse(string);
            }
        }
        DateFormatType dateFormatType = dateTimeNoMillisFormatter;
        // MONITORENTER : dateFormatType
        // MONITOREXIT : dateFormatType
        return dateTimeNoMillisFormatter.parse(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatXEP0082Date(Date date) {
        DateFormatType dateFormatType = dateTimeFormatter;
        synchronized (dateFormatType) {
            return dateTimeFormatter.format(date);
        }
    }

    public static String convertXep82TimezoneToRfc822(String string) {
        if (string.charAt(string.length() - 1) == 'Z') {
            return string.replace("Z", "+0000");
        }
        return string.replaceAll("([\\+\\-]\\d\\d):(\\d\\d)", "$1$2");
    }

    public static String convertRfc822TimezoneToXep82(String string) {
        int n = string.length();
        String string2 = string.substring(0, n - 2);
        string2 = string2 + ':';
        string2 = string2 + string.substring(n - 2, n);
        return string2;
    }

    public static String asString(TimeZone timeZone) {
        int n = timeZone.getRawOffset();
        int n2 = n / 3600000;
        int n3 = Math.abs(n / 60000 - n2 * 60);
        return String.format("%+d:%02d", n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date handleDateWithMissingLeadingZeros(String string, int n) throws ParseException {
        if (n == 6) {
            DateFormat dateFormat = xep0091Date6DigitFormatter;
            synchronized (dateFormat) {
                return xep0091Date6DigitFormatter.parse(string);
            }
        }
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = XmppDateTime.parseXEP91Date(string, xep0091Date7Digit1MonthFormatter);
        Calendar calendar3 = XmppDateTime.parseXEP91Date(string, xep0091Date7Digit2MonthFormatter);
        List<Calendar> list = XmppDateTime.filterDatesBefore(calendar, calendar2, calendar3);
        if (!list.isEmpty()) {
            return XmppDateTime.determineNearestDate(calendar, list).getTime();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Calendar parseXEP91Date(String string, DateFormat dateFormat) {
        try {
            DateFormat dateFormat2 = dateFormat;
            synchronized (dateFormat2) {
                dateFormat.parse(string);
                return dateFormat.getCalendar();
            }
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private static List<Calendar> filterDatesBefore(Calendar calendar, Calendar ... calendarArray) {
        ArrayList<Calendar> arrayList = new ArrayList<Calendar>();
        for (Calendar calendar2 : calendarArray) {
            if (calendar2 == null || !calendar2.before(calendar)) continue;
            arrayList.add(calendar2);
        }
        return arrayList;
    }

    private static Calendar determineNearestDate(final Calendar calendar, List<Calendar> list) {
        Collections.sort(list, new Comparator<Calendar>(){

            @Override
            public int compare(Calendar calendar3, Calendar calendar2) {
                Long l = new Long(calendar.getTimeInMillis() - calendar3.getTimeInMillis());
                Long l2 = new Long(calendar.getTimeInMillis() - calendar2.getTimeInMillis());
                return l.compareTo(l2);
            }
        });
        return list.get(0);
    }

    static {
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        xep0091Formatter.setTimeZone(timeZone);
        xep0091Date6DigitFormatter.setTimeZone(timeZone);
        xep0091Date7Digit1MonthFormatter.setTimeZone(timeZone);
        xep0091Date7Digit1MonthFormatter.setLenient(false);
        xep0091Date7Digit2MonthFormatter.setTimeZone(timeZone);
        xep0091Date7Digit2MonthFormatter.setLenient(false);
        couplings.add(new PatternCouplings(datePattern, dateFormatter));
        couplings.add(new PatternCouplings(dateTimePattern, dateTimeFormatter));
        couplings.add(new PatternCouplings(dateTimeNoMillisPattern, dateTimeNoMillisFormatter));
        couplings.add(new PatternCouplings(timePattern, timeFormatter));
        couplings.add(new PatternCouplings(timeNoZonePattern, timeNoZoneFormatter));
        couplings.add(new PatternCouplings(timeNoMillisPattern, timeNoMillisFormatter));
        couplings.add(new PatternCouplings(timeNoMillisNoZonePattern, timeNoMillisNoZoneFormatter));
    }

    private static class PatternCouplings {
        final Pattern pattern;
        final DateFormatType formatter;

        public PatternCouplings(Pattern pattern, DateFormatType dateFormatType) {
            this.pattern = pattern;
            this.formatter = dateFormatType;
        }
    }

    public static enum DateFormatType {
        XEP_0082_DATE_PROFILE("yyyy-MM-dd"),
        XEP_0082_DATETIME_PROFILE("yyyy-MM-dd'T'HH:mm:ssZ"),
        XEP_0082_DATETIME_MILLIS_PROFILE("yyyy-MM-dd'T'HH:mm:ss.SSSZ"),
        XEP_0082_TIME_PROFILE("hh:mm:ss"),
        XEP_0082_TIME_ZONE_PROFILE("hh:mm:ssZ"),
        XEP_0082_TIME_MILLIS_PROFILE("hh:mm:ss.SSS"),
        XEP_0082_TIME_MILLIS_ZONE_PROFILE("hh:mm:ss.SSSZ"),
        XEP_0091_DATETIME("yyyyMMdd'T'HH:mm:ss");

        private final String FORMAT_STRING;
        private final DateFormat FORMATTER;
        private final boolean CONVERT_TIMEZONE;

        private DateFormatType(String string2) {
            this.FORMAT_STRING = string2;
            this.FORMATTER = new SimpleDateFormat(this.FORMAT_STRING);
            this.FORMATTER.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.CONVERT_TIMEZONE = string2.charAt(string2.length() - 1) == 'Z';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String format(Date date) {
            String string;
            DateFormat dateFormat = this.FORMATTER;
            synchronized (dateFormat) {
                string = this.FORMATTER.format(date);
            }
            if (this.CONVERT_TIMEZONE) {
                string = XmppDateTime.convertRfc822TimezoneToXep82(string);
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Date parse(String string) throws ParseException {
            if (this.CONVERT_TIMEZONE) {
                string = XmppDateTime.convertXep82TimezoneToRfc822(string);
            }
            DateFormat dateFormat = this.FORMATTER;
            synchronized (dateFormat) {
                return this.FORMATTER.parse(string);
            }
        }
    }
}

