/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.amp.provider;

import java.util.logging.Logger;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.amp.AMPDeliverCondition;
import org.jivesoftware.smackx.amp.AMPExpireAtCondition;
import org.jivesoftware.smackx.amp.AMPMatchResourceCondition;
import org.jivesoftware.smackx.amp.packet.AMPExtension;
import org.xmlpull.v1.XmlPullParser;

public class AMPExtensionProvider
implements PacketExtensionProvider {
    private static final Logger LOGGER = Logger.getLogger(AMPExtensionProvider.class.getName());

    @Override
    public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
        boolean bl;
        String string = xmlPullParser.getAttributeValue(null, "from");
        String string2 = xmlPullParser.getAttributeValue(null, "to");
        String string3 = xmlPullParser.getAttributeValue(null, "status");
        AMPExtension.Status status = null;
        if (string3 != null) {
            try {
                status = AMPExtension.Status.valueOf(string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.severe("Found invalid amp status " + string3);
            }
        }
        AMPExtension aMPExtension = new AMPExtension(string, string2, status);
        String string4 = xmlPullParser.getAttributeValue(null, "per-hop");
        if (string4 != null) {
            bl = Boolean.parseBoolean(string4);
            aMPExtension.setPerHop(bl);
        }
        bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                if (!xmlPullParser.getName().equals("rule")) continue;
                String string5 = xmlPullParser.getAttributeValue(null, "action");
                String string6 = xmlPullParser.getAttributeValue(null, "condition");
                String string7 = xmlPullParser.getAttributeValue(null, "value");
                AMPExtension.Condition condition = this.createCondition(string6, string7);
                AMPExtension.Action action = null;
                if (string5 != null) {
                    try {
                        action = AMPExtension.Action.valueOf(string5);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        LOGGER.severe("Found invalid rule action value " + string5);
                    }
                }
                if (action == null || condition == null) {
                    LOGGER.severe("Rule is skipped because either it's action or it's condition is invalid");
                    continue;
                }
                AMPExtension.Rule rule = new AMPExtension.Rule(action, condition);
                aMPExtension.addRule(rule);
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("amp")) continue;
            bl = true;
        }
        return aMPExtension;
    }

    private AMPExtension.Condition createCondition(String string, String string2) {
        if (string == null || string2 == null) {
            LOGGER.severe("Can't create rule condition from null name and/or value");
            return null;
        }
        if ("deliver".equals(string)) {
            try {
                return new AMPDeliverCondition(AMPDeliverCondition.Value.valueOf(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.severe("Found invalid rule delivery condition value " + string2);
                return null;
            }
        }
        if ("expire-at".equals(string)) {
            return new AMPExpireAtCondition(string2);
        }
        if ("match-resource".equals(string)) {
            try {
                return new AMPMatchResourceCondition(AMPMatchResourceCondition.Value.valueOf(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.severe("Found invalid rule match-resource condition value " + string2);
                return null;
            }
        }
        LOGGER.severe("Found unknown rule condition name " + string);
        return null;
    }
}

