/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;

public class InBandBytestreamRequest
implements BytestreamRequest {
    private final Open byteStreamRequest;
    private final InBandBytestreamManager manager;

    protected InBandBytestreamRequest(InBandBytestreamManager inBandBytestreamManager, Open open) {
        this.manager = inBandBytestreamManager;
        this.byteStreamRequest = open;
    }

    @Override
    public String getFrom() {
        return this.byteStreamRequest.getFrom();
    }

    @Override
    public String getSessionID() {
        return this.byteStreamRequest.getSessionID();
    }

    @Override
    public InBandBytestreamSession accept() throws SmackException.NotConnectedException {
        XMPPConnection xMPPConnection = this.manager.getConnection();
        InBandBytestreamSession inBandBytestreamSession = new InBandBytestreamSession(xMPPConnection, this.byteStreamRequest, this.byteStreamRequest.getFrom());
        this.manager.getSessions().put(this.byteStreamRequest.getSessionID(), inBandBytestreamSession);
        IQ iQ = IQ.createResultIQ(this.byteStreamRequest);
        xMPPConnection.sendPacket(iQ);
        return inBandBytestreamSession;
    }

    @Override
    public void reject() throws SmackException.NotConnectedException {
        this.manager.replyRejectPacket(this.byteStreamRequest);
    }
}

