/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;

final class InitiationListener
implements PacketListener {
    private static final Logger LOGGER = Logger.getLogger(InitiationListener.class.getName());
    private final Socks5BytestreamManager manager;
    private final PacketFilter initFilter = new AndFilter(new PacketTypeFilter(Bytestream.class), new IQTypeFilter(IQ.Type.SET));
    private final ExecutorService initiationListenerExecutor;

    protected InitiationListener(Socks5BytestreamManager socks5BytestreamManager) {
        this.manager = socks5BytestreamManager;
        this.initiationListenerExecutor = Executors.newCachedThreadPool();
    }

    @Override
    public void processPacket(final Packet packet) {
        this.initiationListenerExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    InitiationListener.this.processRequest(packet);
                }
                catch (SmackException.NotConnectedException notConnectedException) {
                    LOGGER.log(Level.WARNING, "process request", notConnectedException);
                }
            }
        });
    }

    private void processRequest(Packet packet) throws SmackException.NotConnectedException {
        Bytestream bytestream = (Bytestream)packet;
        if (this.manager.getIgnoredBytestreamRequests().remove(bytestream.getSessionID())) {
            return;
        }
        Socks5BytestreamRequest socks5BytestreamRequest = new Socks5BytestreamRequest(this.manager, bytestream);
        BytestreamListener bytestreamListener = this.manager.getUserListener(bytestream.getFrom());
        if (bytestreamListener != null) {
            bytestreamListener.incomingBytestreamRequest(socks5BytestreamRequest);
        } else if (!this.manager.getAllRequestListeners().isEmpty()) {
            for (BytestreamListener bytestreamListener2 : this.manager.getAllRequestListeners()) {
                bytestreamListener2.incomingBytestreamRequest(socks5BytestreamRequest);
            }
        } else {
            this.manager.replyRejectPacket(bytestream);
        }
    }

    protected PacketFilter getFilter() {
        return this.initFilter;
    }

    protected void shutdown() {
        this.initiationListenerExecutor.shutdownNow();
    }
}

