/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;

class Socks5Client {
    protected Bytestream.StreamHost streamHost;
    protected String digest;

    public Socks5Client(Bytestream.StreamHost streamHost, String string) {
        this.streamHost = streamHost;
        this.digest = string;
    }

    public Socket getSocket(int n) throws IOException, XMPPException.XMPPErrorException, InterruptedException, TimeoutException, SmackException, XMPPException {
        FutureTask<Socket> futureTask = new FutureTask<Socket>(new Callable<Socket>(){

            @Override
            public Socket call() throws IOException, SmackException {
                boolean bl;
                Socket socket = new Socket();
                InetSocketAddress inetSocketAddress = new InetSocketAddress(Socks5Client.this.streamHost.getAddress(), Socks5Client.this.streamHost.getPort());
                socket.connect(inetSocketAddress);
                try {
                    bl = Socks5Client.this.establish(socket);
                }
                catch (SmackException smackException) {
                    socket.close();
                    throw smackException;
                }
                if (bl) {
                    return socket;
                }
                socket.close();
                throw new SmackException("SOCKS5 negotiation failed");
            }
        });
        Thread thread = new Thread(futureTask);
        thread.start();
        try {
            return futureTask.get(n, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable != null) {
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (throwable instanceof SmackException) {
                    throw (SmackException)throwable;
                }
            }
            throw new IOException("Error while connection to SOCKS5 proxy");
        }
    }

    protected boolean establish(Socket socket) throws SmackException, IOException {
        DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        byte[] byArray = new byte[]{5, 1, 0};
        dataOutputStream.write(byArray);
        dataOutputStream.flush();
        byte[] byArray2 = new byte[2];
        dataInputStream.readFully(byArray2);
        if (byArray2[0] != 5 || byArray2[1] != 0) {
            return false;
        }
        byte[] byArray3 = this.createSocks5ConnectRequest();
        dataOutputStream.write(byArray3);
        dataOutputStream.flush();
        byte[] byArray4 = Socks5Utils.receiveSocks5Message(dataInputStream);
        byArray3[1] = 0;
        return Arrays.equals(byArray3, byArray4);
    }

    private byte[] createSocks5ConnectRequest() {
        byte[] byArray = this.digest.getBytes();
        byte[] byArray2 = new byte[7 + byArray.length];
        byArray2[0] = 5;
        byArray2[1] = 1;
        byArray2[2] = 0;
        byArray2[3] = 3;
        byArray2[4] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
        byArray2[byArray2.length - 2] = 0;
        byArray2[byArray2.length - 1] = 0;
        return byArray2;
    }
}

