/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.caps;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.Base64;
import org.jivesoftware.smack.util.Cache;
import org.jivesoftware.smackx.caps.cache.EntityCapsPersistentCache;
import org.jivesoftware.smackx.caps.packet.CapsExtension;
import org.jivesoftware.smackx.disco.NodeInformationProvider;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class EntityCapsManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(EntityCapsManager.class.getName());
    public static final String NAMESPACE = "http://jabber.org/protocol/caps";
    public static final String ELEMENT = "c";
    private static final Map<String, MessageDigest> SUPPORTED_HASHES = new HashMap<String, MessageDigest>();
    private static String DEFAULT_ENTITY_NODE = "http://www.igniterealtime.org/projects/smack";
    protected static EntityCapsPersistentCache persistentCache;
    private static boolean autoEnableEntityCaps;
    private static Map<XMPPConnection, EntityCapsManager> instances;
    private static final PacketFilter PRESENCES_WITH_CAPS;
    private static final PacketFilter PRESENCES_WITHOUT_CAPS;
    private static final PacketFilter PRESENCES;
    protected static Map<String, DiscoverInfo> caps;
    protected static Map<String, NodeVerHash> jidCaps;
    private ServiceDiscoveryManager sdm;
    private boolean entityCapsEnabled;
    private String currentCapsVersion;
    private boolean presenceSend = false;
    private Queue<String> lastLocalCapsVersions = new ConcurrentLinkedQueue<String>();
    private String entityNode = DEFAULT_ENTITY_NODE;

    public static void setDefaultEntityNode(String string) {
        DEFAULT_ENTITY_NODE = string;
    }

    public static void addDiscoverInfoByNode(String string, DiscoverInfo discoverInfo) {
        caps.put(string, discoverInfo);
        if (persistentCache != null) {
            persistentCache.addDiscoverInfoByNodePersistent(string, discoverInfo);
        }
    }

    public static String getNodeVersionByJid(String string) {
        NodeVerHash nodeVerHash = jidCaps.get(string);
        if (nodeVerHash != null) {
            return nodeVerHash.nodeVer;
        }
        return null;
    }

    public static NodeVerHash getNodeVerHashByJid(String string) {
        return jidCaps.get(string);
    }

    public static DiscoverInfo getDiscoverInfoByUser(String string) {
        NodeVerHash nodeVerHash = jidCaps.get(string);
        if (nodeVerHash == null) {
            return null;
        }
        return EntityCapsManager.getDiscoveryInfoByNodeVer(nodeVerHash.nodeVer);
    }

    public static DiscoverInfo getDiscoveryInfoByNodeVer(String string) {
        DiscoverInfo discoverInfo = caps.get(string);
        if (discoverInfo != null) {
            discoverInfo = new DiscoverInfo(discoverInfo);
        }
        return discoverInfo;
    }

    public static void setPersistentCache(EntityCapsPersistentCache entityCapsPersistentCache) throws IOException {
        if (persistentCache != null) {
            throw new IllegalStateException("Entity Caps Persistent Cache was already set");
        }
        persistentCache = entityCapsPersistentCache;
        persistentCache.replay();
    }

    public static void setJidCapsMaxCacheSize(int n) {
        ((Cache)jidCaps).setMaxCacheSize(n);
    }

    public static void setCapsMaxCacheSize(int n) {
        ((Cache)caps).setMaxCacheSize(n);
    }

    private EntityCapsManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.sdm = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        instances.put(xMPPConnection, this);
        xMPPConnection.addConnectionListener(new AbstractConnectionListener(){

            @Override
            public void connectionClosed() {
                EntityCapsManager.this.presenceSend = false;
            }

            @Override
            public void connectionClosedOnError(Exception exception) {
                EntityCapsManager.this.presenceSend = false;
            }
        });
        this.updateLocalEntityCaps();
        if (autoEnableEntityCaps) {
            this.enableEntityCaps();
        }
        xMPPConnection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                if (!EntityCapsManager.this.entityCapsEnabled()) {
                    return;
                }
                CapsExtension capsExtension = (CapsExtension)packet.getExtension(EntityCapsManager.ELEMENT, EntityCapsManager.NAMESPACE);
                String string = capsExtension.getHash().toLowerCase(Locale.US);
                if (!SUPPORTED_HASHES.containsKey(string)) {
                    return;
                }
                String string2 = packet.getFrom();
                String string3 = capsExtension.getNode();
                String string4 = capsExtension.getVer();
                jidCaps.put(string2, new NodeVerHash(string3, string4, string));
            }
        }, PRESENCES_WITH_CAPS);
        xMPPConnection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                String string = packet.getFrom();
                jidCaps.remove(string);
            }
        }, PRESENCES_WITHOUT_CAPS);
        xMPPConnection.addPacketSendingListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                EntityCapsManager.this.presenceSend = true;
            }
        }, PRESENCES);
        PacketInterceptor packetInterceptor = new PacketInterceptor(){

            @Override
            public void interceptPacket(Packet packet) {
                if (!EntityCapsManager.this.entityCapsEnabled) {
                    return;
                }
                CapsExtension capsExtension = new CapsExtension(EntityCapsManager.this.entityNode, EntityCapsManager.this.getCapsVersion(), "sha-1");
                packet.addExtension(capsExtension);
            }
        };
        xMPPConnection.addPacketInterceptor(packetInterceptor, PRESENCES);
        this.sdm.setEntityCapsManager(this);
    }

    public static synchronized EntityCapsManager getInstanceFor(XMPPConnection xMPPConnection) {
        if (SUPPORTED_HASHES.size() <= 0) {
            throw new IllegalStateException("No supported hashes for EntityCapsManager");
        }
        EntityCapsManager entityCapsManager = instances.get(xMPPConnection);
        if (entityCapsManager == null) {
            entityCapsManager = new EntityCapsManager(xMPPConnection);
        }
        return entityCapsManager;
    }

    public synchronized void enableEntityCaps() {
        this.sdm.addFeature(NAMESPACE);
        this.updateLocalEntityCaps();
        this.entityCapsEnabled = true;
    }

    public synchronized void disableEntityCaps() {
        this.entityCapsEnabled = false;
        this.sdm.removeFeature(NAMESPACE);
    }

    public boolean entityCapsEnabled() {
        return this.entityCapsEnabled;
    }

    public void setEntityNode(String string) throws SmackException.NotConnectedException {
        this.entityNode = string;
        this.updateLocalEntityCaps();
    }

    public void removeUserCapsNode(String string) {
        jidCaps.remove(string);
    }

    public String getCapsVersion() {
        return this.currentCapsVersion;
    }

    public String getLocalNodeVer() {
        return this.entityNode + '#' + this.getCapsVersion();
    }

    public boolean areEntityCapsSupported(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.sdm.supportsFeature(string, NAMESPACE);
    }

    public boolean areEntityCapsSupportedByServer() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.areEntityCapsSupported(this.connection().getServiceName());
    }

    public void updateLocalEntityCaps() {
        Object object;
        XMPPConnection xMPPConnection = this.connection();
        DiscoverInfo discoverInfo = new DiscoverInfo();
        discoverInfo.setType(IQ.Type.RESULT);
        discoverInfo.setNode(this.getLocalNodeVer());
        if (xMPPConnection != null) {
            discoverInfo.setFrom(xMPPConnection.getUser());
        }
        this.sdm.addDiscoverInfoTo(discoverInfo);
        this.currentCapsVersion = EntityCapsManager.generateVerificationString(discoverInfo, "sha-1");
        EntityCapsManager.addDiscoverInfoByNode(this.entityNode + '#' + this.currentCapsVersion, discoverInfo);
        if (this.lastLocalCapsVersions.size() > 10) {
            object = this.lastLocalCapsVersions.poll();
            this.sdm.removeNodeInformationProvider(this.entityNode + '#' + (String)object);
        }
        this.lastLocalCapsVersions.add(this.currentCapsVersion);
        caps.put(this.currentCapsVersion, discoverInfo);
        if (xMPPConnection != null) {
            jidCaps.put(xMPPConnection.getUser(), new NodeVerHash(this.entityNode, this.currentCapsVersion, "sha-1"));
        }
        object = new LinkedList<DiscoverInfo.Identity>(ServiceDiscoveryManager.getInstanceFor(xMPPConnection).getIdentities());
        this.sdm.setNodeInformationProvider(this.entityNode + '#' + this.currentCapsVersion, new NodeInformationProvider((List)object){
            List<String> features;
            List<PacketExtension> packetExtensions;
            final /* synthetic */ List val$identities;
            {
                this.val$identities = list;
                this.features = EntityCapsManager.this.sdm.getFeaturesList();
                this.packetExtensions = EntityCapsManager.this.sdm.getExtendedInfoAsList();
            }

            @Override
            public List<DiscoverItems.Item> getNodeItems() {
                return null;
            }

            @Override
            public List<String> getNodeFeatures() {
                return this.features;
            }

            @Override
            public List<DiscoverInfo.Identity> getNodeIdentities() {
                return this.val$identities;
            }

            @Override
            public List<PacketExtension> getNodePacketExtensions() {
                return this.packetExtensions;
            }
        });
        if (xMPPConnection != null && xMPPConnection.isAuthenticated() && this.presenceSend) {
            Presence presence = new Presence(Presence.Type.available);
            try {
                xMPPConnection.sendPacket(presence);
            }
            catch (SmackException.NotConnectedException notConnectedException) {
                LOGGER.log(Level.WARNING, "Could could not update presence with caps info", notConnectedException);
            }
        }
    }

    public static boolean verifyDiscoverInfoVersion(String string, String string2, DiscoverInfo discoverInfo) {
        if (discoverInfo.containsDuplicateIdentities()) {
            return false;
        }
        if (discoverInfo.containsDuplicateFeatures()) {
            return false;
        }
        if (EntityCapsManager.verifyPacketExtensions(discoverInfo)) {
            return false;
        }
        String string3 = EntityCapsManager.generateVerificationString(discoverInfo, string2);
        return string.equals(string3);
    }

    protected static boolean verifyPacketExtensions(DiscoverInfo discoverInfo) {
        LinkedList<FormField> linkedList = new LinkedList<FormField>();
        for (PacketExtension packetExtension : discoverInfo.getExtensions()) {
            if (!packetExtension.getNamespace().equals("jabber:x:data")) continue;
            DataForm dataForm = (DataForm)packetExtension;
            for (FormField formField : dataForm.getFields()) {
                if (!formField.getVariable().equals("FORM_TYPE")) continue;
                for (FormField formField2 : linkedList) {
                    if (!formField.equals(formField2)) continue;
                    return true;
                }
                linkedList.add(formField);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String generateVerificationString(DiscoverInfo discoverInfo, String string) {
        byte[] byArray;
        MessageDigest messageDigest = SUPPORTED_HASHES.get(string.toLowerCase(Locale.US));
        if (messageDigest == null) {
            return null;
        }
        DataForm dataForm = (DataForm)discoverInfo.getExtension("x", "jabber:x:data");
        StringBuilder stringBuilder = new StringBuilder();
        TreeSet<DiscoverInfo.Identity> treeSet2 = new TreeSet<DiscoverInfo.Identity>();
        for (DiscoverInfo.Identity object2 : discoverInfo.getIdentities()) {
            treeSet2.add(object2);
        }
        for (DiscoverInfo.Identity identity : treeSet2) {
            stringBuilder.append(identity.getCategory());
            stringBuilder.append("/");
            stringBuilder.append(identity.getType());
            stringBuilder.append("/");
            stringBuilder.append(identity.getLanguage() == null ? "" : identity.getLanguage());
            stringBuilder.append("/");
            stringBuilder.append(identity.getName() == null ? "" : identity.getName());
            stringBuilder.append("<");
        }
        TreeSet treeSet3 = new TreeSet();
        for (DiscoverInfo.Feature feature : discoverInfo.getFeatures()) {
            treeSet3.add(feature.getVar());
        }
        Iterator iterator = treeSet3.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            stringBuilder.append(string2);
            stringBuilder.append("<");
        }
        if (dataForm != null && dataForm.hasHiddenFormTypeField()) {
            DataForm dataForm2 = dataForm;
            synchronized (dataForm2) {
                TreeSet<FormField> treeSet = new TreeSet<FormField>(new Comparator<FormField>(){

                    @Override
                    public int compare(FormField formField, FormField formField2) {
                        return formField.getVariable().compareTo(formField2.getVariable());
                    }
                });
                FormField formField = null;
                for (FormField formField2 : dataForm.getFields()) {
                    if (!formField2.getVariable().equals("FORM_TYPE")) {
                        treeSet.add(formField2);
                        continue;
                    }
                    formField = formField2;
                }
                if (formField != null) {
                    EntityCapsManager.formFieldValuesToCaps(formField.getValues(), stringBuilder);
                }
                for (FormField formField2 : treeSet) {
                    stringBuilder.append(formField2.getVariable());
                    stringBuilder.append("<");
                    EntityCapsManager.formFieldValuesToCaps(formField2.getValues(), stringBuilder);
                }
            }
        }
        MessageDigest messageDigest2 = messageDigest;
        synchronized (messageDigest2) {
            byArray = messageDigest.digest(stringBuilder.toString().getBytes());
        }
        return Base64.encodeBytes(byArray);
    }

    private static void formFieldValuesToCaps(List<String> list, StringBuilder stringBuilder) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : list) {
            treeSet.add(string);
        }
        for (String string : treeSet) {
            stringBuilder.append(string);
            stringBuilder.append("<");
        }
    }

    static {
        autoEnableEntityCaps = true;
        instances = Collections.synchronizedMap(new WeakHashMap());
        PRESENCES_WITH_CAPS = new AndFilter(new PacketTypeFilter(Presence.class), new PacketExtensionFilter(ELEMENT, NAMESPACE));
        PRESENCES_WITHOUT_CAPS = new AndFilter(new PacketTypeFilter(Presence.class), new NotFilter(new PacketExtensionFilter(ELEMENT, NAMESPACE)));
        PRESENCES = new PacketTypeFilter(Presence.class);
        caps = new Cache<String, DiscoverInfo>(1000, -1L);
        jidCaps = new Cache<String, NodeVerHash>(10000, -1L);
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection xMPPConnection) {
                EntityCapsManager.getInstanceFor(xMPPConnection);
            }
        });
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            SUPPORTED_HASHES.put("sha-1", messageDigest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public static class NodeVerHash {
        private String node;
        private String hash;
        private String ver;
        private String nodeVer;

        NodeVerHash(String string, String string2, String string3) {
            this.node = string;
            this.ver = string2;
            this.hash = string3;
            this.nodeVer = string + "#" + string2;
        }

        public String getNodeVer() {
            return this.nodeVer;
        }

        public String getNode() {
            return this.node;
        }

        public String getHash() {
            return this.hash;
        }

        public String getVer() {
            return this.ver;
        }
    }
}

