/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.caps.cache;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.Base32Encoder;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.StringEncoder;
import org.jivesoftware.smackx.caps.EntityCapsManager;
import org.jivesoftware.smackx.caps.cache.EntityCapsPersistentCache;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.provider.DiscoverInfoProvider;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SimpleDirectoryPersistentCache
implements EntityCapsPersistentCache {
    private static final Logger LOGGER = Logger.getLogger(SimpleDirectoryPersistentCache.class.getName());
    private File cacheDir;
    private StringEncoder filenameEncoder;

    public SimpleDirectoryPersistentCache(File file) {
        this(file, Base32Encoder.getInstance());
    }

    public SimpleDirectoryPersistentCache(File file, StringEncoder stringEncoder) {
        if (!file.exists()) {
            throw new IllegalStateException("Cache directory \"" + file + "\" does not exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalStateException("Cache directory \"" + file + "\" is not a directory");
        }
        this.cacheDir = file;
        this.filenameEncoder = stringEncoder;
    }

    @Override
    public void addDiscoverInfoByNodePersistent(String string, DiscoverInfo discoverInfo) {
        String string2 = this.filenameEncoder.encode(string);
        File file = new File(this.cacheDir, string2);
        try {
            if (file.createNewFile()) {
                SimpleDirectoryPersistentCache.writeInfoToFile(file, discoverInfo);
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Failed to write disco info to file", iOException);
        }
    }

    @Override
    public void replay() throws IOException {
        File[] fileArray;
        for (File file : fileArray = this.cacheDir.listFiles()) {
            String string = this.filenameEncoder.decode(file.getName());
            DiscoverInfo discoverInfo = SimpleDirectoryPersistentCache.restoreInfoFromFile(file);
            if (discoverInfo == null) continue;
            EntityCapsManager.addDiscoverInfoByNode(string, discoverInfo);
        }
    }

    @Override
    public void emptyCache() {
        File[] fileArray;
        for (File file : fileArray = this.cacheDir.listFiles()) {
            file.delete();
        }
    }

    private static void writeInfoToFile(File file, DiscoverInfo discoverInfo) throws IOException {
        try (DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));){
            dataOutputStream.writeUTF(discoverInfo.toXML().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DiscoverInfo restoreInfoFromFile(File file) throws IOException {
        DiscoverInfo discoverInfo;
        String string;
        String string2;
        String string3;
        XmlPullParser xmlPullParser;
        String string4 = null;
        try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));){
            string4 = dataInputStream.readUTF();
        }
        if (string4 == null) {
            return null;
        }
        StringReader stringReader = new StringReader(string4);
        try {
            xmlPullParser = PacketParserUtils.newXmppParser();
            xmlPullParser.setInput((Reader)stringReader);
        }
        catch (XmlPullParserException xmlPullParserException) {
            LOGGER.log(Level.SEVERE, "Exception initializing parser", xmlPullParserException);
            return null;
        }
        DiscoverInfoProvider discoverInfoProvider = new DiscoverInfoProvider();
        try {
            xmlPullParser.next();
            string3 = xmlPullParser.getAttributeValue("", "id");
            string2 = xmlPullParser.getAttributeValue("", "from");
            string = xmlPullParser.getAttributeValue("", "to");
            xmlPullParser.next();
        }
        catch (XmlPullParserException xmlPullParserException) {
            return null;
        }
        try {
            discoverInfo = (DiscoverInfo)discoverInfoProvider.parseIQ(xmlPullParser);
        }
        catch (Exception exception) {
            return null;
        }
        discoverInfo.setPacketID(string3);
        discoverInfo.setFrom(string2);
        discoverInfo.setTo(string);
        discoverInfo.setType(IQ.Type.RESULT);
        return discoverInfo;
    }
}

