/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.carbons;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.IQReplyFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.carbons.packet.CarbonExtension;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;

public class CarbonManager
extends Manager {
    private static Map<XMPPConnection, CarbonManager> instances = Collections.synchronizedMap(new WeakHashMap());
    private volatile boolean enabled_state = false;

    private CarbonManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        serviceDiscoveryManager.addFeature("urn:xmpp:carbons:2");
        instances.put(xMPPConnection, this);
    }

    public static synchronized CarbonManager getInstanceFor(XMPPConnection xMPPConnection) {
        CarbonManager carbonManager = instances.get(xMPPConnection);
        if (carbonManager == null) {
            carbonManager = new CarbonManager(xMPPConnection);
        }
        return carbonManager;
    }

    private IQ carbonsEnabledIQ(final boolean bl) {
        IQ iQ = new IQ(){

            @Override
            public String getChildElementXML() {
                return "<" + (bl ? "enable" : "disable") + " xmlns='" + "urn:xmpp:carbons:2" + "'/>";
            }
        };
        iQ.setType(IQ.Type.SET);
        return iQ;
    }

    public boolean isSupportedByServer() throws XMPPException, SmackException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(this.connection().getServiceName(), "urn:xmpp:carbons:2");
    }

    public void sendCarbonsEnabled(final boolean bl) throws SmackException.NotConnectedException {
        IQ iQ = this.carbonsEnabledIQ(bl);
        this.connection().addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                IQ iQ = (IQ)packet;
                if (iQ.getType() == IQ.Type.RESULT) {
                    CarbonManager.this.enabled_state = bl;
                }
                CarbonManager.this.connection().removePacketListener(this);
            }
        }, new IQReplyFilter(iQ, this.connection()));
        this.connection().sendPacket(iQ);
    }

    public synchronized void setCarbonsEnabled(boolean bl) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (this.enabled_state == bl) {
            return;
        }
        IQ iQ = this.carbonsEnabledIQ(bl);
        this.connection().createPacketCollectorAndSend(iQ).nextResultOrThrow();
        this.enabled_state = bl;
    }

    public void enableCarbons() throws XMPPException, SmackException {
        this.setCarbonsEnabled(true);
    }

    public void disableCarbons() throws XMPPException, SmackException {
        this.setCarbonsEnabled(false);
    }

    public boolean getCarbonsEnabled() {
        return this.enabled_state;
    }

    public static CarbonExtension getCarbon(Message message) {
        CarbonExtension carbonExtension = (CarbonExtension)message.getExtension("received", "urn:xmpp:carbons:2");
        if (carbonExtension == null) {
            carbonExtension = (CarbonExtension)message.getExtension("sent", "urn:xmpp:carbons:2");
        }
        return carbonExtension;
    }

    public static void disableCarbons(Message message) {
        message.addExtension(new CarbonExtension.Private());
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection xMPPConnection) {
                CarbonManager.getInstanceFor(xMPPConnection);
            }
        });
    }
}

