/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco.packet;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class DiscoverItems
extends IQ {
    public static final String NAMESPACE = "http://jabber.org/protocol/disco#items";
    private final List<Item> items = new LinkedList<Item>();
    private String node;

    public void addItem(Item item) {
        this.items.add(item);
    }

    public void addItems(Collection<Item> collection) {
        if (collection == null) {
            return;
        }
        for (Item item : collection) {
            this.addItem(item);
        }
    }

    public List<Item> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String string) {
        this.node = string;
    }

    @Override
    public XmlStringBuilder getChildElementXML() {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
        xmlStringBuilder.halfOpenElement("query");
        xmlStringBuilder.xmlnsAttribute(NAMESPACE);
        xmlStringBuilder.optAttribute("node", this.getNode());
        xmlStringBuilder.rightAngelBracket();
        for (Item item : this.items) {
            xmlStringBuilder.append(item.toXML());
        }
        xmlStringBuilder.closeElement("query");
        return xmlStringBuilder;
    }

    public static class Item {
        public static final String UPDATE_ACTION = "update";
        public static final String REMOVE_ACTION = "remove";
        private String entityID;
        private String name;
        private String node;
        private String action;

        public Item(String string) {
            this.entityID = string;
        }

        public String getEntityID() {
            return this.entityID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getNode() {
            return this.node;
        }

        public void setNode(String string) {
            this.node = string;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String string) {
            this.action = string;
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
            xmlStringBuilder.halfOpenElement("item");
            xmlStringBuilder.attribute("jid", this.entityID);
            xmlStringBuilder.optAttribute("name", this.name);
            xmlStringBuilder.optAttribute("node", this.node);
            xmlStringBuilder.optAttribute("action", this.action);
            xmlStringBuilder.closeEmptyElement();
            return xmlStringBuilder;
        }
    }
}

