/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.filetransfer.FaultTolerantNegotiator;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IBBTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.Socks5TransferNegotiator;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class FileTransferNegotiator {
    private static final String[] NAMESPACE = new String[]{"http://jabber.org/protocol/si/profile/file-transfer", "http://jabber.org/protocol/si"};
    private static final Map<XMPPConnection, FileTransferNegotiator> transferObject = new ConcurrentHashMap<XMPPConnection, FileTransferNegotiator>();
    private static final String STREAM_INIT_PREFIX = "jsi_";
    protected static final String STREAM_DATA_FIELD_NAME = "stream-method";
    private static final Random randomGenerator = new Random();
    public static boolean IBB_ONLY = System.getProperty("ibb") != null;
    private final XMPPConnection connection;
    private final StreamNegotiator byteStreamTransferManager;
    private final StreamNegotiator inbandTransferManager;

    public static FileTransferNegotiator getInstanceFor(XMPPConnection xMPPConnection) {
        if (xMPPConnection == null) {
            throw new IllegalArgumentException("XMPPConnection cannot be null");
        }
        if (!xMPPConnection.isConnected()) {
            return null;
        }
        if (transferObject.containsKey(xMPPConnection)) {
            return transferObject.get(xMPPConnection);
        }
        FileTransferNegotiator fileTransferNegotiator = new FileTransferNegotiator(xMPPConnection);
        FileTransferNegotiator.setServiceEnabled(xMPPConnection, true);
        transferObject.put(xMPPConnection, fileTransferNegotiator);
        return fileTransferNegotiator;
    }

    public static void setServiceEnabled(XMPPConnection xMPPConnection, boolean bl) {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(NAMESPACE));
        arrayList.add("http://jabber.org/protocol/ibb");
        if (!IBB_ONLY) {
            arrayList.add("http://jabber.org/protocol/bytestreams");
        }
        for (String string : arrayList) {
            if (bl) {
                if (serviceDiscoveryManager.includesFeature(string)) continue;
                serviceDiscoveryManager.addFeature(string);
                continue;
            }
            serviceDiscoveryManager.removeFeature(string);
        }
    }

    public static boolean isServiceEnabled(XMPPConnection xMPPConnection) {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(NAMESPACE));
        arrayList.add("http://jabber.org/protocol/ibb");
        if (!IBB_ONLY) {
            arrayList.add("http://jabber.org/protocol/bytestreams");
        }
        for (String string : arrayList) {
            if (serviceDiscoveryManager.includesFeature(string)) continue;
            return false;
        }
        return true;
    }

    public static IQ createIQ(String string, String string2, String string3, IQ.Type type) {
        IQ iQ = new IQ(){

            @Override
            public String getChildElementXML() {
                return null;
            }
        };
        iQ.setPacketID(string);
        iQ.setTo(string2);
        iQ.setFrom(string3);
        iQ.setType(type);
        return iQ;
    }

    public static Collection<String> getSupportedProtocols() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("http://jabber.org/protocol/ibb");
        if (!IBB_ONLY) {
            arrayList.add("http://jabber.org/protocol/bytestreams");
        }
        return Collections.unmodifiableList(arrayList);
    }

    private FileTransferNegotiator(XMPPConnection xMPPConnection) {
        this.configureConnection(xMPPConnection);
        this.connection = xMPPConnection;
        this.byteStreamTransferManager = new Socks5TransferNegotiator(xMPPConnection);
        this.inbandTransferManager = new IBBTransferNegotiator(xMPPConnection);
    }

    private void configureConnection(final XMPPConnection xMPPConnection) {
        xMPPConnection.addConnectionListener(new AbstractConnectionListener(){

            @Override
            public void connectionClosed() {
                FileTransferNegotiator.this.cleanup(xMPPConnection);
            }

            @Override
            public void connectionClosedOnError(Exception exception) {
                FileTransferNegotiator.this.cleanup(xMPPConnection);
            }
        });
    }

    private void cleanup(XMPPConnection xMPPConnection) {
        if (transferObject.remove(xMPPConnection) != null) {
            this.inbandTransferManager.cleanup();
        }
    }

    public StreamNegotiator selectStreamNegotiator(FileTransferRequest fileTransferRequest) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        StreamNegotiator streamNegotiator;
        StreamInitiation streamInitiation = fileTransferRequest.getStreamInitiation();
        FormField formField = this.getStreamMethodField(streamInitiation.getFeatureNegotiationForm());
        if (formField == null) {
            String string = "No stream methods contained in packet.";
            XMPPError xMPPError = new XMPPError(XMPPError.Condition.bad_request, string);
            IQ iQ = FileTransferNegotiator.createIQ(streamInitiation.getPacketID(), streamInitiation.getFrom(), streamInitiation.getTo(), IQ.Type.ERROR);
            iQ.setError(xMPPError);
            this.connection.sendPacket(iQ);
            throw new XMPPException.XMPPErrorException(string, xMPPError);
        }
        try {
            streamNegotiator = this.getNegotiator(formField);
        }
        catch (XMPPException.XMPPErrorException xMPPErrorException) {
            IQ iQ = FileTransferNegotiator.createIQ(streamInitiation.getPacketID(), streamInitiation.getFrom(), streamInitiation.getTo(), IQ.Type.ERROR);
            iQ.setError(xMPPErrorException.getXMPPError());
            this.connection.sendPacket(iQ);
            throw xMPPErrorException;
        }
        return streamNegotiator;
    }

    private FormField getStreamMethodField(DataForm dataForm) {
        for (FormField formField : dataForm.getFields()) {
            if (!formField.getVariable().equals(STREAM_DATA_FIELD_NAME)) continue;
            return formField;
        }
        return null;
    }

    private StreamNegotiator getNegotiator(FormField formField) throws XMPPException.XMPPErrorException {
        boolean bl = false;
        boolean bl2 = false;
        for (FormField.Option option : formField.getOptions()) {
            String string = option.getValue();
            if (string.equals("http://jabber.org/protocol/bytestreams") && !IBB_ONLY) {
                bl = true;
                continue;
            }
            if (!string.equals("http://jabber.org/protocol/ibb")) continue;
            bl2 = true;
        }
        if (!bl && !bl2) {
            XMPPError xMPPError = new XMPPError(XMPPError.Condition.bad_request, "No acceptable transfer mechanism");
            throw new XMPPException.XMPPErrorException(xMPPError);
        }
        if (bl && bl2) {
            return new FaultTolerantNegotiator(this.connection, this.byteStreamTransferManager, this.inbandTransferManager);
        }
        if (bl) {
            return this.byteStreamTransferManager;
        }
        return this.inbandTransferManager;
    }

    public String getNextStreamID() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(STREAM_INIT_PREFIX);
        stringBuilder.append(Math.abs(randomGenerator.nextLong()));
        return stringBuilder.toString();
    }

    public StreamNegotiator negotiateOutgoingTransfer(String string, String string2, String string3, long l, String string4, int n) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        StreamInitiation streamInitiation = new StreamInitiation();
        streamInitiation.setSessionID(string2);
        streamInitiation.setMimeType(URLConnection.guessContentTypeFromName(string3));
        StreamInitiation.File file = new StreamInitiation.File(string3, l);
        file.setDesc(string4);
        streamInitiation.setFile(file);
        streamInitiation.setFeatureNegotiationForm(this.createDefaultInitiationForm());
        streamInitiation.setFrom(this.connection.getUser());
        streamInitiation.setTo(string);
        streamInitiation.setType(IQ.Type.SET);
        PacketCollector packetCollector = this.connection.createPacketCollectorAndSend(streamInitiation);
        Packet packet = packetCollector.nextResult(n);
        packetCollector.cancel();
        if (packet instanceof IQ) {
            IQ iQ = (IQ)packet;
            if (iQ.getType().equals(IQ.Type.RESULT)) {
                StreamInitiation streamInitiation2 = (StreamInitiation)packet;
                return this.getOutgoingNegotiator(this.getStreamMethodField(streamInitiation2.getFeatureNegotiationForm()));
            }
            throw new XMPPException.XMPPErrorException(iQ.getError());
        }
        return null;
    }

    private StreamNegotiator getOutgoingNegotiator(FormField formField) throws XMPPException.XMPPErrorException {
        boolean bl = false;
        boolean bl2 = false;
        for (String string : formField.getValues()) {
            if (string.equals("http://jabber.org/protocol/bytestreams") && !IBB_ONLY) {
                bl = true;
                continue;
            }
            if (!string.equals("http://jabber.org/protocol/ibb")) continue;
            bl2 = true;
        }
        if (!bl && !bl2) {
            XMPPError xMPPError = new XMPPError(XMPPError.Condition.bad_request, "No acceptable transfer mechanism");
            throw new XMPPException.XMPPErrorException(xMPPError);
        }
        if (bl && bl2) {
            return new FaultTolerantNegotiator(this.connection, this.byteStreamTransferManager, this.inbandTransferManager);
        }
        if (bl) {
            return this.byteStreamTransferManager;
        }
        return this.inbandTransferManager;
    }

    private DataForm createDefaultInitiationForm() {
        DataForm dataForm = new DataForm("form");
        FormField formField = new FormField(STREAM_DATA_FIELD_NAME);
        formField.setType("list-single");
        if (!IBB_ONLY) {
            formField.addOption(new FormField.Option("http://jabber.org/protocol/bytestreams"));
        }
        formField.addOption(new FormField.Option("http://jabber.org/protocol/ibb"));
        dataForm.addField(formField);
        return dataForm;
    }
}

