/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.hoxt.packet;

import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.hoxt.packet.AbstractHttpOverXmpp;
import org.jivesoftware.smackx.hoxt.packet.HttpMethod;

public class HttpOverXmppReq
extends AbstractHttpOverXmpp {
    private Req req;

    @Override
    public String getChildElementXML() {
        return this.req.toXML();
    }

    public Req getReq() {
        return this.req;
    }

    public void setReq(Req req) {
        this.req = req;
    }

    public static class Req
    extends AbstractHttpOverXmpp.AbstractBody {
        private HttpMethod method;
        private String resource;
        private int maxChunkSize = 0;
        private boolean sipub = true;
        private boolean ibb = true;
        private boolean jingle = true;

        public Req(HttpMethod httpMethod, String string) {
            this.method = httpMethod;
            this.resource = string;
        }

        @Override
        protected String getStartTag() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<req");
            stringBuilder.append(" ");
            stringBuilder.append("xmlns='").append("urn:xmpp:http").append("'");
            stringBuilder.append(" ");
            stringBuilder.append("method='").append(this.method.toString()).append("'");
            stringBuilder.append(" ");
            stringBuilder.append("resource='").append(StringUtils.escapeForXML(this.resource)).append("'");
            stringBuilder.append(" ");
            stringBuilder.append("version='").append(StringUtils.escapeForXML(this.version)).append("'");
            if (this.maxChunkSize != 0) {
                stringBuilder.append(" ");
                stringBuilder.append("maxChunkSize='").append(Integer.toString(this.maxChunkSize)).append("'");
            }
            stringBuilder.append(" ");
            stringBuilder.append("sipub='").append(Boolean.toString(this.sipub)).append("'");
            stringBuilder.append(" ");
            stringBuilder.append("ibb='").append(Boolean.toString(this.ibb)).append("'");
            stringBuilder.append(" ");
            stringBuilder.append("jingle='").append(Boolean.toString(this.jingle)).append("'");
            stringBuilder.append(">");
            return stringBuilder.toString();
        }

        @Override
        protected String getEndTag() {
            return "</req>";
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public String getResource() {
            return this.resource;
        }

        public int getMaxChunkSize() {
            return this.maxChunkSize;
        }

        public void setMaxChunkSize(int n) {
            this.maxChunkSize = n;
        }

        public boolean isSipub() {
            return this.sipub;
        }

        public void setSipub(boolean bl) {
            this.sipub = bl;
        }

        public boolean isIbb() {
            return this.ibb;
        }

        public void setIbb(boolean bl) {
            this.ibb = bl;
        }

        public boolean isJingle() {
            return this.jingle;
        }

        public void setJingle(boolean bl) {
            this.jingle = bl;
        }
    }
}

