/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqlast;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.iqlast.packet.LastActivity;

public class LastActivityManager
extends Manager {
    private static final Map<XMPPConnection, LastActivityManager> instances = new WeakHashMap<XMPPConnection, LastActivityManager>();
    private static final PacketFilter IQ_GET_LAST_FILTER = new AndFilter(new IQTypeFilter(IQ.Type.GET), new PacketTypeFilter(LastActivity.class));
    private static boolean enabledPerDefault = true;
    private volatile long lastMessageSent;
    private boolean enabled = false;

    public static void setEnabledPerDefault(boolean bl) {
        enabledPerDefault = bl;
    }

    public static synchronized LastActivityManager getInstanceFor(XMPPConnection xMPPConnection) {
        LastActivityManager lastActivityManager = instances.get(xMPPConnection);
        if (lastActivityManager == null) {
            lastActivityManager = new LastActivityManager(xMPPConnection);
        }
        return lastActivityManager;
    }

    private LastActivityManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        xMPPConnection.addPacketSendingListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Presence presence = (Presence)packet;
                Presence.Mode mode = presence.getMode();
                if (mode == null) {
                    return;
                }
                switch (mode) {
                    case available: 
                    case chat: {
                        LastActivityManager.this.resetIdleTime();
                    }
                }
            }
        }, PacketTypeFilter.PRESENCE);
        xMPPConnection.addPacketSendingListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Message message = (Message)packet;
                if (message.getType() == Message.Type.error) {
                    return;
                }
                LastActivityManager.this.resetIdleTime();
            }
        }, PacketTypeFilter.MESSAGE);
        xMPPConnection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) throws SmackException.NotConnectedException {
                if (!LastActivityManager.this.enabled) {
                    return;
                }
                LastActivity lastActivity = new LastActivity();
                lastActivity.setType(IQ.Type.RESULT);
                lastActivity.setTo(packet.getFrom());
                lastActivity.setFrom(packet.getTo());
                lastActivity.setPacketID(packet.getPacketID());
                lastActivity.setLastActivity(LastActivityManager.this.getIdleTime());
                LastActivityManager.this.connection().sendPacket(lastActivity);
            }
        }, IQ_GET_LAST_FILTER);
        if (enabledPerDefault) {
            this.enable();
        }
        this.resetIdleTime();
        instances.put(xMPPConnection, this);
    }

    public synchronized void enable() {
        ServiceDiscoveryManager.getInstanceFor(this.connection()).addFeature("jabber:iq:last");
        this.enabled = true;
    }

    public synchronized void disable() {
        ServiceDiscoveryManager.getInstanceFor(this.connection()).removeFeature("jabber:iq:last");
        this.enabled = false;
    }

    private void resetIdleTime() {
        this.lastMessageSent = System.currentTimeMillis();
    }

    private long getIdleTime() {
        long l = this.lastMessageSent;
        long l2 = System.currentTimeMillis();
        return (l2 - l) / 1000L;
    }

    public LastActivity getLastActivity(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        LastActivity lastActivity = new LastActivity(string);
        return (LastActivity)this.connection().createPacketCollectorAndSend(lastActivity).nextResultOrThrow();
    }

    public boolean isLastActivitySupported(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(string, "jabber:iq:last");
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection xMPPConnection) {
                LastActivityManager.getInstanceFor(xMPPConnection);
            }
        });
    }
}

