/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqprivate;

import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.iqprivate.packet.DefaultPrivateData;
import org.jivesoftware.smackx.iqprivate.packet.PrivateData;
import org.jivesoftware.smackx.iqprivate.provider.PrivateDataProvider;
import org.xmlpull.v1.XmlPullParser;

public class PrivateDataManager
extends Manager {
    private static final Map<XMPPConnection, PrivateDataManager> instances = new WeakHashMap<XMPPConnection, PrivateDataManager>();
    private static Map<String, PrivateDataProvider> privateDataProviders = new Hashtable<String, PrivateDataProvider>();

    public static synchronized PrivateDataManager getInstanceFor(XMPPConnection xMPPConnection) {
        PrivateDataManager privateDataManager = instances.get(xMPPConnection);
        if (privateDataManager == null) {
            privateDataManager = new PrivateDataManager(xMPPConnection);
        }
        return privateDataManager;
    }

    public static PrivateDataProvider getPrivateDataProvider(String string, String string2) {
        String string3 = PrivateDataManager.getProviderKey(string, string2);
        return privateDataProviders.get(string3);
    }

    public static void addPrivateDataProvider(String string, String string2, PrivateDataProvider privateDataProvider) {
        String string3 = PrivateDataManager.getProviderKey(string, string2);
        privateDataProviders.put(string3, privateDataProvider);
    }

    public static void removePrivateDataProvider(String string, String string2) {
        String string3 = PrivateDataManager.getProviderKey(string, string2);
        privateDataProviders.remove(string3);
    }

    private PrivateDataManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        instances.put(xMPPConnection, this);
    }

    public PrivateData getPrivateData(final String string, final String string2) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        IQ iQ = new IQ(){

            @Override
            public String getChildElementXML() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<query xmlns=\"jabber:iq:private\">");
                stringBuilder.append("<").append(string).append(" xmlns=\"").append(string2).append("\"/>");
                stringBuilder.append("</query>");
                return stringBuilder.toString();
            }
        };
        iQ.setType(IQ.Type.GET);
        PrivateDataResult privateDataResult = (PrivateDataResult)this.connection().createPacketCollectorAndSend(iQ).nextResultOrThrow();
        return privateDataResult.getPrivateData();
    }

    public void setPrivateData(final PrivateData privateData) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        IQ iQ = new IQ(){

            @Override
            public String getChildElementXML() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<query xmlns=\"jabber:iq:private\">");
                stringBuilder.append(privateData.toXML());
                stringBuilder.append("</query>");
                return stringBuilder.toString();
            }
        };
        iQ.setType(IQ.Type.SET);
        this.connection().createPacketCollectorAndSend(iQ).nextResultOrThrow();
    }

    private static String getProviderKey(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(string).append("/><").append(string2).append("/>");
        return stringBuilder.toString();
    }

    private static class PrivateDataResult
    extends IQ {
        private PrivateData privateData;

        PrivateDataResult(PrivateData privateData) {
            this.privateData = privateData;
        }

        public PrivateData getPrivateData() {
            return this.privateData;
        }

        @Override
        public String getChildElementXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<query xmlns=\"jabber:iq:private\">");
            if (this.privateData != null) {
                stringBuilder.append(this.privateData.toXML());
            }
            stringBuilder.append("</query>");
            return stringBuilder.toString();
        }
    }

    public static class PrivateDataIQProvider
    implements IQProvider {
        @Override
        public IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
            PrivateData privateData = null;
            boolean bl = false;
            while (!bl) {
                int n = xmlPullParser.next();
                if (n == 2) {
                    String string;
                    String string2 = xmlPullParser.getName();
                    PrivateDataProvider privateDataProvider = PrivateDataManager.getPrivateDataProvider(string2, string = xmlPullParser.getNamespace());
                    if (privateDataProvider != null) {
                        privateData = privateDataProvider.parsePrivateData(xmlPullParser);
                        continue;
                    }
                    DefaultPrivateData defaultPrivateData = new DefaultPrivateData(string2, string);
                    boolean bl2 = false;
                    while (!bl2) {
                        int n2 = xmlPullParser.next();
                        if (n2 == 2) {
                            String string3 = xmlPullParser.getName();
                            if (xmlPullParser.isEmptyElementTag()) {
                                defaultPrivateData.setValue(string3, "");
                                continue;
                            }
                            n2 = xmlPullParser.next();
                            if (n2 != 4) continue;
                            String string4 = xmlPullParser.getText();
                            defaultPrivateData.setValue(string3, string4);
                            continue;
                        }
                        if (n2 != 3 || !xmlPullParser.getName().equals(string2)) continue;
                        bl2 = true;
                    }
                    privateData = defaultPrivateData;
                    continue;
                }
                if (n != 3 || !xmlPullParser.getName().equals("query")) continue;
                bl = true;
            }
            return new PrivateDataResult(privateData);
        }
    }
}

