/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jiveproperties.provider;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.jiveproperties.JivePropertiesManager;
import org.jivesoftware.smackx.jiveproperties.packet.JivePropertiesExtension;
import org.xmlpull.v1.XmlPullParser;

public class JivePropertiesExtensionProvider
implements PacketExtensionProvider {
    private static final Logger LOGGER = Logger.getLogger(JivePropertiesExtensionProvider.class.getName());

    @Override
    public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        block2: while (true) {
            int n;
            if ((n = xmlPullParser.next()) == 2 && xmlPullParser.getName().equals("property")) {
                boolean bl = false;
                String string = null;
                String string2 = null;
                String string3 = null;
                Object object = null;
                while (true) {
                    Object object2;
                    if (bl) continue block2;
                    n = xmlPullParser.next();
                    if (n == 2) {
                        object2 = xmlPullParser.getName();
                        if (((String)object2).equals("name")) {
                            string = xmlPullParser.nextText();
                            continue;
                        }
                        if (!((String)object2).equals("value")) continue;
                        string2 = xmlPullParser.getAttributeValue("", "type");
                        string3 = xmlPullParser.nextText();
                        continue;
                    }
                    if (n != 3 || !xmlPullParser.getName().equals("property")) continue;
                    if ("integer".equals(string2)) {
                        object = Integer.valueOf(string3);
                    } else if ("long".equals(string2)) {
                        object = Long.valueOf(string3);
                    } else if ("float".equals(string2)) {
                        object = Float.valueOf(string3);
                    } else if ("double".equals(string2)) {
                        object = Double.valueOf(string3);
                    } else if ("boolean".equals(string2)) {
                        object = Boolean.valueOf(string3);
                    } else if ("string".equals(string2)) {
                        object = string3;
                    } else if ("java-object".equals(string2)) {
                        if (JivePropertiesManager.isJavaObjectEnabled()) {
                            try {
                                object2 = StringUtils.decodeBase64(string3);
                                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream((byte[])object2));
                                object = objectInputStream.readObject();
                            }
                            catch (Exception exception) {
                                LOGGER.log(Level.SEVERE, "Error parsing java object", exception);
                            }
                        } else {
                            LOGGER.severe("JavaObject is not enabled. Enable with JivePropertiesManager.setJavaObjectEnabled(true)");
                        }
                    }
                    if (string != null && object != null) {
                        hashMap.put(string, object);
                    }
                    bl = true;
                }
            }
            if (n == 3 && xmlPullParser.getName().equals("properties")) break;
        }
        return new JivePropertiesExtension(hashMap);
    }
}

