/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ping;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.ping.PingFailedListener;
import org.jivesoftware.smackx.ping.packet.Ping;
import org.jivesoftware.smackx.ping.packet.Pong;

public class PingManager
extends Manager {
    public static final String NAMESPACE = "urn:xmpp:ping";
    private static final Logger LOGGER = Logger.getLogger(PingManager.class.getName());
    private static final Map<XMPPConnection, PingManager> INSTANCES = Collections.synchronizedMap(new WeakHashMap());
    private static final PacketFilter PING_PACKET_FILTER = new AndFilter(new PacketTypeFilter(Ping.class), new IQTypeFilter(IQ.Type.GET));
    private static final PacketFilter PONG_PACKET_FILTER = new AndFilter(new PacketTypeFilter(Pong.class), new IQTypeFilter(IQ.Type.RESULT));
    private static int defaultPingInterval;
    private final Set<PingFailedListener> pingFailedListeners = Collections.synchronizedSet(new HashSet());
    private int pingInterval = defaultPingInterval;
    private ScheduledFuture<?> nextAutomaticPing;
    private long lastPongReceived = -1L;
    private final Runnable pingServerRunnable = new Runnable(){
        private static final int DELTA = 1000;
        private static final int TRIES = 3;

        @Override
        public void run() {
            LOGGER.fine("ServerPingTask run()");
            XMPPConnection xMPPConnection = PingManager.this.connection();
            if (xMPPConnection == null) {
                return;
            }
            if (PingManager.this.pingInterval <= 0) {
                return;
            }
            long l = PingManager.this.getLastReceivedPong();
            if (l > 0L) {
                long l2 = System.currentTimeMillis();
                int n = (int)(((long)(PingManager.this.pingInterval * 1000) - (l2 - l)) / 1000L);
                if (n > 0) {
                    PingManager.this.maybeSchedulePingServerTask(n);
                    return;
                }
            }
            if (xMPPConnection.isAuthenticated()) {
                boolean bl = false;
                for (int i = 0; i < 3; ++i) {
                    if (i != 0) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    try {
                        bl = PingManager.this.pingMyServer(false);
                    }
                    catch (SmackException smackException) {
                        LOGGER.log(Level.WARNING, "SmackError while pinging server", smackException);
                        bl = false;
                    }
                    if (bl) break;
                }
                LOGGER.fine("ServerPingTask res=" + bl);
                if (!bl) {
                    for (PingFailedListener pingFailedListener : PingManager.this.pingFailedListeners) {
                        pingFailedListener.pingFailed();
                    }
                } else {
                    PingManager.this.maybeSchedulePingServerTask();
                }
            } else {
                LOGGER.warning("ServerPingTask: XMPPConnection was not authenticated");
            }
        }
    };

    public static synchronized PingManager getInstanceFor(XMPPConnection xMPPConnection) {
        PingManager pingManager = INSTANCES.get(xMPPConnection);
        if (pingManager == null) {
            pingManager = new PingManager(xMPPConnection);
        }
        return pingManager;
    }

    public static void setDefaultPingInterval(int n) {
        defaultPingInterval = n;
    }

    private PingManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
        serviceDiscoveryManager.addFeature(NAMESPACE);
        INSTANCES.put(xMPPConnection, this);
        xMPPConnection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) throws SmackException.NotConnectedException {
                Pong pong = new Pong(packet);
                PingManager.this.connection().sendPacket(pong);
            }
        }, PING_PACKET_FILTER);
        xMPPConnection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) throws SmackException.NotConnectedException {
                PingManager.this.lastPongReceived = System.currentTimeMillis();
            }
        }, PONG_PACKET_FILTER);
        xMPPConnection.addConnectionListener(new AbstractConnectionListener(){

            @Override
            public void authenticated(XMPPConnection xMPPConnection) {
                PingManager.this.maybeSchedulePingServerTask();
            }

            @Override
            public void connectionClosed() {
                PingManager.this.maybeStopPingServerTask();
            }

            @Override
            public void connectionClosedOnError(Exception exception) {
                PingManager.this.maybeStopPingServerTask();
            }
        });
        this.maybeSchedulePingServerTask();
    }

    public boolean ping(String string, long l) throws SmackException.NotConnectedException, SmackException.NoResponseException {
        Ping ping = new Ping(string);
        try {
            this.connection().createPacketCollectorAndSend(ping).nextResultOrThrow(l);
        }
        catch (XMPPException xMPPException) {
            return string.equals(this.connection().getServiceName());
        }
        return true;
    }

    public boolean ping(String string) throws SmackException.NotConnectedException, SmackException.NoResponseException {
        return this.ping(string, this.connection().getPacketReplyTimeout());
    }

    public boolean isPingSupported(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(string, NAMESPACE);
    }

    public boolean pingMyServer() throws SmackException.NotConnectedException {
        return this.pingMyServer(true);
    }

    public boolean pingMyServer(boolean bl) throws SmackException.NotConnectedException {
        boolean bl2;
        try {
            bl2 = this.ping(this.connection().getServiceName());
        }
        catch (SmackException.NoResponseException noResponseException) {
            bl2 = false;
        }
        if (!bl2 && bl) {
            for (PingFailedListener pingFailedListener : this.pingFailedListeners) {
                pingFailedListener.pingFailed();
            }
        }
        return bl2;
    }

    public void setPingInterval(int n) {
        this.pingInterval = n;
        this.maybeSchedulePingServerTask();
    }

    public int getPingInterval() {
        return this.pingInterval;
    }

    public void registerPingFailedListener(PingFailedListener pingFailedListener) {
        this.pingFailedListeners.add(pingFailedListener);
    }

    public void unregisterPingFailedListener(PingFailedListener pingFailedListener) {
        this.pingFailedListeners.remove(pingFailedListener);
    }

    public long getLastReceivedPong() {
        return this.lastPongReceived;
    }

    private void maybeSchedulePingServerTask() {
        this.maybeSchedulePingServerTask(0);
    }

    private synchronized void maybeSchedulePingServerTask(int n) {
        this.maybeStopPingServerTask();
        if (this.pingInterval > 0) {
            int n2 = this.pingInterval - n;
            LOGGER.fine("Scheduling ServerPingTask in " + n2 + " seconds (pingInterval=" + this.pingInterval + ", delta=" + n + ")");
            this.nextAutomaticPing = this.schedule(this.pingServerRunnable, n2, TimeUnit.SECONDS);
        }
    }

    private void maybeStopPingServerTask() {
        if (this.nextAutomaticPing != null) {
            this.nextAutomaticPing.cancel(true);
            this.nextAutomaticPing = null;
        }
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection xMPPConnection) {
                PingManager.getInstanceFor(xMPPConnection);
            }
        });
        defaultPingInterval = 1800;
    }
}

