/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.pubsub.GetItemsRequest;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.ItemsExtension;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.PublishItem;
import org.jivesoftware.smackx.pubsub.packet.PubSub;

public class LeafNode
extends Node {
    LeafNode(XMPPConnection xMPPConnection, String string) {
        super(xMPPConnection, string);
    }

    public DiscoverItems discoverItems() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverItems discoverItems = new DiscoverItems();
        discoverItems.setTo(this.to);
        discoverItems.setNode(this.getId());
        return (DiscoverItems)this.con.createPacketCollectorAndSend(discoverItems).nextResultOrThrow();
    }

    public <T extends Item> List<T> getItems() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.GET, new GetItemsRequest(this.getId()));
        PubSub pubSub2 = (PubSub)this.con.createPacketCollectorAndSend(pubSub).nextResultOrThrow();
        ItemsExtension itemsExtension = (ItemsExtension)pubSub2.getExtension(PubSubElementType.ITEMS);
        return itemsExtension.getItems();
    }

    public <T extends Item> List<T> getItems(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.GET, new GetItemsRequest(this.getId(), string));
        PubSub pubSub2 = (PubSub)this.con.createPacketCollectorAndSend(pubSub).nextResultOrThrow();
        ItemsExtension itemsExtension = (ItemsExtension)pubSub2.getExtension(PubSubElementType.ITEMS);
        return itemsExtension.getItems();
    }

    public <T extends Item> List<T> getItems(Collection<String> collection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<Item> arrayList = new ArrayList<Item>(collection.size());
        for (String object2 : collection) {
            arrayList.add(new Item(object2));
        }
        PubSub pubSub = this.createPubsubPacket(IQ.Type.GET, new ItemsExtension(ItemsExtension.ItemsElementType.items, this.getId(), arrayList));
        PubSub pubSub2 = (PubSub)this.con.createPacketCollectorAndSend(pubSub).nextResultOrThrow();
        ItemsExtension itemsExtension = (ItemsExtension)pubSub2.getExtension(PubSubElementType.ITEMS);
        return itemsExtension.getItems();
    }

    public <T extends Item> List<T> getItems(int n) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.GET, new GetItemsRequest(this.getId(), n));
        PubSub pubSub2 = (PubSub)this.con.createPacketCollectorAndSend(pubSub).nextResultOrThrow();
        ItemsExtension itemsExtension = (ItemsExtension)pubSub2.getExtension(PubSubElementType.ITEMS);
        return itemsExtension.getItems();
    }

    public <T extends Item> List<T> getItems(int n, String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.GET, new GetItemsRequest(this.getId(), string, n));
        PubSub pubSub2 = (PubSub)this.con.createPacketCollectorAndSend(pubSub).nextResultOrThrow();
        ItemsExtension itemsExtension = (ItemsExtension)pubSub2.getExtension(PubSubElementType.ITEMS);
        return itemsExtension.getItems();
    }

    public void publish() throws SmackException.NotConnectedException {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.SET, new NodeExtension(PubSubElementType.PUBLISH, this.getId()));
        this.con.sendPacket(pubSub);
    }

    public <T extends Item> void publish(T t) throws SmackException.NotConnectedException {
        ArrayList<T> arrayList = new ArrayList<T>(1);
        arrayList.add(t == null ? new Item() : t);
        this.publish(arrayList);
    }

    public <T extends Item> void publish(Collection<T> collection) throws SmackException.NotConnectedException {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.SET, new PublishItem<T>(this.getId(), collection));
        this.con.sendPacket(pubSub);
    }

    public void send() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.SET, new NodeExtension(PubSubElementType.PUBLISH, this.getId()));
        this.con.createPacketCollectorAndSend(pubSub).nextResultOrThrow();
    }

    public <T extends Item> void send(T t) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<T> arrayList = new ArrayList<T>(1);
        arrayList.add(t == null ? new Item() : t);
        this.send(arrayList);
    }

    public <T extends Item> void send(Collection<T> collection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.SET, new PublishItem<T>(this.getId(), collection));
        this.con.createPacketCollectorAndSend(pubSub).nextResultOrThrow();
    }

    public void deleteAllItems() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.SET, new NodeExtension(PubSubElementType.PURGE_OWNER, this.getId()), PubSubElementType.PURGE_OWNER.getNamespace());
        this.con.createPacketCollectorAndSend(pubSub).nextResultOrThrow();
    }

    public void deleteItem(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string);
        this.deleteItem(arrayList);
    }

    public void deleteItem(Collection<String> collection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<Item> arrayList = new ArrayList<Item>(collection.size());
        for (String string : collection) {
            arrayList.add(new Item(string));
        }
        PubSub pubSub = this.createPubsubPacket(IQ.Type.SET, new ItemsExtension(ItemsExtension.ItemsElementType.retract, this.getId(), arrayList));
        this.con.createPacketCollectorAndSend(pubSub).nextResultOrThrow();
    }
}

