/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.pubsub.Affiliation;
import org.jivesoftware.smackx.pubsub.AffiliationsExtension;
import org.jivesoftware.smackx.pubsub.CollectionNode;
import org.jivesoftware.smackx.pubsub.ConfigureForm;
import org.jivesoftware.smackx.pubsub.ConfigureNodeFields;
import org.jivesoftware.smackx.pubsub.FormNode;
import org.jivesoftware.smackx.pubsub.FormNodeType;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.NodeType;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.SubscriptionsExtension;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.jivesoftware.smackx.pubsub.util.NodeUtils;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;

public final class PubSubManager {
    private XMPPConnection con;
    private String to;
    private Map<String, Node> nodeMap = new ConcurrentHashMap<String, Node>();

    public PubSubManager(XMPPConnection xMPPConnection) {
        this.con = xMPPConnection;
        this.to = "pubsub." + xMPPConnection.getServiceName();
    }

    public PubSubManager(XMPPConnection xMPPConnection, String string) {
        this.con = xMPPConnection;
        this.to = string;
    }

    public LeafNode createNode() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub pubSub = (PubSub)this.sendPubsubPacket(IQ.Type.SET, new NodeExtension(PubSubElementType.CREATE), null);
        NodeExtension nodeExtension = (NodeExtension)pubSub.getExtension("create", PubSubNamespace.BASIC.getXmlns());
        LeafNode leafNode = new LeafNode(this.con, nodeExtension.getNode());
        leafNode.setTo(this.to);
        this.nodeMap.put(leafNode.getId(), leafNode);
        return leafNode;
    }

    public LeafNode createNode(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return (LeafNode)this.createNode(string, null);
    }

    public Node createNode(String string, Form form) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Object object;
        PubSub pubSub = PubSub.createPubsubPacket(this.to, IQ.Type.SET, new NodeExtension(PubSubElementType.CREATE, string), null);
        boolean bl = true;
        if (form != null) {
            pubSub.addExtension(new FormNode(FormNodeType.CONFIGURE, form));
            object = form.getField(ConfigureNodeFields.node_type.getFieldName());
            if (object != null) {
                bl = ((FormField)object).getValues().get(0).equals(NodeType.leaf.toString());
            }
        }
        PubSubManager.sendPubsubPacket(this.con, pubSub);
        object = bl ? new LeafNode(this.con, string) : new CollectionNode(this.con, string);
        ((Node)object).setTo(this.to);
        this.nodeMap.put(((Node)object).getId(), (Node)object);
        return object;
    }

    public <T extends Node> T getNode(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Node node = this.nodeMap.get(string);
        if (node == null) {
            DiscoverInfo discoverInfo = new DiscoverInfo();
            discoverInfo.setTo(this.to);
            discoverInfo.setNode(string);
            DiscoverInfo discoverInfo2 = (DiscoverInfo)this.con.createPacketCollectorAndSend(discoverInfo).nextResultOrThrow();
            node = discoverInfo2.getIdentities().get(0).getType().equals(NodeType.leaf.toString()) ? new LeafNode(this.con, string) : new CollectionNode(this.con, string);
            node.setTo(this.to);
            this.nodeMap.put(string, node);
        }
        return (T)node;
    }

    public DiscoverItems discoverNodes(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverItems discoverItems = new DiscoverItems();
        if (string != null) {
            discoverItems.setNode(string);
        }
        discoverItems.setTo(this.to);
        DiscoverItems discoverItems2 = (DiscoverItems)this.con.createPacketCollectorAndSend(discoverItems).nextResultOrThrow();
        return discoverItems2;
    }

    public List<Subscription> getSubscriptions() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Packet packet = this.sendPubsubPacket(IQ.Type.GET, new NodeExtension(PubSubElementType.SUBSCRIPTIONS), null);
        SubscriptionsExtension subscriptionsExtension = (SubscriptionsExtension)packet.getExtension(PubSubElementType.SUBSCRIPTIONS.getElementName(), PubSubElementType.SUBSCRIPTIONS.getNamespace().getXmlns());
        return subscriptionsExtension.getSubscriptions();
    }

    public List<Affiliation> getAffiliations() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub pubSub = (PubSub)this.sendPubsubPacket(IQ.Type.GET, new NodeExtension(PubSubElementType.AFFILIATIONS), null);
        AffiliationsExtension affiliationsExtension = (AffiliationsExtension)pubSub.getExtension(PubSubElementType.AFFILIATIONS);
        return affiliationsExtension.getAffiliations();
    }

    public void deleteNode(String string) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.sendPubsubPacket(IQ.Type.SET, new NodeExtension(PubSubElementType.DELETE, string), PubSubElementType.DELETE.getNamespace());
        this.nodeMap.remove(string);
    }

    public ConfigureForm getDefaultConfiguration() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub pubSub = (PubSub)this.sendPubsubPacket(IQ.Type.GET, new NodeExtension(PubSubElementType.DEFAULT), PubSubElementType.DEFAULT.getNamespace());
        return NodeUtils.getFormFromPacket(pubSub, PubSubElementType.DEFAULT);
    }

    public DiscoverInfo getSupportedFeatures() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.con);
        return serviceDiscoveryManager.discoverInfo(this.to);
    }

    private Packet sendPubsubPacket(IQ.Type type, PacketExtension packetExtension, PubSubNamespace pubSubNamespace) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return PubSubManager.sendPubsubPacket(this.con, this.to, type, Collections.singletonList(packetExtension), pubSubNamespace);
    }

    static Packet sendPubsubPacket(XMPPConnection xMPPConnection, String string, IQ.Type type, List<PacketExtension> list, PubSubNamespace pubSubNamespace) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        PubSub pubSub = new PubSub(string, type, pubSubNamespace);
        for (PacketExtension packetExtension : list) {
            pubSub.addExtension(packetExtension);
        }
        return PubSubManager.sendPubsubPacket(xMPPConnection, pubSub);
    }

    static Packet sendPubsubPacket(XMPPConnection xMPPConnection, PubSub pubSub) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return xMPPConnection.createPacketCollectorAndSend(pubSub).nextResultOrThrow();
    }
}

