/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UnknownFormatConversionException;
import org.jivesoftware.smack.util.XmppDateTime;
import org.jivesoftware.smackx.pubsub.FormType;
import org.jivesoftware.smackx.pubsub.PresenceState;
import org.jivesoftware.smackx.pubsub.SubscribeOptionFields;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class SubscribeForm
extends Form {
    public SubscribeForm(DataForm dataForm) {
        super(dataForm);
    }

    public SubscribeForm(Form form) {
        super(form.getDataFormToSend());
    }

    public SubscribeForm(FormType formType) {
        super(formType.toString());
    }

    public boolean isDeliverOn() {
        return SubscribeForm.parseBoolean(this.getFieldValue(SubscribeOptionFields.deliver));
    }

    public void setDeliverOn(boolean bl) {
        this.addField(SubscribeOptionFields.deliver, "boolean");
        this.setAnswer(SubscribeOptionFields.deliver.getFieldName(), bl);
    }

    public boolean isDigestOn() {
        return SubscribeForm.parseBoolean(this.getFieldValue(SubscribeOptionFields.digest));
    }

    public void setDigestOn(boolean bl) {
        this.addField(SubscribeOptionFields.deliver, "boolean");
        this.setAnswer(SubscribeOptionFields.deliver.getFieldName(), bl);
    }

    public int getDigestFrequency() {
        return Integer.parseInt(this.getFieldValue(SubscribeOptionFields.digest_frequency));
    }

    public void setDigestFrequency(int n) {
        this.addField(SubscribeOptionFields.digest_frequency, "text-single");
        this.setAnswer(SubscribeOptionFields.digest_frequency.getFieldName(), n);
    }

    public Date getExpiry() {
        String string = this.getFieldValue(SubscribeOptionFields.expire);
        try {
            return XmppDateTime.parseDate(string);
        }
        catch (ParseException parseException) {
            UnknownFormatConversionException unknownFormatConversionException = new UnknownFormatConversionException(string);
            unknownFormatConversionException.initCause(parseException);
            throw unknownFormatConversionException;
        }
    }

    public void setExpiry(Date date) {
        this.addField(SubscribeOptionFields.expire, "text-single");
        this.setAnswer(SubscribeOptionFields.expire.getFieldName(), XmppDateTime.formatXEP0082Date(date));
    }

    public boolean isIncludeBody() {
        return SubscribeForm.parseBoolean(this.getFieldValue(SubscribeOptionFields.include_body));
    }

    public void setIncludeBody(boolean bl) {
        this.addField(SubscribeOptionFields.include_body, "boolean");
        this.setAnswer(SubscribeOptionFields.include_body.getFieldName(), bl);
    }

    public List<PresenceState> getShowValues() {
        ArrayList<PresenceState> arrayList = new ArrayList<PresenceState>(5);
        for (String string : this.getFieldValues(SubscribeOptionFields.show_values)) {
            arrayList.add(PresenceState.valueOf(string));
        }
        return arrayList;
    }

    public void setShowValues(Collection<PresenceState> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (PresenceState presenceState : collection) {
            arrayList.add(presenceState.toString());
        }
        this.addField(SubscribeOptionFields.show_values, "list-multi");
        this.setAnswer(SubscribeOptionFields.show_values.getFieldName(), arrayList);
    }

    private static boolean parseBoolean(String string) {
        return "1".equals(string) || "true".equals(string);
    }

    private String getFieldValue(SubscribeOptionFields subscribeOptionFields) {
        FormField formField = this.getField(subscribeOptionFields.getFieldName());
        return formField.getValues().get(0);
    }

    private List<String> getFieldValues(SubscribeOptionFields subscribeOptionFields) {
        FormField formField = this.getField(subscribeOptionFields.getFieldName());
        return formField.getValues();
    }

    private void addField(SubscribeOptionFields subscribeOptionFields, String string) {
        String string2 = subscribeOptionFields.getFieldName();
        if (this.getField(string2) == null) {
            FormField formField = new FormField(string2);
            formField.setType(string);
            this.addField(formField);
        }
    }
}

