/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.time.packet;

import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.XmppDateTime;

public class Time
extends IQ {
    public static final String NAMESPACE = "urn:xmpp:time";
    public static final String ELEMENT = "time";
    private static final Logger LOGGER = Logger.getLogger(Time.class.getName());
    private String utc;
    private String tzo;

    public Time() {
        this.setType(IQ.Type.GET);
    }

    public Time(Calendar calendar) {
        this.tzo = XmppDateTime.asString(calendar.getTimeZone());
        this.utc = XmppDateTime.formatXEP0082Date(calendar.getTime());
    }

    public Date getTime() {
        if (this.utc == null) {
            return null;
        }
        Date date = null;
        try {
            date = XmppDateTime.parseDate(this.utc);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Error getting local time", exception);
        }
        return date;
    }

    public void setTime(Date date) {
    }

    public String getUtc() {
        return this.utc;
    }

    public void setUtc(String string) {
        this.utc = string;
    }

    public String getTzo() {
        return this.tzo;
    }

    public void setTzo(String string) {
        this.tzo = string;
    }

    public static Time createResponse(Packet packet) {
        Time time = new Time(Calendar.getInstance());
        time.setType(IQ.Type.RESULT);
        time.setTo(packet.getFrom());
        return time;
    }

    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<time xmlns='urn:xmpp:time'>");
        if (this.utc != null) {
            stringBuilder.append("<utc>").append(this.utc).append("</utc>");
            stringBuilder.append("<tzo>").append(this.tzo).append("</tzo>");
        }
        stringBuilder.append("</time>");
        return stringBuilder.toString();
    }
}

