/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.vcardtemp.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.vcardtemp.packet.VCard;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class VCardProvider
implements IQProvider {
    private static final Logger LOGGER = Logger.getLogger(VCardProvider.class.getName());
    private static final String PREFERRED_ENCODING = "UTF-8";

    @Override
    public IQ parseIQ(XmlPullParser xmlPullParser) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n = xmlPullParser.getEventType();
            while (true) {
                switch (n) {
                    case 4: {
                        stringBuilder.append(StringUtils.escapeForXML(xmlPullParser.getText()));
                        break;
                    }
                    case 2: {
                        stringBuilder.append('<').append(xmlPullParser.getName()).append('>');
                        break;
                    }
                    case 3: {
                        stringBuilder.append("</").append(xmlPullParser.getName()).append('>');
                        break;
                    }
                }
                if (n != 3 || !"vCard".equals(xmlPullParser.getName())) {
                    n = xmlPullParser.next();
                    continue;
                }
                break;
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            LOGGER.log(Level.SEVERE, "Exception parsing VCard", xmlPullParserException);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "Exception parsing VCard", iOException);
        }
        String string = stringBuilder.toString();
        return VCardProvider.createVCardFromXML(string);
    }

    public static VCard createVCardFromXML(String string) throws Exception {
        VCard vCard = new VCard();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes(PREFERRED_ENCODING)));
        new VCardReader(vCard, document).initializeFields();
        return vCard;
    }

    private static class VCardReader {
        private final VCard vCard;
        private final Document document;

        VCardReader(VCard vCard, Document document) {
            this.vCard = vCard;
            this.document = document;
        }

        public void initializeFields() {
            this.vCard.setFirstName(this.getTagContents("GIVEN"));
            this.vCard.setLastName(this.getTagContents("FAMILY"));
            this.vCard.setMiddleName(this.getTagContents("MIDDLE"));
            this.setupPhoto();
            this.setupEmails();
            this.vCard.setOrganization(this.getTagContents("ORGNAME"));
            this.vCard.setOrganizationUnit(this.getTagContents("ORGUNIT"));
            this.setupSimpleFields();
            this.setupPhones();
            this.setupAddresses();
        }

        private void setupPhoto() {
            String string = null;
            String string2 = null;
            NodeList nodeList = this.document.getElementsByTagName("PHOTO");
            if (nodeList.getLength() != 1) {
                return;
            }
            Node node = nodeList.item(0);
            NodeList nodeList2 = node.getChildNodes();
            int n = nodeList2.getLength();
            ArrayList<Node> arrayList = new ArrayList<Node>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(nodeList2.item(i));
            }
            String string3 = null;
            String string4 = null;
            for (Node node2 : arrayList) {
                string3 = node2.getNodeName();
                string4 = node2.getTextContent();
                if (string3.equals("BINVAL")) {
                    string = string4;
                    continue;
                }
                if (!string3.equals("TYPE")) continue;
                string2 = string4;
            }
            if (string == null || string2 == null) {
                return;
            }
            this.vCard.setAvatar(string, string2);
        }

        private void setupEmails() {
            NodeList nodeList = this.document.getElementsByTagName("USERID");
            if (nodeList == null) {
                return;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                if ("WORK".equals(element.getParentNode().getFirstChild().getNodeName())) {
                    this.vCard.setEmailWork(this.getTextContent(element));
                    continue;
                }
                this.vCard.setEmailHome(this.getTextContent(element));
            }
        }

        private void setupPhones() {
            NodeList nodeList = this.document.getElementsByTagName("TEL");
            if (nodeList == null) {
                return;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NodeList nodeList2 = nodeList.item(i).getChildNodes();
                String string = null;
                String string2 = null;
                String string3 = null;
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node = nodeList2.item(j);
                    if (node.getNodeType() != 1) continue;
                    String string4 = node.getNodeName();
                    if ("NUMBER".equals(string4)) {
                        string3 = this.getTextContent(node);
                        continue;
                    }
                    if (this.isWorkHome(string4)) {
                        string = string4;
                        continue;
                    }
                    string2 = string4;
                }
                if (string3 == null) continue;
                if (string2 == null) {
                    string2 = "VOICE";
                }
                if ("HOME".equals(string)) {
                    this.vCard.setPhoneHome(string2, string3);
                    continue;
                }
                this.vCard.setPhoneWork(string2, string3);
            }
        }

        private boolean isWorkHome(String string) {
            return "HOME".equals(string) || "WORK".equals(string);
        }

        private void setupAddresses() {
            NodeList nodeList = this.document.getElementsByTagName("ADR");
            if (nodeList == null) {
                return;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                int n;
                Element element = (Element)nodeList.item(i);
                String string = null;
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                NodeList nodeList2 = element.getChildNodes();
                for (n = 0; n < nodeList2.getLength(); ++n) {
                    Node node = nodeList2.item(n);
                    if (node.getNodeType() != 1) continue;
                    String string2 = node.getNodeName();
                    if (this.isWorkHome(string2)) {
                        string = string2;
                        continue;
                    }
                    arrayList.add(string2);
                    arrayList2.add(this.getTextContent(node));
                }
                for (n = 0; n < arrayList2.size(); ++n) {
                    if ("HOME".equals(string)) {
                        this.vCard.setAddressFieldHome((String)arrayList.get(n), (String)arrayList2.get(n));
                        continue;
                    }
                    this.vCard.setAddressFieldWork((String)arrayList.get(n), (String)arrayList2.get(n));
                }
            }
        }

        private String getTagContents(String string) {
            NodeList nodeList = this.document.getElementsByTagName(string);
            if (nodeList != null && nodeList.getLength() == 1) {
                return this.getTextContent(nodeList.item(0));
            }
            return null;
        }

        private void setupSimpleFields() {
            NodeList nodeList = this.document.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                String string = element.getNodeName();
                if (element.getChildNodes().getLength() == 0) {
                    this.vCard.setField(string, "");
                    continue;
                }
                if (element.getChildNodes().getLength() != 1 || !(element.getChildNodes().item(0) instanceof Text)) continue;
                this.vCard.setField(string, this.getTextContent(element));
            }
        }

        private String getTextContent(Node node) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendText(stringBuilder, node);
            return stringBuilder.toString();
        }

        private void appendText(StringBuilder stringBuilder, Node node) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                String string = node2.getNodeValue();
                if (string != null) {
                    stringBuilder.append(string);
                }
                this.appendText(stringBuilder, node2);
            }
        }
    }
}

