/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class FormField {
    public static final String ELEMENT = "field";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_FIXED = "fixed";
    public static final String TYPE_HIDDEN = "hidden";
    public static final String TYPE_JID_MULTI = "jid-multi";
    public static final String TYPE_JID_SINGLE = "jid-single";
    public static final String TYPE_LIST_MULTI = "list-multi";
    public static final String TYPE_LIST_SINGLE = "list-single";
    public static final String TYPE_TEXT_MULTI = "text-multi";
    public static final String TYPE_TEXT_PRIVATE = "text-private";
    public static final String TYPE_TEXT_SINGLE = "text-single";
    private String description;
    private boolean required = false;
    private String label;
    private String variable;
    private String type;
    private final List<Option> options = new ArrayList<Option>();
    private final List<String> values = new ArrayList<String>();

    public FormField(String string) {
        this.variable = string;
    }

    public FormField() {
        this.type = TYPE_FIXED;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Option> getOptions() {
        List<Option> list = this.options;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Option>(this.options));
        }
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getValues() {
        List<String> list = this.values;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<String>(this.values));
        }
    }

    public String getVariable() {
        return this.variable;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public void setType(String string) {
        this.type = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValue(String string) {
        List<String> list = this.values;
        synchronized (list) {
            this.values.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValues(List<String> list) {
        List<String> list2 = this.values;
        synchronized (list2) {
            this.values.addAll(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetValues() {
        List<String> list = this.values;
        synchronized (list) {
            this.values.removeAll(new ArrayList<String>(this.values));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOption(Option option) {
        List<Option> list = this.options;
        synchronized (list) {
            this.options.add(option);
        }
    }

    public XmlStringBuilder toXML() {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
        xmlStringBuilder.halfOpenElement(ELEMENT);
        xmlStringBuilder.optAttribute("label", this.getLabel());
        xmlStringBuilder.optAttribute("var", this.getVariable());
        xmlStringBuilder.optAttribute("type", this.getType());
        xmlStringBuilder.rightAngelBracket();
        xmlStringBuilder.optElement("desc", this.getDescription());
        xmlStringBuilder.condEmptyElement(this.isRequired(), "required");
        for (String object : this.getValues()) {
            xmlStringBuilder.element("value", object);
        }
        for (Option option : this.getOptions()) {
            xmlStringBuilder.append(option.toXML());
        }
        xmlStringBuilder.closeElement(ELEMENT);
        return xmlStringBuilder;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof FormField)) {
            return false;
        }
        FormField formField = (FormField)object;
        return this.toXML().equals(formField.toXML());
    }

    public int hashCode() {
        return this.toXML().hashCode();
    }

    public static class Option {
        public static final String ELEMENT = "option";
        private final String value;
        private String label;

        public Option(String string) {
            this.value = string;
        }

        public Option(String string, String string2) {
            this.label = string;
            this.value = string2;
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getLabel();
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
            xmlStringBuilder.halfOpenElement(ELEMENT);
            xmlStringBuilder.optAttribute("label", this.getLabel());
            xmlStringBuilder.rightAngelBracket();
            xmlStringBuilder.element("value", this.getValue());
            xmlStringBuilder.closeElement(ELEMENT);
            return xmlStringBuilder;
        }

        public boolean equals(Object object) {
            String string;
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            Option option = (Option)object;
            if (!this.value.equals(option.value)) {
                return false;
            }
            String string2 = this.label == null ? "" : this.label;
            String string3 = string = option.label == null ? "" : option.label;
            return string2.equals(string);
        }

        public int hashCode() {
            int n = 1;
            n = 37 * n + this.value.hashCode();
            n = 37 * n + (this.label == null ? 0 : this.label.hashCode());
            return n;
        }
    }
}

