/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.xdata.FormField;

public class DataForm
implements PacketExtension {
    public static final String NAMESPACE = "jabber:x:data";
    public static final String ELEMENT = "x";
    private String type;
    private String title;
    private List<String> instructions = new ArrayList<String>();
    private ReportedData reportedData;
    private final List<Item> items = new ArrayList<Item>();
    private final List<FormField> fields = new ArrayList<FormField>();

    public DataForm(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getInstructions() {
        List<String> list = this.instructions;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<String>(this.instructions));
        }
    }

    public ReportedData getReportedData() {
        return this.reportedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Item> getItems() {
        List<Item> list = this.items;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Item>(this.items));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FormField> getFields() {
        List<FormField> list = this.fields;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<FormField>(this.fields));
        }
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setInstructions(List<String> list) {
        this.instructions = list;
    }

    public void setReportedData(ReportedData reportedData) {
        this.reportedData = reportedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addField(FormField formField) {
        List<FormField> list = this.fields;
        synchronized (list) {
            this.fields.add(formField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstruction(String string) {
        List<String> list = this.instructions;
        synchronized (list) {
            this.instructions.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Item item) {
        List<Item> list = this.items;
        synchronized (list) {
            this.items.add(item);
        }
    }

    public boolean hasHiddenFormTypeField() {
        boolean bl = false;
        for (FormField formField : this.fields) {
            if (!formField.getVariable().equals("FORM_TYPE") || formField.getType() == null || !formField.getType().equals("hidden")) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public XmlStringBuilder toXML() {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder(this);
        xmlStringBuilder.attribute("type", this.getType());
        xmlStringBuilder.rightAngelBracket();
        xmlStringBuilder.optElement("title", this.getTitle());
        for (String object : this.getInstructions()) {
            xmlStringBuilder.element("instructions", object);
        }
        if (this.getReportedData() != null) {
            xmlStringBuilder.append(this.getReportedData().toXML());
        }
        for (Item item : this.getItems()) {
            xmlStringBuilder.append(item.toXML());
        }
        for (FormField formField : this.getFields()) {
            xmlStringBuilder.append(formField.toXML());
        }
        xmlStringBuilder.closeElement(this);
        return xmlStringBuilder;
    }

    public static class Item {
        public static final String ELEMENT = "item";
        private List<FormField> fields = new ArrayList<FormField>();

        public Item(List<FormField> list) {
            this.fields = list;
        }

        public List<FormField> getFields() {
            return Collections.unmodifiableList(new ArrayList<FormField>(this.fields));
        }

        public CharSequence toXML() {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
            xmlStringBuilder.openElement(ELEMENT);
            for (FormField formField : this.getFields()) {
                xmlStringBuilder.append(formField.toXML());
            }
            xmlStringBuilder.closeElement(ELEMENT);
            return xmlStringBuilder;
        }
    }

    public static class ReportedData {
        public static final String ELEMENT = "reported";
        private List<FormField> fields = new ArrayList<FormField>();

        public ReportedData(List<FormField> list) {
            this.fields = list;
        }

        public List<FormField> getFields() {
            return Collections.unmodifiableList(new ArrayList<FormField>(this.fields));
        }

        public CharSequence toXML() {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder();
            xmlStringBuilder.openElement(ELEMENT);
            for (FormField formField : this.getFields()) {
                xmlStringBuilder.append(formField.toXML());
            }
            xmlStringBuilder.closeElement(ELEMENT);
            return xmlStringBuilder;
        }
    }
}

