/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xevent.packet;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.packet.PacketExtension;

public class MessageEvent
implements PacketExtension {
    public static final String OFFLINE = "offline";
    public static final String COMPOSING = "composing";
    public static final String DISPLAYED = "displayed";
    public static final String DELIVERED = "delivered";
    public static final String CANCELLED = "cancelled";
    private boolean offline = false;
    private boolean delivered = false;
    private boolean displayed = false;
    private boolean composing = false;
    private boolean cancelled = true;
    private String packetID = null;

    @Override
    public String getElementName() {
        return "x";
    }

    @Override
    public String getNamespace() {
        return "jabber:x:event";
    }

    public boolean isComposing() {
        return this.composing;
    }

    public boolean isDelivered() {
        return this.delivered;
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getPacketID() {
        return this.packetID;
    }

    public List<String> getEventTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isDelivered()) {
            arrayList.add(DELIVERED);
        }
        if (!this.isMessageEventRequest() && this.isCancelled()) {
            arrayList.add(CANCELLED);
        }
        if (this.isComposing()) {
            arrayList.add(COMPOSING);
        }
        if (this.isDisplayed()) {
            arrayList.add(DISPLAYED);
        }
        if (this.isOffline()) {
            arrayList.add(OFFLINE);
        }
        return arrayList;
    }

    public void setComposing(boolean bl) {
        this.composing = bl;
        this.setCancelled(false);
    }

    public void setDelivered(boolean bl) {
        this.delivered = bl;
        this.setCancelled(false);
    }

    public void setDisplayed(boolean bl) {
        this.displayed = bl;
        this.setCancelled(false);
    }

    public void setOffline(boolean bl) {
        this.offline = bl;
        this.setCancelled(false);
    }

    public void setCancelled(boolean bl) {
        this.cancelled = bl;
    }

    public void setPacketID(String string) {
        this.packetID = string;
    }

    public boolean isMessageEventRequest() {
        return this.packetID == null;
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\">");
        if (this.isOffline()) {
            stringBuilder.append("<").append(OFFLINE).append("/>");
        }
        if (this.isDelivered()) {
            stringBuilder.append("<").append(DELIVERED).append("/>");
        }
        if (this.isDisplayed()) {
            stringBuilder.append("<").append(DISPLAYED).append("/>");
        }
        if (this.isComposing()) {
            stringBuilder.append("<").append(COMPOSING).append("/>");
        }
        if (this.getPacketID() != null) {
            stringBuilder.append("<id>").append(this.getPacketID()).append("</id>");
        }
        stringBuilder.append("</").append(this.getElementName()).append(">");
        return stringBuilder.toString();
    }
}

