/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cyberplayer.core;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.util.Log;
import android.view.Surface;
import com.baidu.cyberplayer.utils.m;
import java.nio.ByteBuffer;

public class MediaCodecAdapter {
    private static MediaCodec mCodec = null;
    private static ByteBuffer[] mCodecInputBuffers;
    private static ByteBuffer[] mCodecOutputBuffers;
    private static MediaCodec.BufferInfo mBufferInfo;
    private static MediaFormat mCurrentMediaFormat;
    private static ByteBuffer mSpsBuffer;
    private static ByteBuffer mPpsBuffer;
    private static ByteBuffer mSpsPpsBuffer;
    private static Surface mSurface;
    private static String mMimeType;
    private static String mCodecName;
    private static int mVideoWidth;
    private static int mVideoHeight;

    public static void setConfigSurface(Surface surface) {
        mSurface = surface;
    }

    public static String bytes2HexString(byte[] b2) {
        String string = "";
        int n2 = 100;
        if (b2.length < n2) {
            n2 = b2.length;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = Integer.toHexString(b2[i2] & 0xFF);
            if (string2.length() == 1) {
                string2 = '0' + string2;
            }
            string = string + string2;
        }
        return string;
    }

    public static void initMediaCodec(String mimeType, String codecname, int videoWidth, int videoHeight) {
        m.d("MediaCodecAdapter", "Create MediaCodecAdapter, mimetype=" + mimeType + ", codecname=" + codecname + ", width=" + videoWidth + ", height=" + videoHeight);
        mMimeType = mimeType;
        mCodecName = codecname;
        mVideoWidth = videoWidth;
        mVideoHeight = videoHeight;
        mCodec = MediaCodec.createDecoderByType((String)mimeType);
    }

    public static void configAndStart() {
        if (mSurface == null) {
            return;
        }
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)mMimeType, (int)mVideoWidth, (int)mVideoHeight);
        if (mSpsBuffer != null && mPpsBuffer != null) {
            mediaFormat.setByteBuffer("csd-0", mSpsPpsBuffer);
            mediaFormat.setInteger("max-input-size", mVideoWidth * mVideoHeight);
        }
        mCodec.configure(mediaFormat, mSurface, null, 0);
        mCodec.start();
        mCodecInputBuffers = mCodec.getInputBuffers();
        mCodecOutputBuffers = mCodec.getOutputBuffers();
    }

    public static void setSpsAndPPs(byte[] sps, byte[] pps) {
        if (sps != null && pps != null) {
            mSpsBuffer = ByteBuffer.allocate(sps.length);
            mPpsBuffer = ByteBuffer.allocate(pps.length);
            mSpsPpsBuffer = ByteBuffer.allocate(sps.length + pps.length);
            mSpsPpsBuffer.put(sps);
            mSpsPpsBuffer.put(pps);
            mSpsPpsBuffer.position(0);
            mSpsBuffer.put(sps);
            mSpsBuffer.position(0);
            mPpsBuffer.put(pps);
            mPpsBuffer.position(0);
        }
    }

    public static int dequeueInputBuffer(long timeoutUs) {
        int n2 = -1;
        if (mCodec == null) {
            return n2;
        }
        try {
            n2 = mCodec.dequeueInputBuffer(timeoutUs);
        }
        catch (IllegalStateException illegalStateException) {
            n2 = -2000;
        }
        return n2;
    }

    public static Object getInputByteBuffer(int inputBufferIndex) {
        if (mCodec == null) {
            return null;
        }
        return mCodecInputBuffers[inputBufferIndex];
    }

    public static void queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) {
        if (mCodec == null) {
            return;
        }
        try {
            mCodec.queueInputBuffer(index, offset, size, presentationTimeUs, flags);
        }
        catch (IllegalStateException illegalStateException) {
            Log.e((String)"MediaCodecAdapter", (String)("Failed to queue iput buffer " + illegalStateException.toString()));
        }
    }

    public static int dequeueOutputBuffer(long timeoutUs) {
        int n2 = -1;
        if (mCodec == null) {
            return -1;
        }
        try {
            n2 = mCodec.dequeueOutputBuffer(mBufferInfo, timeoutUs);
            if (n2 < 0) {
                if (n2 == -3) {
                    mCodecOutputBuffers = mCodec.getOutputBuffers();
                    m.d("MediaCodecAdapter", "output buffers have changed.");
                } else if (n2 == -2) {
                    mCurrentMediaFormat = mCodec.getOutputFormat();
                    m.d("MediaCodecAdapter", "output format has changed to " + mCurrentMediaFormat.toString());
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            n2 = -2000;
        }
        return n2;
    }

    public static int getOutputFormatWidth() {
        if (mCurrentMediaFormat != null) {
            return mCurrentMediaFormat.getInteger("width");
        }
        return 0;
    }

    public static int getOutputFormatHeight() {
        if (mCurrentMediaFormat != null) {
            return mCurrentMediaFormat.getInteger("height");
        }
        return 0;
    }

    public static int getOutputFormatColorFormat() {
        if (mCurrentMediaFormat != null) {
            return mCurrentMediaFormat.getInteger("color-format");
        }
        return 0;
    }

    public static int getCurrentOutputBufferSize() {
        return MediaCodecAdapter.mBufferInfo.size;
    }

    public static int getCurrentOutputBufferFlag() {
        return MediaCodecAdapter.mBufferInfo.flags;
    }

    public static Object getOutputByteBuffer(int outputBufferIndex) {
        if (mCodec == null) {
            return null;
        }
        return mCodecOutputBuffers[outputBufferIndex];
    }

    public static void releaseOutputBuffer(int outputBufferIndex, boolean bRenderer) {
        if (mCodec == null) {
            return;
        }
        mCodec.releaseOutputBuffer(outputBufferIndex, bRenderer);
    }

    public static boolean isStreamEOF() {
        if (mCodec == null) {
            return true;
        }
        return (MediaCodecAdapter.mBufferInfo.flags & 4) != 0;
    }

    public static void stopAndReleaseCodec() {
        Log.i((String)"MediaCodecAdapter", (String)"stopAndReleaseCodec");
        if (mCodec != null) {
            mCodec.stop();
            mCodec.release();
            mCodec = null;
        }
    }

    public static String getSupportedCodecName(String mime, int profile, int level, boolean isEncoder) {
        m.d("MediaCodecAdapter", "getSupportedCOdecNameFor : mime=" + mime + ", profile=" + profile + ", level=" + level);
        int n2 = MediaCodecList.getCodecCount();
        int n3 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            String[] stringArray;
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)n3);
            if (isEncoder ? !mediaCodecInfo.isEncoder() : mediaCodecInfo.isEncoder()) continue;
            for (String string : stringArray = mediaCodecInfo.getSupportedTypes()) {
                if (!string.equals(mime)) continue;
                try {
                    MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray;
                    MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string);
                    for (MediaCodecInfo.CodecProfileLevel codecProfileLevel : codecProfileLevelArray = codecCapabilities.profileLevels) {
                        if (!string.equals(mime) || codecProfileLevel.profile < profile || codecProfileLevel.level < level) continue;
                        m.d("MediaCodecAdapter", "Find Supported Codec, codec name=" + mediaCodecInfo.getName() + ", mimetype=" + string + ", profile=" + codecProfileLevel.profile + ", level=" + codecProfileLevel.level);
                        return mediaCodecInfo.getName();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
            }
        }
        return null;
    }

    static {
        mBufferInfo = new MediaCodec.BufferInfo();
        mSpsBuffer = null;
        mPpsBuffer = null;
        mSpsPpsBuffer = null;
        mSurface = null;
    }
}

