/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.component;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.sina.weibo.sdk.api.ImageObject;
import com.sina.weibo.sdk.api.MusicObject;
import com.sina.weibo.sdk.api.TextObject;
import com.sina.weibo.sdk.api.VideoObject;
import com.sina.weibo.sdk.api.VoiceObject;
import com.sina.weibo.sdk.api.WebpageObject;
import com.sina.weibo.sdk.api.WeiboMultiMessage;
import com.sina.weibo.sdk.api.share.BaseRequest;
import com.sina.weibo.sdk.auth.WeiboAuthListener;
import com.sina.weibo.sdk.component.BrowserLauncher;
import com.sina.weibo.sdk.component.BrowserRequestParamBase;
import com.sina.weibo.sdk.component.WeiboCallbackManager;
import com.sina.weibo.sdk.component.WeiboSdkBrowser;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.utils.Base64;
import com.sina.weibo.sdk.utils.MD5;
import com.sina.weibo.sdk.utils.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class ShareRequestParam
extends BrowserRequestParamBase {
    private static final String SHARE_URL = "http://service.weibo.com/share/mobilesdk.php";
    public static final String UPLOAD_PIC_URL = "http://service.weibo.com/share/mobilesdk_uppic.php";
    public static final String REQ_PARAM_TITLE = "title";
    public static final String REQ_PARAM_VERSION = "version";
    public static final String REQ_PARAM_SOURCE = "source";
    public static final String REQ_PARAM_AID = "aid";
    public static final String REQ_PARAM_PACKAGENAME = "packagename";
    public static final String REQ_PARAM_KEY_HASH = "key_hash";
    public static final String REQ_PARAM_TOKEN = "access_token";
    public static final String REQ_PARAM_PICINFO = "picinfo";
    public static final String REQ_UPLOAD_PIC_PARAM_IMG = "img";
    public static final String RESP_UPLOAD_PIC_PARAM_CODE = "code";
    public static final String RESP_UPLOAD_PIC_PARAM_DATA = "data";
    public static final int RESP_UPLOAD_PIC_SUCC_CODE = 1;
    private WeiboAuthListener mAuthListener;
    private String mAuthListenerKey;
    private String mAppPackage;
    private String mToken;
    private String mAppKey;
    private String mHashKey;
    private BaseRequest mBaseRequest;
    private String mShareContent;
    private byte[] mBase64ImgData;

    public ShareRequestParam(Context context) {
        super(context);
        this.mLaucher = BrowserLauncher.SHARE;
    }

    @Override
    protected void onSetupRequestParam(Bundle data) {
        this.mAppKey = data.getString(REQ_PARAM_SOURCE);
        this.mAppPackage = data.getString(REQ_PARAM_PACKAGENAME);
        this.mHashKey = data.getString(REQ_PARAM_KEY_HASH);
        this.mToken = data.getString(REQ_PARAM_TOKEN);
        this.mAuthListenerKey = data.getString("key_listener");
        if (!TextUtils.isEmpty((CharSequence)this.mAuthListenerKey)) {
            this.mAuthListener = WeiboCallbackManager.getInstance(this.mContext).getWeiboAuthListener(this.mAuthListenerKey);
        }
        this.handleSharedMessage(data);
        this.mUrl = this.buildUrl("");
    }

    private void handleSharedMessage(Bundle bundle) {
        ImageObject imageObject;
        TextObject textObject;
        WeiboMultiMessage multiMessage = new WeiboMultiMessage();
        multiMessage.toObject(bundle);
        StringBuilder content = new StringBuilder();
        if (multiMessage.textObject instanceof TextObject) {
            textObject = multiMessage.textObject;
            content.append(textObject.text);
        }
        if (multiMessage.imageObject instanceof ImageObject) {
            imageObject = multiMessage.imageObject;
            this.handleMblogPic(imageObject.imagePath, imageObject.imageData);
        }
        if (multiMessage.mediaObject instanceof TextObject) {
            textObject = (TextObject)multiMessage.mediaObject;
            content.append(textObject.text);
        }
        if (multiMessage.mediaObject instanceof ImageObject) {
            imageObject = (ImageObject)multiMessage.mediaObject;
            this.handleMblogPic(imageObject.imagePath, imageObject.imageData);
        }
        if (multiMessage.mediaObject instanceof WebpageObject) {
            WebpageObject webPageObject = (WebpageObject)multiMessage.mediaObject;
            content.append(" ").append(webPageObject.actionUrl);
        }
        if (multiMessage.mediaObject instanceof MusicObject) {
            MusicObject musicObject = (MusicObject)multiMessage.mediaObject;
            content.append(" ").append(musicObject.actionUrl);
        }
        if (multiMessage.mediaObject instanceof VideoObject) {
            VideoObject videoObject = (VideoObject)multiMessage.mediaObject;
            content.append(" ").append(videoObject.actionUrl);
        }
        if (multiMessage.mediaObject instanceof VoiceObject) {
            VoiceObject voiceObject = (VoiceObject)multiMessage.mediaObject;
            content.append(" ").append(voiceObject.actionUrl);
        }
        this.mShareContent = content.toString();
    }

    private void handleMblogPic(String picPath, byte[] thumbData) {
        block15: {
            try {
                File picFile;
                if (TextUtils.isEmpty((CharSequence)picPath) || !(picFile = new File(picPath)).exists() || !picFile.canRead() || picFile.length() <= 0L) break block15;
                byte[] tmpPic = new byte[(int)picFile.length()];
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(picFile);
                    fis.read(tmpPic);
                    this.mBase64ImgData = Base64.encodebyte(tmpPic);
                    return;
                }
                catch (IOException e) {
                    tmpPic = null;
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (thumbData != null && thumbData.length > 0) {
            this.mBase64ImgData = Base64.encodebyte(thumbData);
        }
    }

    @Override
    public void onCreateRequestParamBundle(Bundle data) {
        if (this.mBaseRequest != null) {
            this.mBaseRequest.toBundle(data);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mAppPackage)) {
            this.mHashKey = MD5.hexdigest(Utility.getSign(this.mContext, this.mAppPackage));
        }
        data.putString(REQ_PARAM_TOKEN, this.mToken);
        data.putString(REQ_PARAM_SOURCE, this.mAppKey);
        data.putString(REQ_PARAM_PACKAGENAME, this.mAppPackage);
        data.putString(REQ_PARAM_KEY_HASH, this.mHashKey);
        data.putString("_weibo_appPackage", this.mAppPackage);
        data.putString("_weibo_appKey", this.mAppKey);
        data.putInt("_weibo_flag", 538116905);
        data.putString("_weibo_sign", this.mHashKey);
        if (this.mAuthListener != null) {
            WeiboCallbackManager manager = WeiboCallbackManager.getInstance(this.mContext);
            this.mAuthListenerKey = manager.genCallbackKey();
            manager.setWeiboAuthListener(this.mAuthListenerKey, this.mAuthListener);
            data.putString("key_listener", this.mAuthListenerKey);
        }
    }

    @Override
    public void execRequest(Activity act, int action) {
        if (action == 3) {
            this.sendSdkCancleResponse(act);
            WeiboSdkBrowser.closeBrowser(act, this.mAuthListenerKey, null);
        }
    }

    public boolean hasImage() {
        return this.mBase64ImgData != null && this.mBase64ImgData.length > 0;
    }

    public WeiboParameters buildUploadPicParam(WeiboParameters param) {
        if (!this.hasImage()) {
            return param;
        }
        String imgDataBase64Str = new String(this.mBase64ImgData);
        param.put(REQ_UPLOAD_PIC_PARAM_IMG, imgDataBase64Str);
        return param;
    }

    public String buildUrl(String picid) {
        String aid;
        Uri uri = Uri.parse((String)SHARE_URL);
        Uri.Builder builder = uri.buildUpon();
        builder.appendQueryParameter(REQ_PARAM_TITLE, this.mShareContent);
        builder.appendQueryParameter(REQ_PARAM_VERSION, "0031405000");
        if (!TextUtils.isEmpty((CharSequence)this.mAppKey)) {
            builder.appendQueryParameter(REQ_PARAM_SOURCE, this.mAppKey);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mToken)) {
            builder.appendQueryParameter(REQ_PARAM_TOKEN, this.mToken);
        }
        if (!TextUtils.isEmpty((CharSequence)(aid = Utility.getAid(this.mContext, this.mAppKey)))) {
            builder.appendQueryParameter(REQ_PARAM_AID, aid);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mAppPackage)) {
            builder.appendQueryParameter(REQ_PARAM_PACKAGENAME, this.mAppPackage);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mHashKey)) {
            builder.appendQueryParameter(REQ_PARAM_KEY_HASH, this.mHashKey);
        }
        if (!TextUtils.isEmpty((CharSequence)picid)) {
            builder.appendQueryParameter(REQ_PARAM_PICINFO, picid);
        }
        return builder.build().toString();
    }

    private void sendSdkResponse(Activity activity, int errCode, String errMsg) {
        Bundle bundle = activity.getIntent().getExtras();
        if (bundle == null) {
            return;
        }
        Intent intent = new Intent("com.sina.weibo.sdk.action.ACTION_SDK_REQ_ACTIVITY");
        intent.setFlags(131072);
        intent.setPackage(bundle.getString("_weibo_appPackage"));
        intent.putExtras(bundle);
        intent.putExtra("_weibo_appPackage", activity.getPackageName());
        intent.putExtra("_weibo_resp_errcode", errCode);
        intent.putExtra("_weibo_resp_errstr", errMsg);
        try {
            activity.startActivityForResult(intent, 765);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            // empty catch block
        }
    }

    public void sendSdkCancleResponse(Activity activity) {
        this.sendSdkResponse(activity, 1, "send cancel!!!");
    }

    public void sendSdkOkResponse(Activity activity) {
        this.sendSdkResponse(activity, 0, "send ok!!!");
    }

    public void sendSdkErrorResponse(Activity activity, String msg) {
        this.sendSdkResponse(activity, 2, msg);
    }

    public void setBaseRequest(BaseRequest request) {
        this.mBaseRequest = request;
    }

    public String getAppPackage() {
        return this.mAppPackage;
    }

    public void setAppPackage(String mAppPackage) {
        this.mAppPackage = mAppPackage;
    }

    public String getToken() {
        return this.mToken;
    }

    public void setToken(String mToken) {
        this.mToken = mToken;
    }

    public String getAppKey() {
        return this.mAppKey;
    }

    public void setAppKey(String mAppKey) {
        this.mAppKey = mAppKey;
    }

    public String getHashKey() {
        return this.mHashKey;
    }

    public String getShareContent() {
        return this.mShareContent;
    }

    public byte[] getBase64ImgData() {
        return this.mBase64ImgData;
    }

    public WeiboAuthListener getAuthListener() {
        return this.mAuthListener;
    }

    public String getAuthListenerKey() {
        return this.mAuthListenerKey;
    }

    public void setAuthListener(WeiboAuthListener mAuthListener) {
        this.mAuthListener = mAuthListener;
    }

    public static class UploadPicResult {
        private int code = -2;
        private String picId;

        private UploadPicResult() {
        }

        public int getCode() {
            return this.code;
        }

        public String getPicId() {
            return this.picId;
        }

        public static UploadPicResult parse(String resp) {
            if (TextUtils.isEmpty((CharSequence)resp)) {
                return null;
            }
            UploadPicResult result = new UploadPicResult();
            try {
                JSONObject obj = new JSONObject(resp);
                result.code = obj.optInt(ShareRequestParam.RESP_UPLOAD_PIC_PARAM_CODE, -2);
                result.picId = obj.optString(ShareRequestParam.RESP_UPLOAD_PIC_PARAM_DATA, "");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return result;
        }
    }
}

