/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.component;

import android.content.Context;
import android.text.TextUtils;
import com.sina.weibo.sdk.auth.WeiboAuthListener;
import com.sina.weibo.sdk.component.WidgetRequestParam;
import java.util.HashMap;
import java.util.Map;

public class WeiboCallbackManager {
    private static WeiboCallbackManager sInstance;
    private Context mContext;
    private Map<String, WeiboAuthListener> mWeiboAuthListenerMap;
    private Map<String, WidgetRequestParam.WidgetRequestCallback> mWidgetRequestCallbackMap;

    private WeiboCallbackManager(Context context) {
        this.mContext = context;
        this.mWeiboAuthListenerMap = new HashMap<String, WeiboAuthListener>();
        this.mWidgetRequestCallbackMap = new HashMap<String, WidgetRequestParam.WidgetRequestCallback>();
    }

    public static synchronized WeiboCallbackManager getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new WeiboCallbackManager(context);
        }
        return sInstance;
    }

    public synchronized WeiboAuthListener getWeiboAuthListener(String callbackId) {
        if (TextUtils.isEmpty((CharSequence)callbackId)) {
            return null;
        }
        return this.mWeiboAuthListenerMap.get(callbackId);
    }

    public synchronized void setWeiboAuthListener(String callbackId, WeiboAuthListener authListener) {
        if (TextUtils.isEmpty((CharSequence)callbackId) || authListener == null) {
            return;
        }
        this.mWeiboAuthListenerMap.put(callbackId, authListener);
    }

    public synchronized void removeWeiboAuthListener(String callbackId) {
        if (TextUtils.isEmpty((CharSequence)callbackId)) {
            return;
        }
        this.mWeiboAuthListenerMap.remove(callbackId);
    }

    public synchronized WidgetRequestParam.WidgetRequestCallback getWidgetRequestCallback(String callbackId) {
        if (TextUtils.isEmpty((CharSequence)callbackId)) {
            return null;
        }
        return this.mWidgetRequestCallbackMap.get(callbackId);
    }

    public synchronized void setWidgetRequestCallback(String callbackId, WidgetRequestParam.WidgetRequestCallback l) {
        if (TextUtils.isEmpty((CharSequence)callbackId) || l == null) {
            return;
        }
        this.mWidgetRequestCallbackMap.put(callbackId, l);
    }

    public synchronized void removeWidgetRequestCallback(String callbackId) {
        if (TextUtils.isEmpty((CharSequence)callbackId)) {
            return;
        }
        this.mWidgetRequestCallbackMap.remove(callbackId);
    }

    public String genCallbackKey() {
        return String.valueOf(System.currentTimeMillis());
    }
}

