/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.component;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.sina.weibo.sdk.auth.WeiboAuthListener;
import com.sina.weibo.sdk.component.BrowserLauncher;
import com.sina.weibo.sdk.component.BrowserRequestParamBase;
import com.sina.weibo.sdk.component.WeiboCallbackManager;
import com.sina.weibo.sdk.component.WeiboSdkBrowser;
import com.sina.weibo.sdk.utils.MD5;
import com.sina.weibo.sdk.utils.Utility;

public class WidgetRequestParam
extends BrowserRequestParamBase {
    public static final String EXTRA_KEY_WIDGET_CALLBACK = "key_widget_callback";
    public static final String REQ_PARAM_ATTENTION_FUID = "fuid";
    public static final String REQ_PARAM_COMMENT_TOPIC = "q";
    public static final String REQ_PARAM_COMMENT_CONTENT = "content";
    public static final String REQ_PARAM_COMMENT_CATEGORY = "category";
    private WeiboAuthListener mAuthListener;
    private String mAuthListenerKey;
    private WidgetRequestCallback mWidgetRequestCallback;
    private String mWidgetRequestCallbackKey;
    private String mAppPackage;
    private String mToken;
    private String mAppKey;
    private String mHashKey;
    private String mAttentionFuid;
    private String mCommentContent;
    private String mCommentTopic;
    private String mCommentCategory;

    public WidgetRequestParam(Context context) {
        super(context);
        this.mLaucher = BrowserLauncher.WIDGET;
    }

    @Override
    protected void onSetupRequestParam(Bundle data) {
        this.mAppKey = data.getString("source");
        this.mAppPackage = data.getString("packagename");
        this.mHashKey = data.getString("key_hash");
        this.mToken = data.getString("access_token");
        this.mAttentionFuid = data.getString(REQ_PARAM_ATTENTION_FUID);
        this.mCommentTopic = data.getString(REQ_PARAM_COMMENT_TOPIC);
        this.mCommentContent = data.getString(REQ_PARAM_COMMENT_CONTENT);
        this.mCommentCategory = data.getString(REQ_PARAM_COMMENT_CATEGORY);
        this.mAuthListenerKey = data.getString("key_listener");
        if (!TextUtils.isEmpty((CharSequence)this.mAuthListenerKey)) {
            this.mAuthListener = WeiboCallbackManager.getInstance(this.mContext).getWeiboAuthListener(this.mAuthListenerKey);
        }
        this.mWidgetRequestCallbackKey = data.getString(EXTRA_KEY_WIDGET_CALLBACK);
        if (!TextUtils.isEmpty((CharSequence)this.mWidgetRequestCallbackKey)) {
            this.mWidgetRequestCallback = WeiboCallbackManager.getInstance(this.mContext).getWidgetRequestCallback(this.mWidgetRequestCallbackKey);
        }
        String baseUrl = this.mUrl;
        this.mUrl = this.buildUrl(baseUrl);
    }

    @Override
    public void onCreateRequestParamBundle(Bundle data) {
        this.mAppPackage = this.mContext.getPackageName();
        if (!TextUtils.isEmpty((CharSequence)this.mAppPackage)) {
            this.mHashKey = MD5.hexdigest(Utility.getSign(this.mContext, this.mAppPackage));
        }
        data.putString("access_token", this.mToken);
        data.putString("source", this.mAppKey);
        data.putString("packagename", this.mAppPackage);
        data.putString("key_hash", this.mHashKey);
        data.putString(REQ_PARAM_ATTENTION_FUID, this.mAttentionFuid);
        data.putString(REQ_PARAM_COMMENT_TOPIC, this.mCommentTopic);
        data.putString(REQ_PARAM_COMMENT_CONTENT, this.mCommentContent);
        data.putString(REQ_PARAM_COMMENT_CATEGORY, this.mCommentCategory);
        WeiboCallbackManager manager = WeiboCallbackManager.getInstance(this.mContext);
        if (this.mAuthListener != null) {
            this.mAuthListenerKey = manager.genCallbackKey();
            manager.setWeiboAuthListener(this.mAuthListenerKey, this.mAuthListener);
            data.putString("key_listener", this.mAuthListenerKey);
        }
        if (this.mWidgetRequestCallback != null) {
            this.mWidgetRequestCallbackKey = manager.genCallbackKey();
            manager.setWidgetRequestCallback(this.mWidgetRequestCallbackKey, this.mWidgetRequestCallback);
            data.putString(EXTRA_KEY_WIDGET_CALLBACK, this.mWidgetRequestCallbackKey);
        }
    }

    private String buildUrl(String baseUrl) {
        String aid;
        Uri uri = Uri.parse((String)baseUrl);
        Uri.Builder builder = uri.buildUpon();
        builder.appendQueryParameter("version", "0031405000");
        if (!TextUtils.isEmpty((CharSequence)this.mAppKey)) {
            builder.appendQueryParameter("source", this.mAppKey);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mToken)) {
            builder.appendQueryParameter("access_token", this.mToken);
        }
        if (!TextUtils.isEmpty((CharSequence)(aid = Utility.getAid(this.mContext, this.mAppKey)))) {
            builder.appendQueryParameter("aid", aid);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mAppPackage)) {
            builder.appendQueryParameter("packagename", this.mAppPackage);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mHashKey)) {
            builder.appendQueryParameter("key_hash", this.mHashKey);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mAttentionFuid)) {
            builder.appendQueryParameter(REQ_PARAM_ATTENTION_FUID, this.mAttentionFuid);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mCommentTopic)) {
            builder.appendQueryParameter(REQ_PARAM_COMMENT_TOPIC, this.mCommentTopic);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mCommentContent)) {
            builder.appendQueryParameter(REQ_PARAM_COMMENT_CONTENT, this.mCommentContent);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mCommentCategory)) {
            builder.appendQueryParameter(REQ_PARAM_COMMENT_CATEGORY, this.mCommentCategory);
        }
        return builder.build().toString();
    }

    public String getAttentionFuid() {
        return this.mAttentionFuid;
    }

    public void setAttentionFuid(String fuid) {
        this.mAttentionFuid = fuid;
    }

    public String getCommentContent() {
        return this.mCommentContent;
    }

    public void setCommentContent(String content) {
        this.mCommentContent = content;
    }

    public String getCommentTopic() {
        return this.mCommentTopic;
    }

    public void setCommentTopic(String topic) {
        this.mCommentTopic = topic;
    }

    public String getCommentCategory() {
        return this.mCommentCategory;
    }

    public void setCommentCategory(String category) {
        this.mCommentCategory = category;
    }

    public String getToken() {
        return this.mToken;
    }

    public void setToken(String mToken) {
        this.mToken = mToken;
    }

    public String getAppKey() {
        return this.mAppKey;
    }

    public void setAppKey(String mAppKey) {
        this.mAppKey = mAppKey;
    }

    public WeiboAuthListener getAuthListener() {
        return this.mAuthListener;
    }

    public String getAuthListenerKey() {
        return this.mAuthListenerKey;
    }

    public void setAuthListener(WeiboAuthListener mAuthListener) {
        this.mAuthListener = mAuthListener;
    }

    public WidgetRequestCallback getWidgetRequestCallback() {
        return this.mWidgetRequestCallback;
    }

    public String getWidgetRequestCallbackKey() {
        return this.mWidgetRequestCallbackKey;
    }

    public void setWidgetRequestCallback(WidgetRequestCallback l) {
        this.mWidgetRequestCallback = l;
    }

    @Override
    public void execRequest(Activity act, int action) {
        if (action == 3) {
            WeiboSdkBrowser.closeBrowser(act, this.mAuthListenerKey, this.mWidgetRequestCallbackKey);
        }
    }

    public static interface WidgetRequestCallback {
        public void onWebViewResult(String var1);
    }
}

