/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.statistic;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import com.sina.weibo.sdk.net.HttpManager;
import com.sina.weibo.sdk.statistic.LogBuilder;
import com.sina.weibo.sdk.statistic.LogFileUtil;
import com.sina.weibo.sdk.statistic.StatisticConfig;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.MD5;
import com.sina.weibo.sdk.utils.Utility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class LogReport {
    public static LogReport mLogReport;
    private static String mAid;
    private static String mAppkey;
    private static String mPackageName;
    private static String mKeyHash;
    private static String mVersionName;
    private static String mChannel;
    private static JSONObject mParams;
    private static String UPLOADTIME;
    private static final int CONNECTION_TIMEOUT = 25000;
    private static final int SOCKET_TIMEOUT = 20000;
    private static final String PRIVATE_CODE = "dqwef1864il4c9m6";
    private static String mBaseUrl;

    static {
        UPLOADTIME = "uploadtime";
        mBaseUrl = "https://api.weibo.com/2/proxy/sdk/statistic.json";
    }

    public LogReport(Context context) {
        try {
            if (mPackageName == null) {
                mPackageName = context.getPackageName();
            }
            mAppkey = StatisticConfig.getAppkey(context);
            LogReport.checkAid(context);
            mKeyHash = Utility.getSign(context, mPackageName);
            mVersionName = LogBuilder.getVersion(context);
            mChannel = StatisticConfig.getChannel(context);
        }
        catch (Exception ex) {
            LogUtil.e("WBAgent", ex.toString());
        }
        LogReport.initCommonParams();
    }

    private static JSONObject initCommonParams() {
        if (mParams == null) {
            mParams = new JSONObject();
        }
        try {
            mParams.put("appkey", (Object)mAppkey);
            mParams.put("platform", (Object)"Android");
            mParams.put("packagename", (Object)mPackageName);
            mParams.put("key_hash", (Object)mKeyHash);
            mParams.put("version", (Object)mVersionName);
            mParams.put("channel", (Object)mChannel);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return mParams;
    }

    private static void checkAid(Context context) {
        if (TextUtils.isEmpty((CharSequence)mAid)) {
            mAid = Utility.getAid(context, mAppkey);
        }
        if (mParams == null) {
            mParams = new JSONObject();
        }
        try {
            mParams.put("aid", (Object)mAid);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void setPackageName(String mPackageName) {
        LogReport.mPackageName = mPackageName;
    }

    public static String getPackageName() {
        return mPackageName;
    }

    public static synchronized void uploadAppLogs(Context context, String memoryLogs) {
        if (mLogReport == null) {
            mLogReport = new LogReport(context);
        }
        if (!LogReport.isNetworkConnected(context)) {
            LogUtil.i("WBAgent", "network is not connected");
            LogFileUtil.writeToFile(LogFileUtil.getAppLogPath("app_logs"), memoryLogs, true);
            return;
        }
        List<JSONArray> applogs = LogBuilder.getValidUploadLogs(memoryLogs);
        if (applogs == null) {
            LogUtil.i("WBAgent", "applogs is null");
            return;
        }
        ArrayList<JSONArray> failed_logs = new ArrayList<JSONArray>();
        LogReport.checkAid(context);
        for (JSONArray applog : applogs) {
            HttpResponse response = null;
            response = LogReport.requestHttpExecute(mBaseUrl, "POST", mParams, applog);
            if (response == null || response.getStatusLine().getStatusCode() != 200) {
                failed_logs.add(applog);
                LogUtil.e("WBAgent", "upload applogs error");
                continue;
            }
            LogReport.updateTime(context, System.currentTimeMillis());
        }
        LogFileUtil.delete(LogFileUtil.getAppLogPath("app_logs"));
        if (failed_logs.size() > 0) {
            for (JSONArray failed_log : failed_logs) {
                LogFileUtil.writeToFile(LogFileUtil.getAppLogPath("app_logs"), failed_log.toString(), true);
                LogUtil.d("WBAgent", "save failed_log");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static HttpResponse requestHttpExecute(String url, String method, JSONObject params, JSONArray applog) {
        client = null;
        response = null;
        baos = null;
        request = null;
        try {
            block30: {
                client = HttpManager.getNewHttpClient();
                if (params == null) {
                    params = LogReport.initCommonParams();
                }
                try {
                    params.put("time", System.currentTimeMillis() / 1000L);
                    params.put("length", applog.length());
                    params.put("sign", (Object)LogReport.getSign(params.getString("aid"), params.getString("appkey"), params.getLong("time")));
                    params.put("content", (Object)applog);
                    LogUtil.d("WBAgent", "post content--- " + params.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if (!method.equals("GET")) break block30;
                url = String.valueOf(url) + "?" + params.toString();
                request = new HttpGet(url);
                ** GOTO lbl41
            }
            if (!method.equals("POST")) ** GOTO lbl41
            if (TextUtils.isEmpty((CharSequence)LogReport.mAppkey)) {
                LogUtil.e("WBAgent", "unexpected null AppKey");
                return null;
            }
            try {
                url = String.valueOf(url) + "?" + "source=" + LogReport.mAppkey;
                post = LogReport.getNewHttpPost(url, params);
                baos = new ByteArrayOutputStream();
                if (StatisticConfig.isNeedGizp()) {
                    baos.write(LogReport.gzipLogs(params.toString()));
                } else {
                    baos.write(params.toString().getBytes());
                }
                post.setEntity((HttpEntity)new ByteArrayEntity(baos.toByteArray()));
                request = post;
lbl41:
                // 3 sources

                response = client.execute(request);
                LogUtil.i("WBAgent", "status code = " + response.getStatusLine().getStatusCode());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException var10_15) {}
            }
            LogReport.shutdownHttpClient(client);
        }
        return response;
    }

    private static boolean isNetworkConnected(Context context) {
        if (context == null) {
            LogUtil.e("WBAgent", "unexpected null context in isNetworkConnected");
            return false;
        }
        PackageManager pm = context.getPackageManager();
        if (pm.checkPermission("android.permission.ACCESS_NETWORK_STATE", context.getPackageName()) != 0) {
            return false;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = null;
        try {
            info = cm.getActiveNetworkInfo();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return info != null && info.isAvailable();
    }

    private static synchronized HttpPost getNewHttpPost(String url, JSONObject params) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
        httpPost.setHeader("Connection", "Keep-Alive");
        httpPost.addHeader("Content-Encoding", StatisticConfig.isNeedGizp() ? "gzip" : "charset=UTF-8");
        httpPost.addHeader("Accept", "*/*");
        httpPost.addHeader("Accept-Language", "en-us");
        httpPost.addHeader("Accept-Encoding", "gzip");
        return httpPost;
    }

    private static String getSign(String aid, String appkey, long time) {
        StringBuilder sb = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)aid)) {
            sb.append(aid);
        }
        sb.append(appkey).append(PRIVATE_CODE).append(time);
        String oriData = MD5.hexdigest(sb.toString());
        String md5_key = oriData.substring(oriData.length() - 6);
        String md5_sign = MD5.hexdigest(String.valueOf(md5_key) + md5_key.substring(0, 4));
        return String.valueOf(md5_key) + md5_sign.substring(md5_sign.length() - 1);
    }

    private static byte[] gzipLogs(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            byte[] logs = str.getBytes("utf-8");
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(logs);
            gzip.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return out.toByteArray();
    }

    public static long getTime(Context context) {
        SharedPreferences sp = context.getSharedPreferences(UPLOADTIME, 0);
        return sp.getLong("lasttime", 0L);
    }

    private static void updateTime(Context context, Long time) {
        SharedPreferences sp = context.getSharedPreferences(UPLOADTIME, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putLong("lasttime", time.longValue());
        editor.commit();
    }

    private static void shutdownHttpClient(HttpClient client) {
        if (client != null) {
            try {
                client.getConnectionManager().closeExpiredConnections();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

