/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils;

import android.app.Activity;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceGroup;
import android.view.View;
import com.lidroid.xutils.util.LogUtils;
import com.lidroid.xutils.util.core.DoubleKeyValueMap;
import com.lidroid.xutils.view.ResLoader;
import com.lidroid.xutils.view.ViewCommonEventListener;
import com.lidroid.xutils.view.ViewCustomEventListener;
import com.lidroid.xutils.view.ViewFinder;
import com.lidroid.xutils.view.ViewInjectInfo;
import com.lidroid.xutils.view.annotation.ContentView;
import com.lidroid.xutils.view.annotation.PreferenceInject;
import com.lidroid.xutils.view.annotation.ResInject;
import com.lidroid.xutils.view.annotation.ViewInject;
import com.lidroid.xutils.view.annotation.event.EventBase;
import com.lidroid.xutils.view.annotation.event.OnClick;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public class ViewUtils {
    private static ConcurrentHashMap<Class<? extends Annotation>, ViewCustomEventListener> annotationType_viewCustomEventListener_map;

    private ViewUtils() {
    }

    public static void registerCustomAnnotation(Class<? extends Annotation> annotationType, ViewCustomEventListener listener) {
        if (annotationType_viewCustomEventListener_map == null) {
            annotationType_viewCustomEventListener_map = new ConcurrentHashMap();
        }
        annotationType_viewCustomEventListener_map.put(annotationType, listener);
    }

    public static void inject(View view) {
        ViewUtils.injectObject(view, new ViewFinder(view));
    }

    public static void inject(Activity activity) {
        ViewUtils.injectObject(activity, new ViewFinder(activity));
    }

    public static void inject(PreferenceActivity preferenceActivity) {
        ViewUtils.injectObject(preferenceActivity, new ViewFinder(preferenceActivity));
    }

    public static void inject(Object handler, View view) {
        ViewUtils.injectObject(handler, new ViewFinder(view));
    }

    public static void inject(Object handler, Activity activity) {
        ViewUtils.injectObject(handler, new ViewFinder(activity));
    }

    public static void inject(Object handler, PreferenceGroup preferenceGroup) {
        ViewUtils.injectObject(handler, new ViewFinder(preferenceGroup));
    }

    public static void inject(Object handler, PreferenceActivity preferenceActivity) {
        ViewUtils.injectObject(handler, new ViewFinder(preferenceActivity));
    }

    private static void injectObject(Object handler, ViewFinder finder) {
        Method[] methods;
        Field[] fields;
        ContentView contentView;
        Class<?> handlerType = handler.getClass();
        if (Activity.class.isAssignableFrom(handlerType) && (contentView = handlerType.getAnnotation(ContentView.class)) != null) {
            ((Activity)handler).setContentView(contentView.value());
        }
        if ((fields = handlerType.getDeclaredFields()) != null && fields.length > 0) {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                ViewInject viewInject = field.getAnnotation(ViewInject.class);
                if (viewInject != null) {
                    try {
                        View view = finder.findViewById(viewInject.value(), viewInject.parentId());
                        if (view != null) {
                            field.setAccessible(true);
                            field.set(handler, view);
                        }
                    }
                    catch (Throwable e) {
                        LogUtils.e(e.getMessage(), e);
                    }
                } else {
                    ResInject resInject = field.getAnnotation(ResInject.class);
                    if (resInject != null) {
                        try {
                            Object res = ResLoader.loadRes(resInject.type(), finder.getContext(), resInject.id());
                            if (res != null) {
                                field.setAccessible(true);
                                field.set(handler, res);
                            }
                        }
                        catch (Throwable e) {
                            LogUtils.e(e.getMessage(), e);
                        }
                    } else {
                        PreferenceInject preferenceInject = field.getAnnotation(PreferenceInject.class);
                        if (preferenceInject != null) {
                            try {
                                Preference preference = finder.findPreference(preferenceInject.value());
                                if (preference != null) {
                                    field.setAccessible(true);
                                    field.set(handler, preference);
                                }
                            }
                            catch (Throwable e) {
                                LogUtils.e(e.getMessage(), e);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        if ((methods = handlerType.getDeclaredMethods()) != null && methods.length > 0) {
            String eventName = OnClick.class.getCanonicalName();
            String prefix = eventName.substring(0, eventName.lastIndexOf(46));
            DoubleKeyValueMap<ViewInjectInfo, Annotation, Method> info_annotation_method_map = new DoubleKeyValueMap<ViewInjectInfo, Annotation, Method>();
            Method[] methodArray = methods;
            int n = methods.length;
            int n3 = 0;
            while (n3 < n) {
                Method method = methodArray[n3];
                Annotation[] annotations = method.getDeclaredAnnotations();
                if (annotations != null && annotations.length > 0) {
                    Annotation[] annotationArray = annotations;
                    int n4 = annotations.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        Annotation annotation = annotationArray[n5];
                        Class<? extends Annotation> annType = annotation.annotationType();
                        if (annType.getAnnotation(EventBase.class) != null) {
                            if (annType.getCanonicalName().startsWith(prefix)) {
                                try {
                                    Method valueMethod = annType.getDeclaredMethod("value", new Class[0]);
                                    Method parentIdMethod = null;
                                    try {
                                        parentIdMethod = annType.getDeclaredMethod("parentId", new Class[0]);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    Object values = valueMethod.invoke((Object)annotation, new Object[0]);
                                    Object parentIds = parentIdMethod == null ? null : parentIdMethod.invoke((Object)annotation, new Object[0]);
                                    int parentIdsLen = parentIds == null ? 0 : Array.getLength(parentIds);
                                    int len = Array.getLength(values);
                                    int i = 0;
                                    while (i < len) {
                                        ViewInjectInfo info = new ViewInjectInfo();
                                        info.value = Array.get(values, i);
                                        info.parentId = parentIdsLen > i ? (Integer)Array.get(parentIds, i) : 0;
                                        info_annotation_method_map.put(info, annotation, method);
                                        ++i;
                                    }
                                }
                                catch (Throwable e) {
                                    LogUtils.e(e.getMessage(), e);
                                }
                            } else {
                                ViewCustomEventListener listener = annotationType_viewCustomEventListener_map.get(annType);
                                if (listener != null) {
                                    listener.setEventListener(handler, finder, annotation, method);
                                }
                            }
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
            ViewCommonEventListener.setAllEventListeners(handler, finder, info_annotation_method_map);
        }
    }
}

