/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.bitmap;

import android.app.ActivityManager;
import android.content.Context;
import android.text.TextUtils;
import com.lidroid.xutils.bitmap.BitmapCacheListener;
import com.lidroid.xutils.bitmap.BitmapCommonUtils;
import com.lidroid.xutils.bitmap.core.BitmapCache;
import com.lidroid.xutils.bitmap.download.Downloader;
import com.lidroid.xutils.bitmap.download.SimpleDownloader;
import com.lidroid.xutils.util.LogUtils;
import com.lidroid.xutils.util.core.CompatibleAsyncTask;
import com.lidroid.xutils.util.core.LruDiskCache;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class BitmapGlobalConfig {
    private String diskCachePath;
    public static final int MIN_MEMORY_CACHE_SIZE = 0x200000;
    private int memoryCacheSize = 0x400000;
    public static final int MIN_DISK_CACHE_SIZE = 0xA00000;
    private int diskCacheSize = 0x3200000;
    private boolean memoryCacheEnabled = true;
    private boolean diskCacheEnabled = true;
    private Downloader downloader;
    private BitmapCache bitmapCache;
    private int threadPoolSize = 5;
    private boolean _dirty_params_bitmapLoadExecutor = true;
    private ExecutorService bitmapLoadExecutor;
    private long defaultCacheExpiry = 2592000000L;
    private int defaultConnectTimeout = 15000;
    private int defaultReadTimeout = 15000;
    private LruDiskCache.DiskCacheFileNameGenerator diskCacheFileNameGenerator;
    private BitmapCacheListener bitmapCacheListener;
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "BitmapUtils #" + this.mCount.getAndIncrement());
            thread.setPriority(4);
            return thread;
        }
    };
    private Context mContext;

    public BitmapGlobalConfig(Context context, String diskCachePath) {
        if (context == null) {
            throw new IllegalArgumentException("context may not be null");
        }
        this.mContext = context;
        this.diskCachePath = diskCachePath;
        this.initBitmapCache();
    }

    private void initBitmapCache() {
        new BitmapCacheManagementTask().execute(0);
        new BitmapCacheManagementTask().execute(1);
    }

    public String getDiskCachePath() {
        if (TextUtils.isEmpty((CharSequence)this.diskCachePath)) {
            this.diskCachePath = BitmapCommonUtils.getDiskCacheDir(this.mContext, "xBitmapCache");
        }
        return this.diskCachePath;
    }

    public Downloader getDownloader() {
        if (this.downloader == null) {
            this.downloader = new SimpleDownloader();
        }
        this.downloader.setContext(this.mContext);
        this.downloader.setDefaultExpiry(this.getDefaultCacheExpiry());
        this.downloader.setDefaultConnectTimeout(this.getDefaultConnectTimeout());
        this.downloader.setDefaultReadTimeout(this.getDefaultReadTimeout());
        return this.downloader;
    }

    public void setDownloader(Downloader downloader) {
        this.downloader = downloader;
    }

    public long getDefaultCacheExpiry() {
        return this.defaultCacheExpiry;
    }

    public void setDefaultCacheExpiry(long defaultCacheExpiry) {
        this.defaultCacheExpiry = defaultCacheExpiry;
    }

    public int getDefaultConnectTimeout() {
        return this.defaultConnectTimeout;
    }

    public void setDefaultConnectTimeout(int defaultConnectTimeout) {
        this.defaultConnectTimeout = defaultConnectTimeout;
    }

    public int getDefaultReadTimeout() {
        return this.defaultReadTimeout;
    }

    public void setDefaultReadTimeout(int defaultReadTimeout) {
        this.defaultReadTimeout = defaultReadTimeout;
    }

    public BitmapCache getBitmapCache() {
        if (this.bitmapCache == null) {
            this.bitmapCache = new BitmapCache(this);
        }
        return this.bitmapCache;
    }

    public int getMemoryCacheSize() {
        return this.memoryCacheSize;
    }

    public void setMemoryCacheSize(int memoryCacheSize) {
        if (memoryCacheSize >= 0x200000) {
            this.memoryCacheSize = memoryCacheSize;
            if (this.bitmapCache != null) {
                this.bitmapCache.setMemoryCacheSize(this.memoryCacheSize);
            }
        } else {
            this.setMemCacheSizePercent(0.3f);
        }
    }

    public void setMemCacheSizePercent(float percent) {
        if (percent < 0.05f || percent > 0.8f) {
            throw new IllegalArgumentException("percent must be between 0.05 and 0.8 (inclusive)");
        }
        this.memoryCacheSize = Math.round(percent * (float)this.getMemoryClass() * 1024.0f * 1024.0f);
        if (this.bitmapCache != null) {
            this.bitmapCache.setMemoryCacheSize(this.memoryCacheSize);
        }
    }

    public int getDiskCacheSize() {
        return this.diskCacheSize;
    }

    public void setDiskCacheSize(int diskCacheSize) {
        if (diskCacheSize >= 0xA00000) {
            this.diskCacheSize = diskCacheSize;
            if (this.bitmapCache != null) {
                this.bitmapCache.setDiskCacheSize(this.diskCacheSize);
            }
        }
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        if (threadPoolSize > 0 && threadPoolSize != this.threadPoolSize) {
            this._dirty_params_bitmapLoadExecutor = true;
            this.threadPoolSize = threadPoolSize;
        }
    }

    public ExecutorService getBitmapLoadExecutor() {
        if (this._dirty_params_bitmapLoadExecutor || this.bitmapLoadExecutor == null) {
            this.bitmapLoadExecutor = Executors.newFixedThreadPool(this.getThreadPoolSize(), sThreadFactory);
            this._dirty_params_bitmapLoadExecutor = false;
        }
        return this.bitmapLoadExecutor;
    }

    public boolean isMemoryCacheEnabled() {
        return this.memoryCacheEnabled;
    }

    public void setMemoryCacheEnabled(boolean memoryCacheEnabled) {
        this.memoryCacheEnabled = memoryCacheEnabled;
    }

    public boolean isDiskCacheEnabled() {
        return this.diskCacheEnabled;
    }

    public void setDiskCacheEnabled(boolean diskCacheEnabled) {
        this.diskCacheEnabled = diskCacheEnabled;
    }

    public LruDiskCache.DiskCacheFileNameGenerator getDiskCacheFileNameGenerator() {
        return this.diskCacheFileNameGenerator;
    }

    public void setDiskCacheFileNameGenerator(LruDiskCache.DiskCacheFileNameGenerator diskCacheFileNameGenerator) {
        this.diskCacheFileNameGenerator = diskCacheFileNameGenerator;
        if (this.bitmapCache != null) {
            this.bitmapCache.setDiskCacheFileNameGenerator(diskCacheFileNameGenerator);
        }
    }

    public BitmapCacheListener getBitmapCacheListener() {
        return this.bitmapCacheListener;
    }

    public void setBitmapCacheListener(BitmapCacheListener bitmapCacheListener) {
        this.bitmapCacheListener = bitmapCacheListener;
    }

    private int getMemoryClass() {
        return ((ActivityManager)this.mContext.getSystemService("activity")).getMemoryClass();
    }

    public void clearCache() {
        new BitmapCacheManagementTask().execute(4);
    }

    public void clearMemoryCache() {
        new BitmapCacheManagementTask().execute(5);
    }

    public void clearDiskCache() {
        new BitmapCacheManagementTask().execute(6);
    }

    public void clearCache(String uri) {
        new BitmapCacheManagementTask().execute(7, uri);
    }

    public void clearMemoryCache(String uri) {
        new BitmapCacheManagementTask().execute(8, uri);
    }

    public void clearDiskCache(String uri) {
        new BitmapCacheManagementTask().execute(9, uri);
    }

    public void flushCache() {
        new BitmapCacheManagementTask().execute(2);
    }

    public void closeCache() {
        new BitmapCacheManagementTask().execute(3);
    }

    private class BitmapCacheManagementTask
    extends CompatibleAsyncTask<Object, Void, Object[]> {
        public static final int MESSAGE_INIT_MEMORY_CACHE = 0;
        public static final int MESSAGE_INIT_DISK_CACHE = 1;
        public static final int MESSAGE_FLUSH = 2;
        public static final int MESSAGE_CLOSE = 3;
        public static final int MESSAGE_CLEAR = 4;
        public static final int MESSAGE_CLEAR_MEMORY = 5;
        public static final int MESSAGE_CLEAR_DISK = 6;
        public static final int MESSAGE_CLEAR_BY_KEY = 7;
        public static final int MESSAGE_CLEAR_MEMORY_BY_KEY = 8;
        public static final int MESSAGE_CLEAR_DISK_BY_KEY = 9;

        private BitmapCacheManagementTask() {
        }

        @Override
        protected Object[] doInBackground(Object ... params) {
            if (params == null || params.length == 0) {
                return params;
            }
            BitmapCache cache = BitmapGlobalConfig.this.getBitmapCache();
            if (cache == null) {
                return params;
            }
            try {
                switch ((Integer)params[0]) {
                    case 0: {
                        cache.initMemoryCache();
                        break;
                    }
                    case 1: {
                        cache.initDiskCache();
                        break;
                    }
                    case 2: {
                        cache.flush();
                        break;
                    }
                    case 3: {
                        cache.clearMemoryCache();
                        cache.close();
                        break;
                    }
                    case 4: {
                        cache.clearCache();
                        break;
                    }
                    case 5: {
                        cache.clearMemoryCache();
                        break;
                    }
                    case 6: {
                        cache.clearDiskCache();
                        break;
                    }
                    case 7: {
                        if (params.length != 2) {
                            return params;
                        }
                        cache.clearCache(String.valueOf(params[1]));
                        break;
                    }
                    case 8: {
                        if (params.length != 2) {
                            return params;
                        }
                        cache.clearMemoryCache(String.valueOf(params[1]));
                        break;
                    }
                    case 9: {
                        if (params.length != 2) {
                            return params;
                        }
                        cache.clearDiskCache(String.valueOf(params[1]));
                        break;
                    }
                }
            }
            catch (Throwable e) {
                LogUtils.e(e.getMessage(), e);
            }
            return params;
        }

        @Override
        protected void onPostExecute(Object[] params) {
            if (BitmapGlobalConfig.this.bitmapCacheListener == null || params == null || params.length == 0) {
                return;
            }
            try {
                switch ((Integer)params[0]) {
                    case 0: {
                        BitmapGlobalConfig.this.bitmapCacheListener.onInitMemoryCacheFinished();
                        break;
                    }
                    case 1: {
                        BitmapGlobalConfig.this.bitmapCacheListener.onInitDiskFinished();
                        break;
                    }
                    case 2: {
                        BitmapGlobalConfig.this.bitmapCacheListener.onFlushCacheFinished();
                        break;
                    }
                    case 3: {
                        BitmapGlobalConfig.this.bitmapCacheListener.onCloseCacheFinished();
                        break;
                    }
                    case 4: {
                        BitmapGlobalConfig.this.bitmapCacheListener.onClearCacheFinished();
                        break;
                    }
                    case 5: {
                        BitmapGlobalConfig.this.bitmapCacheListener.onClearMemoryCacheFinished();
                        break;
                    }
                    case 6: {
                        BitmapGlobalConfig.this.bitmapCacheListener.onClearDiskCacheFinished();
                        break;
                    }
                    case 7: {
                        if (params.length != 2) {
                            return;
                        }
                        BitmapGlobalConfig.this.bitmapCacheListener.onClearCacheFinished(String.valueOf(params[1]));
                        break;
                    }
                    case 8: {
                        if (params.length != 2) {
                            return;
                        }
                        BitmapGlobalConfig.this.bitmapCacheListener.onClearMemoryCacheFinished(String.valueOf(params[1]));
                        break;
                    }
                    case 9: {
                        if (params.length != 2) {
                            return;
                        }
                        BitmapGlobalConfig.this.bitmapCacheListener.onClearDiskCacheFinished(String.valueOf(params[1]));
                        break;
                    }
                }
            }
            catch (Throwable e) {
                LogUtils.e(e.getMessage(), e);
            }
        }
    }
}

