/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.util.SparseArray;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public class MediaCodecListCollector {
    private static final String COLOR_FORMAT_PREFIX = "COLOR_";
    private static final String[] MPEG4_TYPES = new String[]{"mp4", "mpeg4", "MP4", "MPEG4"};
    private static final String[] AVC_TYPES = new String[]{"avc", "h264", "AVC", "H264"};
    private static final String[] H263_TYPES = new String[]{"h263", "H263"};
    private static final String[] AAC_TYPES = new String[]{"aac", "AAC"};
    private static Class<?> mediaCodecListClass = null;
    private static Method getCodecInfoAtMethod = null;
    private static Class<?> mediaCodecInfoClass = null;
    private static Method getNameMethod = null;
    private static Method isEncoderMethod = null;
    private static Method getSupportedTypesMethod = null;
    private static Method getCapabilitiesForTypeMethod = null;
    private static Class<?> codecCapabilitiesClass = null;
    private static Field colorFormatsField = null;
    private static Field profileLevelsField = null;
    private static Field profileField = null;
    private static Field levelField = null;
    private static SparseArray<String> mColorFormatValues = new SparseArray();
    private static SparseArray<String> mAVCLevelValues = new SparseArray();
    private static SparseArray<String> mAVCProfileValues = new SparseArray();
    private static SparseArray<String> mH263LevelValues = new SparseArray();
    private static SparseArray<String> mH263ProfileValues = new SparseArray();
    private static SparseArray<String> mMPEG4LevelValues = new SparseArray();
    private static SparseArray<String> mMPEG4ProfileValues = new SparseArray();
    private static SparseArray<String> mAACProfileValues = new SparseArray();

    static {
        try {
            mediaCodecListClass = Class.forName("android.media.MediaCodecList");
            getCodecInfoAtMethod = mediaCodecListClass.getMethod("getCodecInfoAt", Integer.TYPE);
            mediaCodecInfoClass = Class.forName("android.media.MediaCodecInfo");
            getNameMethod = mediaCodecInfoClass.getMethod("getName", new Class[0]);
            isEncoderMethod = mediaCodecInfoClass.getMethod("isEncoder", new Class[0]);
            getSupportedTypesMethod = mediaCodecInfoClass.getMethod("getSupportedTypes", new Class[0]);
            getCapabilitiesForTypeMethod = mediaCodecInfoClass.getMethod("getCapabilitiesForType", String.class);
            codecCapabilitiesClass = Class.forName("android.media.MediaCodecInfo$CodecCapabilities");
            colorFormatsField = codecCapabilitiesClass.getField("colorFormats");
            profileLevelsField = codecCapabilitiesClass.getField("profileLevels");
            Field[] fieldArray = codecCapabilitiesClass.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (Modifier.isStatic(f.getModifiers()) && Modifier.isFinal(f.getModifiers()) && f.getName().startsWith(COLOR_FORMAT_PREFIX)) {
                    mColorFormatValues.put(f.getInt(null), (Object)f.getName());
                }
                ++n2;
            }
            Class<?> codecProfileLevelClass = Class.forName("android.media.MediaCodecInfo$CodecProfileLevel");
            Field[] fieldArray2 = codecProfileLevelClass.getFields();
            int n3 = fieldArray2.length;
            n = 0;
            while (n < n3) {
                Field f = fieldArray2[n];
                if (Modifier.isStatic(f.getModifiers()) && Modifier.isFinal(f.getModifiers())) {
                    if (f.getName().startsWith("AVCLevel")) {
                        mAVCLevelValues.put(f.getInt(null), (Object)f.getName());
                    } else if (f.getName().startsWith("AVCProfile")) {
                        mAVCProfileValues.put(f.getInt(null), (Object)f.getName());
                    } else if (f.getName().startsWith("H263Level")) {
                        mH263LevelValues.put(f.getInt(null), (Object)f.getName());
                    } else if (f.getName().startsWith("H263Profile")) {
                        mH263ProfileValues.put(f.getInt(null), (Object)f.getName());
                    } else if (f.getName().startsWith("MPEG4Level")) {
                        mMPEG4LevelValues.put(f.getInt(null), (Object)f.getName());
                    } else if (f.getName().startsWith("MPEG4Profile")) {
                        mMPEG4ProfileValues.put(f.getInt(null), (Object)f.getName());
                    } else if (f.getName().startsWith("AAC")) {
                        mAACProfileValues.put(f.getInt(null), (Object)f.getName());
                    }
                }
                ++n;
            }
            profileField = codecProfileLevelClass.getField("profile");
            levelField = codecProfileLevelClass.getField("level");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    public static String collecMediaCodecList() {
        StringBuilder result = new StringBuilder();
        if (mediaCodecListClass != null && mediaCodecInfoClass != null) {
            try {
                int codecCount = (Integer)mediaCodecListClass.getMethod("getCodecCount", new Class[0]).invoke(null, new Object[0]);
                Object codecInfo = null;
                int codecIdx = 0;
                while (codecIdx < codecCount) {
                    result.append("\n");
                    codecInfo = getCodecInfoAtMethod.invoke(null, codecIdx);
                    result.append(codecIdx).append(": ").append(getNameMethod.invoke(codecInfo, new Object[0])).append("\n");
                    result.append("isEncoder: ").append(isEncoderMethod.invoke(codecInfo, new Object[0])).append("\n");
                    Object[] supportedTypes = (String[])getSupportedTypesMethod.invoke(codecInfo, new Object[0]);
                    result.append("Supported types: ").append(Arrays.toString(supportedTypes)).append("\n");
                    Object[] objectArray = supportedTypes;
                    int n = supportedTypes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object type = objectArray[n2];
                        result.append(MediaCodecListCollector.collectCapabilitiesForType(codecInfo, (String)type));
                        ++n2;
                    }
                    result.append("\n");
                    ++codecIdx;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return result.toString();
    }

    private static String collectCapabilitiesForType(Object codecInfo, String type) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] codecProfileLevels;
        StringBuilder result = new StringBuilder();
        Object codecCapabilities = getCapabilitiesForTypeMethod.invoke(codecInfo, type);
        int[] colorFormats = (int[])colorFormatsField.get(codecCapabilities);
        if (colorFormats.length > 0) {
            result.append(type).append(" color formats:");
            int i = 0;
            while (i < colorFormats.length) {
                result.append((String)mColorFormatValues.get(colorFormats[i]));
                if (i < colorFormats.length - 1) {
                    result.append(',');
                }
                ++i;
            }
            result.append("\n");
        }
        if ((codecProfileLevels = (Object[])profileLevelsField.get(codecCapabilities)).length > 0) {
            result.append(type).append(" profile levels:");
            int i = 0;
            while (i < codecProfileLevels.length) {
                CodecType codecType = MediaCodecListCollector.identifyCodecType(codecInfo);
                int profileValue = profileField.getInt(codecProfileLevels[i]);
                int levelValue = levelField.getInt(codecProfileLevels[i]);
                if (codecType == null) {
                    result.append(profileValue).append('-').append(levelValue);
                }
                switch (codecType) {
                    case AVC: {
                        result.append(profileValue).append((String)mAVCProfileValues.get(profileValue)).append('-').append((String)mAVCLevelValues.get(levelValue));
                        break;
                    }
                    case H263: {
                        result.append((String)mH263ProfileValues.get(profileValue)).append('-').append((String)mH263LevelValues.get(levelValue));
                        break;
                    }
                    case MPEG4: {
                        result.append((String)mMPEG4ProfileValues.get(profileValue)).append('-').append((String)mMPEG4LevelValues.get(levelValue));
                        break;
                    }
                    case AAC: {
                        result.append((String)mAACProfileValues.get(profileValue));
                        break;
                    }
                }
                if (i < codecProfileLevels.length - 1) {
                    result.append(',');
                }
                ++i;
            }
            result.append("\n");
        }
        return result.append("\n").toString();
    }

    private static CodecType identifyCodecType(Object codecInfo) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String token;
        String name = (String)getNameMethod.invoke(codecInfo, new Object[0]);
        String[] stringArray = AVC_TYPES;
        int n = AVC_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            token = stringArray[n2];
            if (name.contains(token)) {
                return CodecType.AVC;
            }
            ++n2;
        }
        stringArray = H263_TYPES;
        n = H263_TYPES.length;
        n2 = 0;
        while (n2 < n) {
            token = stringArray[n2];
            if (name.contains(token)) {
                return CodecType.H263;
            }
            ++n2;
        }
        stringArray = MPEG4_TYPES;
        n = MPEG4_TYPES.length;
        n2 = 0;
        while (n2 < n) {
            token = stringArray[n2];
            if (name.contains(token)) {
                return CodecType.MPEG4;
            }
            ++n2;
        }
        stringArray = AAC_TYPES;
        n = AAC_TYPES.length;
        n2 = 0;
        while (n2 < n) {
            token = stringArray[n2];
            if (name.contains(token)) {
                return CodecType.AAC;
            }
            ++n2;
        }
        return null;
    }

    private static enum CodecType {
        AVC,
        H263,
        MPEG4,
        AAC;

    }
}

