/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

final class ReflectionCollector {
    ReflectionCollector() {
    }

    public static String collectConstants(Class<?> someClass, String prefix) {
        Field[] fields;
        StringBuilder result = new StringBuilder();
        Field[] fieldArray = fields = someClass.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (prefix != null && prefix.length() > 0) {
                result.append(prefix).append('.');
            }
            result.append(field.getName()).append("=");
            try {
                Object value = field.get(null);
                if (value != null) {
                    if (field.getType().isArray()) {
                        result.append(Arrays.toString((Object[])value));
                    } else {
                        result.append(value.toString());
                    }
                }
            }
            catch (IllegalArgumentException e) {
                result.append("N/A");
            }
            catch (IllegalAccessException e) {
                result.append("N/A");
            }
            result.append("\n");
            ++n2;
        }
        return result.toString();
    }

    public static String collectStaticGettersResults(Class<?> someClass) {
        Method[] methods;
        StringBuilder result = new StringBuilder();
        Method[] methodArray = methods = someClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getParameterTypes().length == 0 && (method.getName().startsWith("get") || method.getName().startsWith("is")) && !method.getName().equals("getClass")) {
                try {
                    result.append(method.getName());
                    result.append('=');
                    result.append(method.invoke(null, null));
                    result.append("\n");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return result.toString();
    }

    public static String collectConstants(Class<?> someClass) {
        return ReflectionCollector.collectConstants(someClass, "");
    }
}

