/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.content.Context;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.acra.ACRA;
import org.acra.CrashReportFileNameParser;
import org.acra.CrashReportFinder;
import org.acra.CrashReportPersister;
import org.acra.collector.CrashReportData;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderException;

final class SendWorker
extends Thread {
    private final Context context;
    private final boolean sendOnlySilentReports;
    private final boolean approvePendingReports;
    private final CrashReportFileNameParser fileNameParser = new CrashReportFileNameParser();
    private final List<ReportSender> reportSenders;

    public SendWorker(Context context, List<ReportSender> reportSenders, boolean sendOnlySilentReports, boolean approvePendingReports) {
        this.context = context;
        this.reportSenders = reportSenders;
        this.sendOnlySilentReports = sendOnlySilentReports;
        this.approvePendingReports = approvePendingReports;
    }

    @Override
    public void run() {
        if (this.approvePendingReports) {
            this.approvePendingReports();
        }
        this.checkAndSendReports(this.context, this.sendOnlySilentReports);
    }

    private void approvePendingReports() {
        String[] reportFileNames;
        ACRA.log.d(ACRA.LOG_TAG, "Mark all pending reports as approved.");
        CrashReportFinder reportFinder = new CrashReportFinder(this.context);
        String[] stringArray = reportFileNames = reportFinder.getCrashReportFiles();
        int n = reportFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String reportFileName = stringArray[n2];
            if (!this.fileNameParser.isApproved(reportFileName)) {
                File reportFile = new File(this.context.getFilesDir(), reportFileName);
                String newName = reportFileName.replace(".stacktrace", "-approved.stacktrace");
                File newFile = new File(this.context.getFilesDir(), newName);
                if (!reportFile.renameTo(newFile)) {
                    ACRA.log.e(ACRA.LOG_TAG, "Could not rename approved report from " + reportFile + " to " + newFile);
                }
            }
            ++n2;
        }
    }

    private void checkAndSendReports(Context context, boolean sendOnlySilentReports) {
        ACRA.log.d(ACRA.LOG_TAG, "#checkAndSendReports - start");
        CrashReportFinder reportFinder = new CrashReportFinder(context);
        Object[] reportFiles = reportFinder.getCrashReportFiles();
        Arrays.sort(reportFiles);
        int reportsSentCount = 0;
        Object[] objectArray = reportFiles;
        int n = reportFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Object curFileName = objectArray[n2];
            if (!sendOnlySilentReports || this.fileNameParser.isSilent((String)curFileName)) {
                if (reportsSentCount >= 5) break;
                ACRA.log.i(ACRA.LOG_TAG, "Sending file " + (String)curFileName);
                try {
                    CrashReportPersister persister = new CrashReportPersister(context);
                    CrashReportData previousCrashReport = persister.load((String)curFileName);
                    this.sendCrashReport(previousCrashReport);
                    this.deleteFile(context, (String)curFileName);
                }
                catch (RuntimeException e) {
                    ACRA.log.e(ACRA.LOG_TAG, "Failed to send crash reports for " + (String)curFileName, e);
                    this.deleteFile(context, (String)curFileName);
                    break;
                }
                catch (IOException e) {
                    ACRA.log.e(ACRA.LOG_TAG, "Failed to load crash report for " + (String)curFileName, e);
                    this.deleteFile(context, (String)curFileName);
                    break;
                }
                catch (ReportSenderException e) {
                    ACRA.log.e(ACRA.LOG_TAG, "Failed to send crash report for " + (String)curFileName, e);
                }
                ++reportsSentCount;
            }
            ++n2;
        }
        ACRA.log.d(ACRA.LOG_TAG, "#checkAndSendReports - finish");
    }

    private void sendCrashReport(CrashReportData errorContent) throws ReportSenderException {
        if (!ACRA.isDebuggable() || ACRA.getConfig().sendReportsInDevMode()) {
            boolean sentAtLeastOnce = false;
            for (ReportSender sender : this.reportSenders) {
                try {
                    sender.send(this.context, errorContent);
                    sentAtLeastOnce = true;
                }
                catch (ReportSenderException e) {
                    if (!sentAtLeastOnce) {
                        throw e;
                    }
                    ACRA.log.w(ACRA.LOG_TAG, "ReportSender of class " + sender.getClass().getName() + " failed but other senders completed their task. ACRA will not send this report again.");
                }
            }
        }
    }

    private void deleteFile(Context context, String fileName) {
        boolean deleted = context.deleteFile(fileName);
        if (!deleted) {
            ACRA.log.w(ACRA.LOG_TAG, "Could not delete error report : " + fileName);
        }
    }
}

