/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.collector.CollectorUtil;
import org.acra.collector.CrashReportData;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONReportBuilder {
    public static JSONObject buildJSONReport(CrashReportData errorContent) throws JSONReportException {
        JSONObject jsonReport = new JSONObject();
        BufferedReader reader = null;
        for (ReportField key : errorContent.keySet()) {
            try {
                try {
                    if (key.containsKeyValuePairs()) {
                        JSONObject subObject = new JSONObject();
                        String strContent = errorContent.getProperty(key);
                        reader = new BufferedReader(new StringReader(strContent), 1024);
                        String line = null;
                        try {
                            while ((line = reader.readLine()) != null) {
                                JSONReportBuilder.addJSONFromProperty(subObject, line);
                            }
                        }
                        catch (IOException e) {
                            ACRA.log.e(ACRA.LOG_TAG, "Error while converting " + key.name() + " to JSON.", e);
                        }
                        jsonReport.accumulate(key.name(), (Object)subObject);
                        continue;
                    }
                    jsonReport.accumulate(key.name(), JSONReportBuilder.guessType(errorContent.getProperty(key)));
                }
                catch (JSONException e) {
                    throw new JSONReportException("Could not create JSON object for key " + (Object)((Object)key), e);
                }
            }
            finally {
                CollectorUtil.safeClose(reader);
            }
        }
        return jsonReport;
    }

    private static void addJSONFromProperty(JSONObject destination, String propertyString) throws JSONException {
        int equalsIndex = propertyString.indexOf(61);
        if (equalsIndex > 0) {
            String[] splitKey;
            JSONObject finalObject = destination;
            String currentKey = propertyString.substring(0, equalsIndex).trim();
            String currentValue = propertyString.substring(equalsIndex + 1).trim();
            Object value = JSONReportBuilder.guessType(currentValue);
            if (value instanceof String) {
                value = ((String)value).replaceAll("\\\\n", "\n");
            }
            if ((splitKey = currentKey.split("\\.")).length > 1) {
                JSONReportBuilder.addJSONSubTree(finalObject, splitKey, value);
            } else {
                finalObject.accumulate(currentKey, value);
            }
        } else {
            destination.put(propertyString.trim(), true);
        }
    }

    private static Object guessType(String value) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        if (value.matches("(?:^|\\s)([1-9](?:\\d*|(?:\\d{0,2})(?:,\\d{3})*)(?:\\.\\d*[1-9])?|0?\\.\\d*[1-9]|0)(?:\\s|$)")) {
            NumberFormat format = NumberFormat.getInstance(Locale.US);
            try {
                Number number = format.parse(value);
                return number;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return value;
    }

    private static void addJSONSubTree(JSONObject destination, String[] keys, Object value) throws JSONException {
        int i = 0;
        while (i < keys.length) {
            String subKey = keys[i];
            if (i < keys.length - 1) {
                JSONObject intermediate = null;
                if (destination.isNull(subKey)) {
                    intermediate = new JSONObject();
                    destination.accumulate(subKey, (Object)intermediate);
                } else {
                    Object target = destination.get(subKey);
                    if (target instanceof JSONObject) {
                        intermediate = destination.getJSONObject(subKey);
                    } else if (target instanceof JSONArray) {
                        JSONArray wildCard = destination.getJSONArray(subKey);
                        int j = 0;
                        while (j < wildCard.length()) {
                            intermediate = wildCard.optJSONObject(j);
                            if (intermediate != null) break;
                            ++j;
                        }
                    }
                    if (intermediate == null) {
                        ACRA.log.e(ACRA.LOG_TAG, "Unknown json subtree type, see issue #186");
                        return;
                    }
                }
                destination = intermediate;
            } else {
                destination.accumulate(subKey, value);
            }
            ++i;
        }
    }

    public static class JSONReportException
    extends Exception {
        private static final long serialVersionUID = -694684023635442219L;

        public JSONReportException(String message, Throwable e) {
            super(message, e);
        }
    }
}

