/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import org.acra.ACRA;
import org.acra.BaseCrashReportDialog;

public class CrashReportDialog
extends BaseCrashReportDialog
implements DialogInterface.OnClickListener,
DialogInterface.OnDismissListener {
    private static final String STATE_EMAIL = "email";
    private static final String STATE_COMMENT = "comment";
    private EditText userCommentView;
    private EditText userEmailView;
    AlertDialog mDialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)this);
        int titleResourceId = ACRA.getConfig().resDialogTitle();
        if (titleResourceId != 0) {
            dialogBuilder.setTitle(titleResourceId);
        }
        dialogBuilder.setView(this.buildCustomView(savedInstanceState));
        dialogBuilder.setPositiveButton(this.getText(ACRA.getConfig().resDialogPositiveButtonText()), (DialogInterface.OnClickListener)this);
        dialogBuilder.setNegativeButton(this.getText(ACRA.getConfig().resDialogNegativeButtonText()), (DialogInterface.OnClickListener)this);
        this.mDialog = dialogBuilder.create();
        this.mDialog.setCanceledOnTouchOutside(false);
        this.mDialog.setOnDismissListener((DialogInterface.OnDismissListener)this);
        this.mDialog.show();
    }

    protected View buildCustomView(Bundle savedInstanceState) {
        float nowDensity = this.getResources().getDisplayMetrics().density;
        LinearLayout root = new LinearLayout((Context)this);
        root.setOrientation(1);
        root.setPadding((int)(8.0f * nowDensity), (int)(8.0f * nowDensity), (int)(8.0f * nowDensity), (int)(8.0f * nowDensity));
        root.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        root.setFocusable(true);
        root.setFocusableInTouchMode(true);
        ScrollView scroll = new ScrollView((Context)this);
        root.addView((View)scroll, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        LinearLayout scrollable = new LinearLayout((Context)this);
        scrollable.setOrientation(1);
        scroll.addView((View)scrollable);
        TextView text = new TextView((Context)this);
        int dialogTextId = ACRA.getConfig().resDialogText();
        if (dialogTextId != 0) {
            text.setText(this.getText(dialogTextId));
            text.setTextSize(16.0f);
            text.setPadding((int)(8.0f * nowDensity), (int)(8.0f * nowDensity), (int)(8.0f * nowDensity), (int)(8.0f * nowDensity));
        }
        scrollable.addView((View)text);
        return root;
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1) {
            String userEmail;
            String comment = this.userCommentView != null ? this.userCommentView.getText().toString() : "";
            SharedPreferences prefs = ACRA.getACRASharedPreferences();
            if (this.userEmailView != null) {
                userEmail = this.userEmailView.getText().toString();
                SharedPreferences.Editor prefEditor = prefs.edit();
                prefEditor.putString("acra.user.email", userEmail);
                prefEditor.commit();
            } else {
                userEmail = prefs.getString("acra.user.email", "");
            }
            this.sendCrash(comment, userEmail);
        } else {
            this.cancelReports();
        }
        this.finish();
    }

    public void onDismiss(DialogInterface dialog) {
        this.finish();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.userCommentView != null && this.userCommentView.getText() != null) {
            outState.putString(STATE_COMMENT, this.userCommentView.getText().toString());
        }
        if (this.userEmailView != null && this.userEmailView.getText() != null) {
            outState.putString(STATE_EMAIL, this.userEmailView.getText().toString());
        }
    }
}

