/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.content.Context;
import java.io.File;
import java.io.FilenameFilter;
import org.acra.ACRA;

final class CrashReportFinder {
    private final Context context;

    public CrashReportFinder(Context context) {
        this.context = context;
    }

    public String[] getCrashReportFiles() {
        if (this.context == null) {
            ACRA.log.e(ACRA.LOG_TAG, "Trying to get ACRA reports but ACRA is not initialized.");
            return new String[0];
        }
        File dir = this.context.getFilesDir();
        if (dir == null) {
            ACRA.log.w(ACRA.LOG_TAG, "Application files directory does not exist! The application may not be installed correctly. Please try reinstalling.");
            return new String[0];
        }
        ACRA.log.d(ACRA.LOG_TAG, "Looking for error files in " + dir.getAbsolutePath());
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".stacktrace");
            }
        };
        String[] result = dir.list(filter);
        return result == null ? new String[]{} : result;
    }
}

