/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.acra.ACRA;
import org.acra.collector.Compatibility;

final class SettingsCollector {
    SettingsCollector() {
    }

    public static String collectSystemSettings(Context ctx) {
        Field[] keys;
        StringBuilder result = new StringBuilder();
        Field[] fieldArray = keys = Settings.System.class.getFields();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Field key = fieldArray[n2];
            if (!key.isAnnotationPresent(Deprecated.class) && key.getType() == String.class) {
                try {
                    String value = Settings.System.getString((ContentResolver)ctx.getContentResolver(), (String)((String)key.get(null)));
                    if (value != null) {
                        result.append(key.getName()).append("=").append((Object)value).append("\n");
                    }
                }
                catch (IllegalArgumentException e) {
                    ACRA.log.w(ACRA.LOG_TAG, "Error : ", e);
                }
                catch (IllegalAccessException e) {
                    ACRA.log.w(ACRA.LOG_TAG, "Error : ", e);
                }
            }
            ++n2;
        }
        return result.toString();
    }

    public static String collectSecureSettings(Context ctx) {
        Field[] keys;
        StringBuilder result = new StringBuilder();
        Field[] fieldArray = keys = Settings.Secure.class.getFields();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Field key = fieldArray[n2];
            if (!key.isAnnotationPresent(Deprecated.class) && key.getType() == String.class && SettingsCollector.isAuthorized(key)) {
                try {
                    String value = Settings.Secure.getString((ContentResolver)ctx.getContentResolver(), (String)((String)key.get(null)));
                    if (value != null) {
                        result.append(key.getName()).append("=").append((Object)value).append("\n");
                    }
                }
                catch (IllegalArgumentException e) {
                    ACRA.log.w(ACRA.LOG_TAG, "Error : ", e);
                }
                catch (IllegalAccessException e) {
                    ACRA.log.w(ACRA.LOG_TAG, "Error : ", e);
                }
            }
            ++n2;
        }
        return result.toString();
    }

    public static String collectGlobalSettings(Context ctx) {
        if (Compatibility.getAPILevel() < 17) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        try {
            Class<?> globalClass = Class.forName("android.provider.Settings$Global");
            Field[] keys = globalClass.getFields();
            Method getString = globalClass.getMethod("getString", ContentResolver.class, String.class);
            Field[] fieldArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                Object value;
                Field key = fieldArray[n2];
                if (!key.isAnnotationPresent(Deprecated.class) && key.getType() == String.class && SettingsCollector.isAuthorized(key) && (value = getString.invoke(null, ctx.getContentResolver(), (String)key.get(null))) != null) {
                    result.append(key.getName()).append("=").append(value).append("\n");
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException e) {
            ACRA.log.w(ACRA.LOG_TAG, "Error : ", e);
        }
        catch (IllegalAccessException e) {
            ACRA.log.w(ACRA.LOG_TAG, "Error : ", e);
        }
        catch (ClassNotFoundException e) {
            ACRA.log.w(ACRA.LOG_TAG, "Error : ", e);
        }
        catch (SecurityException e) {
            ACRA.log.w(ACRA.LOG_TAG, "Error : ", e);
        }
        catch (NoSuchMethodException e) {
            ACRA.log.w(ACRA.LOG_TAG, "Error : ", e);
        }
        catch (InvocationTargetException e) {
            ACRA.log.w(ACRA.LOG_TAG, "Error : ", e);
        }
        return result.toString();
    }

    private static boolean isAuthorized(Field key) {
        if (key == null || key.getName().startsWith("WIFI_AP")) {
            return false;
        }
        String[] stringArray = ACRA.getConfig().excludeMatchingSettingsKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String regex = stringArray[n2];
            if (key.getName().matches(regex)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

