/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.net.SSLCertificateSocketFactory;
import android.text.TextUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.acra.ACRA;
import org.acra.collector.Compatibility;
import org.apache.http.conn.scheme.LayeredSocketFactory;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.params.HttpParams;

public class TlsSniSocketFactory
implements LayeredSocketFactory {
    private static final String TAG = TlsSniSocketFactory.class.getSimpleName();
    private final SSLCertificateSocketFactory sslSocketFactory = (SSLCertificateSocketFactory)SSLCertificateSocketFactory.getDefault((int)0);
    private static final HostnameVerifier hostnameVerifier = new BrowserCompatHostnameVerifier();
    private static final List<String> ALLOWED_CIPHERS = Arrays.asList("TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECHDE_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");

    public Socket connectSocket(Socket s, String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException {
        return null;
    }

    public Socket createSocket() throws IOException {
        return null;
    }

    public boolean isSecure(Socket s) throws IllegalArgumentException {
        return s instanceof SSLSocket && s.isConnected();
    }

    public Socket createSocket(Socket plainSocket, String host, int port, boolean autoClose) throws IOException {
        if (autoClose) {
            plainSocket.close();
        }
        SSLSocket ssl = (SSLSocket)this.sslSocketFactory.createSocket(InetAddress.getByName(host), port);
        this.establishAndVerify(ssl, host);
        return ssl;
    }

    private void establishAndVerify(SSLSocket socket, String host) throws IOException {
        this.setTlsParameters(socket);
        this.setSniHostname(socket, host);
        socket.startHandshake();
        SSLSession session = socket.getSession();
        if (!hostnameVerifier.verify(host, session)) {
            throw new SSLPeerUnverifiedException(host);
        }
        ACRA.log.i(TAG, "Established " + session.getProtocol() + " connection with " + session.getPeerHost() + " using " + session.getCipherSuite());
    }

    private void setTlsParameters(SSLSocket socket) {
        LinkedList<String> protocols = new LinkedList<String>();
        String[] stringArray = socket.getSupportedProtocols();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String protocol = stringArray[n2];
            if (!protocol.toUpperCase().contains("SSL")) {
                protocols.add(protocol);
            }
            ++n2;
        }
        ACRA.log.v(TAG, "Setting allowed TLS protocols: " + TextUtils.join((CharSequence)", ", protocols));
        socket.setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
        if (Compatibility.getAPILevel() < 21) {
            List<String> availableCiphers = Arrays.asList(socket.getSupportedCipherSuites());
            HashSet<String> preferredCiphers = new HashSet<String>(ALLOWED_CIPHERS);
            preferredCiphers.retainAll(availableCiphers);
            preferredCiphers.addAll(Arrays.asList(socket.getEnabledCipherSuites()));
            ACRA.log.v(TAG, "Setting allowed TLS ciphers: " + TextUtils.join((CharSequence)", ", preferredCiphers));
            socket.setEnabledCipherSuites(preferredCiphers.toArray(new String[preferredCiphers.size()]));
        }
    }

    private void setSniHostname(SSLSocket socket, String hostName) {
        if (Compatibility.getAPILevel() >= 17) {
            ACRA.log.d(TAG, "Using documented SNI with host name " + hostName);
            this.sslSocketFactory.setHostname((Socket)socket, hostName);
        } else {
            ACRA.log.d(TAG, "No documented SNI support on Android <4.2, trying reflection method with host name " + hostName);
            try {
                Method setHostnameMethod = socket.getClass().getMethod("setHostname", String.class);
                setHostnameMethod.invoke((Object)socket, hostName);
            }
            catch (Exception e) {
                ACRA.log.w(TAG, "SNI not usable", e);
            }
        }
    }
}

