/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.Activity;
import android.os.Bundle;
import java.io.IOException;
import org.acra.ACRA;
import org.acra.CrashReportPersister;
import org.acra.ReportField;
import org.acra.collector.CrashReportData;
import org.acra.util.ToastSender;

public abstract class BaseCrashReportDialog
extends Activity {
    private String mReportFileName;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ACRA.log.d(ACRA.LOG_TAG, "CrashReportDialog extras=" + this.getIntent().getExtras());
        boolean forceCancel = this.getIntent().getBooleanExtra("FORCE_CANCEL", false);
        if (forceCancel) {
            ACRA.log.d(ACRA.LOG_TAG, "Forced reports deletion.");
            this.cancelReports();
            this.finish();
            return;
        }
        this.mReportFileName = this.getIntent().getStringExtra("REPORT_FILE_NAME");
        ACRA.log.d(ACRA.LOG_TAG, "Opening CrashReportDialog for " + this.mReportFileName);
        if (this.mReportFileName == null) {
            this.finish();
        }
    }

    protected void cancelReports() {
        ACRA.getErrorReporter().deletePendingNonApprovedReports(false);
    }

    protected void sendCrash(String comment, String userEmail) {
        CrashReportPersister persister = new CrashReportPersister(this.getApplicationContext());
        try {
            ACRA.log.d(ACRA.LOG_TAG, "Add user comment to " + this.mReportFileName);
            CrashReportData crashData = persister.load(this.mReportFileName);
            crashData.put(ReportField.USER_COMMENT, comment == null ? "" : comment);
            crashData.put(ReportField.USER_EMAIL, userEmail == null ? "" : userEmail);
            persister.store(crashData, this.mReportFileName);
        }
        catch (IOException e) {
            ACRA.log.w(ACRA.LOG_TAG, "User comment not added: ", e);
        }
        ACRA.log.v(ACRA.LOG_TAG, "About to start SenderWorker from CrashReportDialog");
        ACRA.getErrorReporter().startSendingReports(false, true);
        int toastId = ACRA.getConfig().resDialogOkToast();
        if (toastId != 0) {
            ToastSender.sendToast(this.getApplicationContext(), toastId, 1);
        }
    }
}

