/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

import org.simpleframework.xml.stream.EventAttribute;
import org.simpleframework.xml.stream.EventElement;
import org.simpleframework.xml.stream.EventNode;
import org.simpleframework.xml.stream.EventReader;
import org.simpleframework.xml.stream.EventToken;
import org.xmlpull.v1.XmlPullParser;

class PullReader
implements EventReader {
    private XmlPullParser parser;
    private EventNode peek;

    public PullReader(XmlPullParser parser) {
        this.parser = parser;
    }

    @Override
    public EventNode peek() throws Exception {
        if (this.peek == null) {
            this.peek = this.next();
        }
        return this.peek;
    }

    @Override
    public EventNode next() throws Exception {
        EventNode next = this.peek;
        if (next == null) {
            next = this.read();
        } else {
            this.peek = null;
        }
        return next;
    }

    private EventNode read() throws Exception {
        int event = this.parser.next();
        if (event != 1) {
            if (event == 2) {
                return this.start();
            }
            if (event == 4) {
                return this.text();
            }
            if (event == 3) {
                return this.end();
            }
            return this.read();
        }
        return null;
    }

    private Text text() throws Exception {
        return new Text(this.parser);
    }

    private Start start() throws Exception {
        Start event = new Start(this.parser);
        if (event.isEmpty()) {
            return this.build(event);
        }
        return event;
    }

    private Start build(Start event) throws Exception {
        int count = this.parser.getAttributeCount();
        int i = 0;
        while (i < count) {
            Entry entry = this.attribute(i);
            if (!entry.isReserved()) {
                event.add(entry);
            }
            ++i;
        }
        return event;
    }

    private Entry attribute(int index) throws Exception {
        return new Entry(this.parser, index);
    }

    private End end() throws Exception {
        return new End();
    }

    private static class End
    extends EventToken {
        private End() {
        }

        @Override
        public boolean isEnd() {
            return true;
        }
    }

    private static class Entry
    extends EventAttribute {
        private final XmlPullParser source;
        private final String reference;
        private final String prefix;
        private final String name;
        private final String value;

        public Entry(XmlPullParser source, int index) {
            this.reference = source.getAttributeNamespace(index);
            this.prefix = source.getAttributePrefix(index);
            this.value = source.getAttributeValue(index);
            this.name = source.getAttributeName(index);
            this.source = source;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isReserved() {
            return false;
        }

        @Override
        public String getReference() {
            return this.reference;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public Object getSource() {
            return this.source;
        }
    }

    private static class Start
    extends EventElement {
        private final XmlPullParser source;
        private final String reference;
        private final String prefix;
        private final String name;
        private final int line;

        public Start(XmlPullParser source) {
            this.reference = source.getNamespace();
            this.line = source.getLineNumber();
            this.prefix = source.getPrefix();
            this.name = source.getName();
            this.source = source;
        }

        @Override
        public int getLine() {
            return this.line;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getReference() {
            return this.reference;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public Object getSource() {
            return this.source;
        }
    }

    private static class Text
    extends EventToken {
        private final XmlPullParser source;
        private final String text;

        public Text(XmlPullParser source) {
            this.text = source.getText();
            this.source = source;
        }

        @Override
        public boolean isText() {
            return true;
        }

        @Override
        public String getValue() {
            return this.text;
        }

        @Override
        public Object getSource() {
            return this.source;
        }
    }
}

