/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.text.format.Time;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.collector.Compatibility;
import org.acra.collector.ConfigurationCollector;
import org.acra.collector.CrashReportData;
import org.acra.collector.DeviceFeaturesCollector;
import org.acra.collector.DisplayManagerCollector;
import org.acra.collector.DropBoxCollector;
import org.acra.collector.DumpSysCollector;
import org.acra.collector.LogCatCollector;
import org.acra.collector.LogFileCollector;
import org.acra.collector.MediaCodecListCollector;
import org.acra.collector.ReflectionCollector;
import org.acra.collector.SettingsCollector;
import org.acra.collector.SharedPreferencesCollector;
import org.acra.collector.ThreadCollector;
import org.acra.util.Installation;
import org.acra.util.PackageManagerWrapper;
import org.acra.util.ReportUtils;

public final class CrashReportDataFactory {
    private final Context context;
    private final SharedPreferences prefs;
    private final Map<String, String> customParameters = new LinkedHashMap<String, String>();
    private final Time appStartDate;
    private final String initialConfiguration;

    public CrashReportDataFactory(Context context, SharedPreferences prefs, Time appStartDate, String initialConfiguration) {
        this.context = context;
        this.prefs = prefs;
        this.appStartDate = appStartDate;
        this.initialConfiguration = initialConfiguration;
    }

    public String putCustomData(String key, String value) {
        return this.customParameters.put(key, value);
    }

    public String removeCustomData(String key) {
        return this.customParameters.remove(key);
    }

    public void clearCustomData() {
        this.customParameters.clear();
    }

    public String getCustomData(String key) {
        return this.customParameters.get(key);
    }

    public CrashReportData createCrashData(String msg, Throwable th, Map<String, String> customData, boolean isSilentReport, Thread brokenThread) {
        CrashReportData crashReportData = new CrashReportData();
        try {
            boolean hasReadLogsPermission;
            String deviceId;
            PackageManagerWrapper pm;
            PackageInfo pi;
            List<ReportField> crashReportFields = ACRA.getConfig().getReportFields();
            crashReportData.put(ReportField.STACK_TRACE, this.getStackTrace(msg, th));
            crashReportData.put(ReportField.USER_APP_START_DATE, ReportUtils.getTimeString(this.appStartDate));
            if (isSilentReport) {
                crashReportData.put(ReportField.IS_SILENT, "true");
            }
            if (crashReportFields.contains((Object)ReportField.STACK_TRACE_HASH)) {
                crashReportData.put(ReportField.STACK_TRACE_HASH, this.getStackTraceHash(th));
            }
            if (crashReportFields.contains((Object)ReportField.REPORT_ID)) {
                crashReportData.put(ReportField.REPORT_ID, UUID.randomUUID().toString());
            }
            if (crashReportFields.contains((Object)ReportField.INSTALLATION_ID)) {
                crashReportData.put(ReportField.INSTALLATION_ID, Installation.id(this.context));
            }
            if (crashReportFields.contains((Object)ReportField.INITIAL_CONFIGURATION)) {
                crashReportData.put(ReportField.INITIAL_CONFIGURATION, this.initialConfiguration);
            }
            if (crashReportFields.contains((Object)ReportField.CRASH_CONFIGURATION)) {
                crashReportData.put(ReportField.CRASH_CONFIGURATION, ConfigurationCollector.collectConfiguration(this.context));
            }
            if (!(th instanceof OutOfMemoryError) && crashReportFields.contains((Object)ReportField.DUMPSYS_MEMINFO)) {
                crashReportData.put(ReportField.DUMPSYS_MEMINFO, DumpSysCollector.collectMemInfo());
            }
            if (crashReportFields.contains((Object)ReportField.PACKAGE_NAME)) {
                crashReportData.put(ReportField.PACKAGE_NAME, this.context.getPackageName());
            }
            if (crashReportFields.contains((Object)ReportField.BUILD)) {
                crashReportData.put(ReportField.BUILD, String.valueOf(ReflectionCollector.collectConstants(Build.class)) + ReflectionCollector.collectConstants(Build.VERSION.class, "VERSION"));
            }
            if (crashReportFields.contains((Object)ReportField.PHONE_MODEL)) {
                crashReportData.put(ReportField.PHONE_MODEL, Build.MODEL);
            }
            if (crashReportFields.contains((Object)ReportField.ANDROID_VERSION)) {
                crashReportData.put(ReportField.ANDROID_VERSION, Build.VERSION.RELEASE);
            }
            if (crashReportFields.contains((Object)ReportField.BRAND)) {
                crashReportData.put(ReportField.BRAND, Build.BRAND);
            }
            if (crashReportFields.contains((Object)ReportField.PRODUCT)) {
                crashReportData.put(ReportField.PRODUCT, Build.PRODUCT);
            }
            if (crashReportFields.contains((Object)ReportField.TOTAL_MEM_SIZE)) {
                crashReportData.put(ReportField.TOTAL_MEM_SIZE, Long.toString(ReportUtils.getTotalInternalMemorySize()));
            }
            if (crashReportFields.contains((Object)ReportField.AVAILABLE_MEM_SIZE)) {
                crashReportData.put(ReportField.AVAILABLE_MEM_SIZE, Long.toString(ReportUtils.getAvailableInternalMemorySize()));
            }
            if (crashReportFields.contains((Object)ReportField.FILE_PATH)) {
                crashReportData.put(ReportField.FILE_PATH, ReportUtils.getApplicationFilePath(this.context));
            }
            if (crashReportFields.contains((Object)ReportField.DISPLAY)) {
                crashReportData.put(ReportField.DISPLAY, DisplayManagerCollector.collectDisplays(this.context));
            }
            if (crashReportFields.contains((Object)ReportField.USER_CRASH_DATE)) {
                Time curDate = new Time();
                curDate.setToNow();
                crashReportData.put(ReportField.USER_CRASH_DATE, ReportUtils.getTimeString(curDate));
            }
            if (crashReportFields.contains((Object)ReportField.CUSTOM_DATA)) {
                crashReportData.put(ReportField.CUSTOM_DATA, this.createCustomInfoString(customData));
            }
            if (crashReportFields.contains((Object)ReportField.BUILD_CONFIG)) {
                try {
                    Class<?> buildConfigClass = this.getBuildConfigClass();
                    crashReportData.put(ReportField.BUILD_CONFIG, ReflectionCollector.collectConstants(buildConfigClass));
                }
                catch (ClassNotFoundException buildConfigClass) {
                    // empty catch block
                }
            }
            if (crashReportFields.contains((Object)ReportField.USER_EMAIL)) {
                crashReportData.put(ReportField.USER_EMAIL, this.prefs.getString("acra.user.email", "N/A"));
            }
            if (crashReportFields.contains((Object)ReportField.DEVICE_FEATURES)) {
                crashReportData.put(ReportField.DEVICE_FEATURES, DeviceFeaturesCollector.getFeatures(this.context));
            }
            if (crashReportFields.contains((Object)ReportField.ENVIRONMENT)) {
                crashReportData.put(ReportField.ENVIRONMENT, ReflectionCollector.collectStaticGettersResults(Environment.class));
            }
            if (crashReportFields.contains((Object)ReportField.SETTINGS_SYSTEM)) {
                crashReportData.put(ReportField.SETTINGS_SYSTEM, SettingsCollector.collectSystemSettings(this.context));
            }
            if (crashReportFields.contains((Object)ReportField.SETTINGS_SECURE)) {
                crashReportData.put(ReportField.SETTINGS_SECURE, SettingsCollector.collectSecureSettings(this.context));
            }
            if (crashReportFields.contains((Object)ReportField.SETTINGS_GLOBAL)) {
                crashReportData.put(ReportField.SETTINGS_GLOBAL, SettingsCollector.collectGlobalSettings(this.context));
            }
            if (crashReportFields.contains((Object)ReportField.SHARED_PREFERENCES)) {
                crashReportData.put(ReportField.SHARED_PREFERENCES, SharedPreferencesCollector.collect(this.context));
            }
            if ((pi = (pm = new PackageManagerWrapper(this.context)).getPackageInfo()) != null) {
                if (crashReportFields.contains((Object)ReportField.APP_VERSION_CODE)) {
                    crashReportData.put(ReportField.APP_VERSION_CODE, Integer.toString(pi.versionCode));
                }
                if (crashReportFields.contains((Object)ReportField.APP_VERSION_NAME)) {
                    crashReportData.put(ReportField.APP_VERSION_NAME, pi.versionName != null ? pi.versionName : "not set");
                }
            } else {
                crashReportData.put(ReportField.APP_VERSION_NAME, "Package info unavailable");
            }
            if (crashReportFields.contains((Object)ReportField.DEVICE_ID) && this.prefs.getBoolean("acra.deviceid.enable", true) && pm.hasPermission("android.permission.READ_PHONE_STATE") && (deviceId = ReportUtils.getDeviceId(this.context)) != null) {
                crashReportData.put(ReportField.DEVICE_ID, deviceId);
            }
            boolean bl = hasReadLogsPermission = pm.hasPermission("android.permission.READ_LOGS") || Compatibility.getAPILevel() >= 16;
            if (this.prefs.getBoolean("acra.syslog.enable", true) && hasReadLogsPermission) {
                ACRA.log.i(ACRA.LOG_TAG, "READ_LOGS granted! ACRA can include LogCat and DropBox data.");
                if (crashReportFields.contains((Object)ReportField.LOGCAT)) {
                    crashReportData.put(ReportField.LOGCAT, LogCatCollector.collectLogCat(null));
                }
                if (crashReportFields.contains((Object)ReportField.EVENTSLOG)) {
                    crashReportData.put(ReportField.EVENTSLOG, LogCatCollector.collectLogCat("events"));
                }
                if (crashReportFields.contains((Object)ReportField.RADIOLOG)) {
                    crashReportData.put(ReportField.RADIOLOG, LogCatCollector.collectLogCat("radio"));
                }
                if (crashReportFields.contains((Object)ReportField.DROPBOX)) {
                    crashReportData.put(ReportField.DROPBOX, DropBoxCollector.read(this.context, ACRA.getConfig().additionalDropBoxTags()));
                }
            } else {
                ACRA.log.i(ACRA.LOG_TAG, "READ_LOGS not allowed. ACRA will not include LogCat and DropBox data.");
            }
            if (crashReportFields.contains((Object)ReportField.APPLICATION_LOG)) {
                try {
                    String logFile = LogFileCollector.collectLogFile(this.context, ACRA.getConfig().applicationLogFile(), ACRA.getConfig().applicationLogFileLines());
                    crashReportData.put(ReportField.APPLICATION_LOG, logFile);
                }
                catch (IOException e) {
                    ACRA.log.e(ACRA.LOG_TAG, "Error while reading application log file " + ACRA.getConfig().applicationLogFile(), e);
                }
            }
            if (crashReportFields.contains((Object)ReportField.MEDIA_CODEC_LIST)) {
                crashReportData.put(ReportField.MEDIA_CODEC_LIST, MediaCodecListCollector.collecMediaCodecList());
            }
            if (crashReportFields.contains((Object)ReportField.THREAD_DETAILS)) {
                crashReportData.put(ReportField.THREAD_DETAILS, ThreadCollector.collect(brokenThread));
            }
            if (crashReportFields.contains((Object)ReportField.USER_IP)) {
                crashReportData.put(ReportField.USER_IP, ReportUtils.getLocalIpAddress());
            }
        }
        catch (RuntimeException e) {
            ACRA.log.e(ACRA.LOG_TAG, "Error while retrieving crash data", e);
        }
        return crashReportData;
    }

    private String createCustomInfoString(Map<String, String> reportCustomData) {
        Map<String, String> params = this.customParameters;
        if (reportCustomData != null) {
            params = new HashMap<String, String>(params);
            params.putAll(reportCustomData);
        }
        StringBuilder customInfo = new StringBuilder();
        for (String currentKey : params.keySet()) {
            String currentVal = params.get(currentKey);
            customInfo.append(currentKey);
            customInfo.append(" = ");
            if (currentVal != null) {
                currentVal = currentVal.replaceAll("\n", "\\\\n");
            }
            customInfo.append(currentVal);
            customInfo.append("\n");
        }
        return customInfo.toString();
    }

    private String getStackTrace(String msg, Throwable th) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        if (msg != null && !TextUtils.isEmpty((CharSequence)msg)) {
            printWriter.println(msg);
        }
        Throwable cause = th;
        while (cause != null) {
            cause.printStackTrace(printWriter);
            cause = cause.getCause();
        }
        String stacktraceAsString = ((Object)result).toString();
        printWriter.close();
        return stacktraceAsString;
    }

    private String getStackTraceHash(Throwable th) {
        StringBuilder res = new StringBuilder();
        Throwable cause = th;
        while (cause != null) {
            StackTraceElement[] stackTraceElements;
            StackTraceElement[] stackTraceElementArray = stackTraceElements = cause.getStackTrace();
            int n = stackTraceElements.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement e = stackTraceElementArray[n2];
                res.append(e.getClassName());
                res.append(e.getMethodName());
                ++n2;
            }
            cause = cause.getCause();
        }
        return Integer.toHexString(res.toString().hashCode());
    }

    private Class<?> getBuildConfigClass() throws ClassNotFoundException {
        Class configuredBuildConfig = ACRA.getConfig().buildConfigClass();
        if (configuredBuildConfig != null && !configuredBuildConfig.equals(Object.class)) {
            return configuredBuildConfig;
        }
        String className = String.valueOf(this.context.getClass().getPackage().getName()) + ".BuildConfig";
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            ACRA.log.e(ACRA.LOG_TAG, "Not adding buildConfig to log. Class Not found : " + className + ". Please configure 'buildConfigClass' in your ACRA config");
            throw e;
        }
    }
}

