/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import java.util.Map;
import java.util.TreeMap;
import org.acra.ACRA;

final class SharedPreferencesCollector {
    SharedPreferencesCollector() {
    }

    public static String collect(Context context) {
        StringBuilder result = new StringBuilder();
        TreeMap<String, SharedPreferences> sharedPrefs = new TreeMap<String, SharedPreferences>();
        sharedPrefs.put("default", PreferenceManager.getDefaultSharedPreferences((Context)context));
        String[] sharedPrefIds = ACRA.getConfig().additionalSharedPreferences();
        if (sharedPrefIds != null) {
            String[] stringArray = sharedPrefIds;
            int n = sharedPrefIds.length;
            int n2 = 0;
            while (n2 < n) {
                String sharedPrefId = stringArray[n2];
                sharedPrefs.put(sharedPrefId, context.getSharedPreferences(sharedPrefId, 0));
                ++n2;
            }
        }
        for (Map.Entry entry : sharedPrefs.entrySet()) {
            String sharedPrefId = (String)entry.getKey();
            SharedPreferences prefs = (SharedPreferences)entry.getValue();
            Map prefEntries = prefs.getAll();
            if (prefEntries.isEmpty()) {
                result.append(sharedPrefId).append('=').append("empty\n");
                continue;
            }
            for (String key : prefEntries.keySet()) {
                if (SharedPreferencesCollector.filteredKey(key)) {
                    ACRA.log.d(ACRA.LOG_TAG, "Filtered out sharedPreference=" + sharedPrefId + "  key=" + key + " due to filtering rule");
                    continue;
                }
                Object prefValue = prefEntries.get(key);
                result.append(sharedPrefId).append('.').append(key).append('=');
                result.append(prefValue == null ? "null" : prefValue.toString());
                result.append("\n");
            }
            result.append('\n');
        }
        return result.toString();
    }

    private static boolean filteredKey(String key) {
        String[] stringArray = ACRA.getConfig().excludeMatchingSharedPreferencesKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String regex = stringArray[n2];
            if (key.matches(regex)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

