/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform;

import java.util.regex.Pattern;
import org.simpleframework.xml.transform.Transform;

class StringArrayTransform
implements Transform<String[]> {
    private final Pattern pattern;
    private final String token;

    public StringArrayTransform() {
        this(",");
    }

    public StringArrayTransform(String token) {
        this.pattern = Pattern.compile(token);
        this.token = token;
    }

    @Override
    public String[] read(String value) {
        return this.read(value, this.token);
    }

    private String[] read(String value, String token) {
        String[] list = this.pattern.split(value);
        int i = 0;
        while (i < list.length) {
            String text = list[i];
            if (text != null) {
                list[i] = text.trim();
            }
            ++i;
        }
        return list;
    }

    @Override
    public String write(String[] list) {
        return this.write(list, this.token);
    }

    private String write(String[] list, String token) {
        StringBuilder text = new StringBuilder();
        int i = 0;
        while (i < list.length) {
            String item = list[i];
            if (item != null) {
                if (text.length() > 0) {
                    text.append(token);
                    text.append(' ');
                }
                text.append(item);
            }
            ++i;
        }
        return text.toString();
    }
}

