/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import java.lang.annotation.Annotation;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.acra.ACRA;
import org.acra.ACRAConfigurationException;
import org.acra.ACRAConstants;
import org.acra.BaseCrashReportDialog;
import org.acra.CrashReportDialog;
import org.acra.ReportField;
import org.acra.ReportingInteractionMode;
import org.acra.annotation.ReportsCrashes;
import org.acra.sender.HttpSender;
import org.acra.util.DefaultHttpsSocketFactoryFactory;
import org.acra.util.HttpsSocketFactoryFactory;
import org.acra.util.ReflectionException;
import org.acra.util.ReflectionHelper;

public class ACRAConfiguration
implements ReportsCrashes {
    private final ReflectionHelper reflectionHelper = new ReflectionHelper();
    private String[] mAdditionalDropboxTags = null;
    private String[] mAdditionalSharedPreferences = null;
    private Integer mConnectionTimeout = null;
    private ReportField[] mCustomReportContent = null;
    private Boolean mDeleteUnapprovedReportsOnApplicationStart = null;
    private Boolean mDeleteOldUnsentReportsOnApplicationStart = null;
    private Integer mDropboxCollectionMinutes = null;
    private Boolean mForceCloseDialogAfterToast = null;
    private String mFormUri = null;
    private String mFormUriBasicAuthLogin = null;
    private String mFormUriBasicAuthPassword = null;
    private Boolean mIncludeDropboxSystemTags = null;
    private String[] mLogcatArguments = null;
    private String mMailTo = null;
    private Integer mMaxNumberOfRequestRetries = null;
    private ReportingInteractionMode mMode = null;
    private ReportsCrashes mReportsCrashes = null;
    private Class<? extends BaseCrashReportDialog> mReportDialogClass = null;
    private Integer mResDialogPositiveButtonText = null;
    private Integer mResDialogNegativeButtonText = null;
    private Integer mResDialogCommentPrompt = null;
    private Integer mResDialogEmailPrompt = null;
    private Integer mResDialogIcon = null;
    private Integer mResDialogOkToast = null;
    private Integer mResDialogText = null;
    private Integer mResDialogTitle = null;
    private Integer mResNotifIcon = null;
    private Integer mResNotifText = null;
    private Integer mResNotifTickerText = null;
    private Integer mResNotifTitle = null;
    private Integer mResToastText = null;
    private Integer mSharedPreferenceMode = null;
    private String mSharedPreferenceName = null;
    private Integer mSocketTimeout = null;
    private Boolean mLogcatFilterByPid = null;
    private Boolean mSendReportsInDevMode = null;
    private Boolean mSendReportsAtShutdown = null;
    private String[] mExcludeMatchingSharedPreferencesKeys = null;
    private String[] mExcludeMatchingSettingsKeys = null;
    private Class mBuildConfigClass;
    private String mApplicationLogFile = null;
    private Integer mApplicationLogFileLines = null;
    private Boolean mDisableSSLCertValidation = null;
    private String mHttpsSocketFactoryFactoryClass = null;
    private HttpsSocketFactoryFactory mHttpsSocketFactoryFactory;
    private HttpSender.Method mHttpMethod = null;
    private HttpSender.Type mReportType = null;
    private Map<String, String> mHttpHeaders;
    private KeyStore mKeyStore;

    public ACRAConfiguration setHttpHeaders(Map<String, String> headers) {
        this.mHttpHeaders = headers;
        return this;
    }

    public Map<String, String> getHttpHeaders() {
        return this.mHttpHeaders;
    }

    public List<ReportField> getReportFields() {
        ReportField[] fieldsList;
        ReportField[] customReportFields = this.customReportContent();
        if (customReportFields.length != 0) {
            ACRA.log.d(ACRA.LOG_TAG, "Using custom Report Fields");
            fieldsList = customReportFields;
        } else if (this.mailTo() == null || "".equals(this.mailTo())) {
            ACRA.log.d(ACRA.LOG_TAG, "Using default Report Fields");
            fieldsList = ACRAConstants.DEFAULT_REPORT_FIELDS;
        } else {
            ACRA.log.d(ACRA.LOG_TAG, "Using default Mail Report Fields");
            fieldsList = ACRAConstants.DEFAULT_MAIL_REPORT_FIELDS;
        }
        return Arrays.asList(fieldsList);
    }

    public ACRAConfiguration setAdditionalDropboxTags(String[] additionalDropboxTags) {
        this.mAdditionalDropboxTags = additionalDropboxTags;
        return this;
    }

    public ACRAConfiguration setAdditionalSharedPreferences(String[] additionalSharedPreferences) {
        this.mAdditionalSharedPreferences = additionalSharedPreferences;
        return this;
    }

    public ACRAConfiguration setConnectionTimeout(Integer connectionTimeout) {
        this.mConnectionTimeout = connectionTimeout;
        return this;
    }

    public ACRAConfiguration setCustomReportContent(ReportField[] customReportContent) {
        this.mCustomReportContent = customReportContent;
        return this;
    }

    public ACRAConfiguration setDeleteUnapprovedReportsOnApplicationStart(Boolean deleteUnapprovedReportsOnApplicationStart) {
        this.mDeleteUnapprovedReportsOnApplicationStart = deleteUnapprovedReportsOnApplicationStart;
        return this;
    }

    public ACRAConfiguration setDeleteOldUnsentReportsOnApplicationStart(Boolean deleteOldUnsentReportsOnApplicationStart) {
        this.mDeleteOldUnsentReportsOnApplicationStart = deleteOldUnsentReportsOnApplicationStart;
        return this;
    }

    public ACRAConfiguration setDropboxCollectionMinutes(Integer dropboxCollectionMinutes) {
        this.mDropboxCollectionMinutes = dropboxCollectionMinutes;
        return this;
    }

    public ACRAConfiguration setForceCloseDialogAfterToast(Boolean forceCloseDialogAfterToast) {
        this.mForceCloseDialogAfterToast = forceCloseDialogAfterToast;
        return this;
    }

    public ACRAConfiguration setFormUri(String formUri) {
        this.mFormUri = formUri;
        return this;
    }

    public ACRAConfiguration setFormUriBasicAuthLogin(String formUriBasicAuthLogin) {
        this.mFormUriBasicAuthLogin = formUriBasicAuthLogin;
        return this;
    }

    public ACRAConfiguration setFormUriBasicAuthPassword(String formUriBasicAuthPassword) {
        this.mFormUriBasicAuthPassword = formUriBasicAuthPassword;
        return this;
    }

    public ACRAConfiguration setIncludeDropboxSystemTags(Boolean includeDropboxSystemTags) {
        this.mIncludeDropboxSystemTags = includeDropboxSystemTags;
        return this;
    }

    public ACRAConfiguration setLogcatArguments(String[] logcatArguments) {
        this.mLogcatArguments = logcatArguments;
        return this;
    }

    public ACRAConfiguration setMailTo(String mailTo) {
        this.mMailTo = mailTo;
        return this;
    }

    public ACRAConfiguration setMaxNumberOfRequestRetries(Integer maxNumberOfRequestRetries) {
        this.mMaxNumberOfRequestRetries = maxNumberOfRequestRetries;
        return this;
    }

    public ACRAConfiguration setMode(ReportingInteractionMode mode) throws ACRAConfigurationException {
        this.mMode = mode;
        ACRA.checkCrashResources(this);
        return this;
    }

    public ACRAConfiguration setResDialogPositiveButtonText(int resId) {
        this.mResDialogPositiveButtonText = resId;
        return this;
    }

    public ACRAConfiguration setResDialogNegativeButtonText(int resId) {
        this.mResDialogNegativeButtonText = resId;
        return this;
    }

    public ACRAConfiguration setReportDialogClass(Class<? extends BaseCrashReportDialog> reportDialogClass) {
        this.mReportDialogClass = reportDialogClass;
        return this;
    }

    public ACRAConfiguration setResDialogCommentPrompt(int resId) {
        this.mResDialogCommentPrompt = resId;
        return this;
    }

    public ACRAConfiguration setResDialogEmailPrompt(int resId) {
        this.mResDialogEmailPrompt = resId;
        return this;
    }

    public ACRAConfiguration setResDialogIcon(int resId) {
        this.mResDialogIcon = resId;
        return this;
    }

    public ACRAConfiguration setResDialogOkToast(int resId) {
        this.mResDialogOkToast = resId;
        return this;
    }

    public ACRAConfiguration setResDialogText(int resId) {
        this.mResDialogText = resId;
        return this;
    }

    public ACRAConfiguration setResDialogTitle(int resId) {
        this.mResDialogTitle = resId;
        return this;
    }

    public ACRAConfiguration setResNotifIcon(int resId) {
        this.mResNotifIcon = resId;
        return this;
    }

    public ACRAConfiguration setResNotifText(int resId) {
        this.mResNotifText = resId;
        return this;
    }

    public ACRAConfiguration setResNotifTickerText(int resId) {
        this.mResNotifTickerText = resId;
        return this;
    }

    public ACRAConfiguration setResNotifTitle(int resId) {
        this.mResNotifTitle = resId;
        return this;
    }

    public ACRAConfiguration setResToastText(int resId) {
        this.mResToastText = resId;
        return this;
    }

    public ACRAConfiguration setSharedPreferenceMode(Integer sharedPreferenceMode) {
        this.mSharedPreferenceMode = sharedPreferenceMode;
        return this;
    }

    public ACRAConfiguration setSharedPreferenceName(String sharedPreferenceName) {
        this.mSharedPreferenceName = sharedPreferenceName;
        return this;
    }

    public ACRAConfiguration setSocketTimeout(Integer socketTimeout) {
        this.mSocketTimeout = socketTimeout;
        return this;
    }

    public ACRAConfiguration setLogcatFilterByPid(Boolean filterByPid) {
        this.mLogcatFilterByPid = filterByPid;
        return this;
    }

    public ACRAConfiguration setSendReportsInDevMode(Boolean sendReportsInDevMode) {
        this.mSendReportsInDevMode = sendReportsInDevMode;
        return this;
    }

    public ACRAConfiguration setSendReportsAtShutdown(Boolean sendReportsAtShutdown) {
        this.mSendReportsAtShutdown = sendReportsAtShutdown;
        return this;
    }

    public ACRAConfiguration setExcludeMatchingSharedPreferencesKeys(String[] excludeMatchingSharedPreferencesKeys) {
        this.mExcludeMatchingSharedPreferencesKeys = excludeMatchingSharedPreferencesKeys;
        return this;
    }

    public ACRAConfiguration setExcludeMatchingSettingsKeys(String[] excludeMatchingSettingsKeys) {
        this.mExcludeMatchingSettingsKeys = excludeMatchingSettingsKeys;
        return this;
    }

    public ACRAConfiguration setBuildConfigClass(Class buildConfigClass) {
        this.mBuildConfigClass = buildConfigClass;
        return this;
    }

    public ACRAConfiguration setApplicationLogFile(String applicationLogFile) {
        this.mApplicationLogFile = applicationLogFile;
        return this;
    }

    public ACRAConfiguration setApplicationLogFileLines(int applicationLogFileLines) {
        this.mApplicationLogFileLines = applicationLogFileLines;
        return this;
    }

    public ACRAConfiguration setDisableSSLCertValidation(boolean disableSSLCertValidation) {
        this.mDisableSSLCertValidation = disableSSLCertValidation;
        return this;
    }

    public ACRAConfiguration setHttpMethod(HttpSender.Method httpMethod) {
        this.mHttpMethod = httpMethod;
        return this;
    }

    public ACRAConfiguration setReportType(HttpSender.Type type) {
        this.mReportType = type;
        return this;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.mKeyStore = keyStore;
    }

    public ACRAConfiguration(ReportsCrashes defaults) {
        this.mReportsCrashes = defaults;
    }

    public ACRAConfiguration() {
        this(null);
    }

    @Override
    public String[] additionalDropBoxTags() {
        if (this.mAdditionalDropboxTags != null) {
            return this.mAdditionalDropboxTags;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.additionalDropBoxTags();
        }
        return new String[0];
    }

    @Override
    public String[] additionalSharedPreferences() {
        if (this.mAdditionalSharedPreferences != null) {
            return this.mAdditionalSharedPreferences;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.additionalSharedPreferences();
        }
        return new String[0];
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.mReportsCrashes.annotationType();
    }

    @Override
    public int connectionTimeout() {
        if (this.mConnectionTimeout != null) {
            return this.mConnectionTimeout;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.connectionTimeout();
        }
        return 3000;
    }

    @Override
    public ReportField[] customReportContent() {
        if (this.mCustomReportContent != null) {
            return this.mCustomReportContent;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.customReportContent();
        }
        return new ReportField[0];
    }

    @Override
    public boolean deleteUnapprovedReportsOnApplicationStart() {
        if (this.mDeleteUnapprovedReportsOnApplicationStart != null) {
            return this.mDeleteUnapprovedReportsOnApplicationStart;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.deleteUnapprovedReportsOnApplicationStart();
        }
        return true;
    }

    @Override
    public boolean deleteOldUnsentReportsOnApplicationStart() {
        if (this.mDeleteOldUnsentReportsOnApplicationStart != null) {
            return this.mDeleteOldUnsentReportsOnApplicationStart;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.deleteOldUnsentReportsOnApplicationStart();
        }
        return true;
    }

    @Override
    public int dropboxCollectionMinutes() {
        if (this.mDropboxCollectionMinutes != null) {
            return this.mDropboxCollectionMinutes;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.dropboxCollectionMinutes();
        }
        return 5;
    }

    @Override
    public boolean forceCloseDialogAfterToast() {
        if (this.mForceCloseDialogAfterToast != null) {
            return this.mForceCloseDialogAfterToast;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.forceCloseDialogAfterToast();
        }
        return false;
    }

    @Override
    public String formUri() {
        if (this.mFormUri != null) {
            return this.mFormUri;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.formUri();
        }
        return "";
    }

    @Override
    public String formUriBasicAuthLogin() {
        if (this.mFormUriBasicAuthLogin != null) {
            return this.mFormUriBasicAuthLogin;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.formUriBasicAuthLogin();
        }
        return "ACRA-NULL-STRING";
    }

    @Override
    public String formUriBasicAuthPassword() {
        if (this.mFormUriBasicAuthPassword != null) {
            return this.mFormUriBasicAuthPassword;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.formUriBasicAuthPassword();
        }
        return "ACRA-NULL-STRING";
    }

    @Override
    public boolean includeDropBoxSystemTags() {
        if (this.mIncludeDropboxSystemTags != null) {
            return this.mIncludeDropboxSystemTags;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.includeDropBoxSystemTags();
        }
        return false;
    }

    @Override
    public String[] logcatArguments() {
        if (this.mLogcatArguments != null) {
            return this.mLogcatArguments;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.logcatArguments();
        }
        return new String[]{"-t", Integer.toString(100), "-v", "time"};
    }

    @Override
    public String mailTo() {
        if (this.mMailTo != null) {
            return this.mMailTo;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.mailTo();
        }
        return "";
    }

    @Override
    public int maxNumberOfRequestRetries() {
        if (this.mMaxNumberOfRequestRetries != null) {
            return this.mMaxNumberOfRequestRetries;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.maxNumberOfRequestRetries();
        }
        return 3;
    }

    @Override
    public ReportingInteractionMode mode() {
        if (this.mMode != null) {
            return this.mMode;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.mode();
        }
        return ReportingInteractionMode.SILENT;
    }

    @Override
    public int resDialogPositiveButtonText() {
        if (this.mResDialogPositiveButtonText != null) {
            return this.mResDialogPositiveButtonText;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.resDialogPositiveButtonText();
        }
        return 0;
    }

    @Override
    public int resDialogNegativeButtonText() {
        if (this.mResDialogNegativeButtonText != null) {
            return this.mResDialogNegativeButtonText;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.resDialogNegativeButtonText();
        }
        return 0;
    }

    @Override
    public int resDialogCommentPrompt() {
        if (this.mResDialogCommentPrompt != null) {
            return this.mResDialogCommentPrompt;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.resDialogCommentPrompt();
        }
        return 0;
    }

    @Override
    public int resDialogEmailPrompt() {
        if (this.mResDialogEmailPrompt != null) {
            return this.mResDialogEmailPrompt;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.resDialogEmailPrompt();
        }
        return 0;
    }

    @Override
    public int resDialogIcon() {
        if (this.mResDialogIcon != null) {
            return this.mResDialogIcon;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.resDialogIcon();
        }
        return 17301543;
    }

    @Override
    public int resDialogOkToast() {
        if (this.mResDialogOkToast != null) {
            return this.mResDialogOkToast;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.resDialogOkToast();
        }
        return 0;
    }

    @Override
    public int resDialogText() {
        if (this.mResDialogText != null) {
            return this.mResDialogText;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.resDialogText();
        }
        return 0;
    }

    @Override
    public int resDialogTitle() {
        if (this.mResDialogTitle != null) {
            return this.mResDialogTitle;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.resDialogTitle();
        }
        return 0;
    }

    @Override
    public int resNotifIcon() {
        if (this.mResNotifIcon != null) {
            return this.mResNotifIcon;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.resNotifIcon();
        }
        return 17301624;
    }

    @Override
    public int resNotifText() {
        if (this.mResNotifText != null) {
            return this.mResNotifText;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.resNotifText();
        }
        return 0;
    }

    @Override
    public int resNotifTickerText() {
        if (this.mResNotifTickerText != null) {
            return this.mResNotifTickerText;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.resNotifTickerText();
        }
        return 0;
    }

    @Override
    public int resNotifTitle() {
        if (this.mResNotifTitle != null) {
            return this.mResNotifTitle;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.resNotifTitle();
        }
        return 0;
    }

    @Override
    public int resToastText() {
        if (this.mResToastText != null) {
            return this.mResToastText;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.resToastText();
        }
        return 0;
    }

    @Override
    public int sharedPreferencesMode() {
        if (this.mSharedPreferenceMode != null) {
            return this.mSharedPreferenceMode;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.sharedPreferencesMode();
        }
        return 0;
    }

    @Override
    public String sharedPreferencesName() {
        if (this.mSharedPreferenceName != null) {
            return this.mSharedPreferenceName;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.sharedPreferencesName();
        }
        return "";
    }

    @Override
    public int socketTimeout() {
        if (this.mSocketTimeout != null) {
            return this.mSocketTimeout;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.socketTimeout();
        }
        return 5000;
    }

    @Override
    public boolean logcatFilterByPid() {
        if (this.mLogcatFilterByPid != null) {
            return this.mLogcatFilterByPid;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.logcatFilterByPid();
        }
        return false;
    }

    @Override
    public boolean sendReportsInDevMode() {
        if (this.mSendReportsInDevMode != null) {
            return this.mSendReportsInDevMode;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.sendReportsInDevMode();
        }
        return true;
    }

    @Override
    public boolean sendReportsAtShutdown() {
        if (this.mSendReportsAtShutdown != null) {
            return this.mSendReportsAtShutdown;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.sendReportsAtShutdown();
        }
        return true;
    }

    @Override
    public String[] excludeMatchingSharedPreferencesKeys() {
        if (this.mExcludeMatchingSharedPreferencesKeys != null) {
            return this.mExcludeMatchingSharedPreferencesKeys;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.excludeMatchingSharedPreferencesKeys();
        }
        return new String[0];
    }

    @Override
    public String[] excludeMatchingSettingsKeys() {
        if (this.mExcludeMatchingSettingsKeys != null) {
            return this.mExcludeMatchingSettingsKeys;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.excludeMatchingSettingsKeys();
        }
        return new String[0];
    }

    @Override
    public Class buildConfigClass() {
        if (this.mBuildConfigClass != null) {
            return this.mBuildConfigClass;
        }
        if (this.mReportsCrashes != null && this.mReportsCrashes.buildConfigClass() != null) {
            return this.mReportsCrashes.buildConfigClass();
        }
        return null;
    }

    @Override
    public String applicationLogFile() {
        if (this.mApplicationLogFile != null) {
            return this.mApplicationLogFile;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.applicationLogFile();
        }
        return "";
    }

    @Override
    public int applicationLogFileLines() {
        if (this.mApplicationLogFileLines != null) {
            return this.mApplicationLogFileLines;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.applicationLogFileLines();
        }
        return 100;
    }

    @Override
    public boolean disableSSLCertValidation() {
        if (this.mDisableSSLCertValidation != null) {
            return this.mDisableSSLCertValidation;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.disableSSLCertValidation();
        }
        return false;
    }

    @Override
    public String httpsSocketFactoryFactoryClass() {
        if (this.mHttpsSocketFactoryFactoryClass != null) {
            return this.mHttpsSocketFactoryFactoryClass;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.httpsSocketFactoryFactoryClass();
        }
        return null;
    }

    @Override
    public Class<? extends BaseCrashReportDialog> reportDialogClass() {
        if (this.mReportDialogClass != null) {
            return this.mReportDialogClass;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.reportDialogClass();
        }
        return CrashReportDialog.class;
    }

    public void setHttpsSocketFactoryFactory(HttpsSocketFactoryFactory httpsSocketFactoryFactory) {
        this.mHttpsSocketFactoryFactory = httpsSocketFactoryFactory;
    }

    public HttpsSocketFactoryFactory getHttpSocketFactoryFactory() {
        if (this.mHttpsSocketFactoryFactory != null) {
            return this.mHttpsSocketFactoryFactory;
        }
        String httpsSocketFactoryFactoryClass = this.httpsSocketFactoryFactoryClass();
        if (httpsSocketFactoryFactoryClass != null) {
            try {
                Object object = this.reflectionHelper.create(this.mReportsCrashes.httpsSocketFactoryFactoryClass());
                if (object instanceof HttpsSocketFactoryFactory) {
                    this.mHttpsSocketFactoryFactory = (HttpsSocketFactoryFactory)object;
                } else {
                    ACRA.log.w(ACRA.LOG_TAG, "Using default httpsSocketFactoryFactory - not a HttpSocketFactoryFactory : " + httpsSocketFactoryFactoryClass);
                }
            }
            catch (ReflectionException e) {
                ACRA.log.w(ACRA.LOG_TAG, "Using default httpsSocketFactoryFactory - Could not construct : " + httpsSocketFactoryFactoryClass);
            }
        }
        if (this.mHttpsSocketFactoryFactoryClass == null) {
            this.mHttpsSocketFactoryFactory = DefaultHttpsSocketFactoryFactory.INSTANCE;
        }
        return this.mHttpsSocketFactoryFactory;
    }

    @Override
    public HttpSender.Method httpMethod() {
        if (this.mHttpMethod != null) {
            return this.mHttpMethod;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.httpMethod();
        }
        return HttpSender.Method.POST;
    }

    @Override
    public HttpSender.Type reportType() {
        if (this.mReportType != null) {
            return this.mReportType;
        }
        if (this.mReportsCrashes != null) {
            return this.mReportsCrashes.reportType();
        }
        return HttpSender.Type.FORM;
    }

    public KeyStore keyStore() {
        if (this.mKeyStore != null) {
            return this.mKeyStore;
        }
        return null;
    }

    public static boolean isNull(String aString) {
        return aString == null || "ACRA-NULL-STRING".equals(aString);
    }
}

