/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.Activity;
import android.app.Application;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.os.Bundle;
import android.os.Looper;
import android.os.Process;
import android.text.format.Time;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.acra.ACRA;
import org.acra.ACRAConfiguration;
import org.acra.ACRAConstants;
import org.acra.BaseCrashReportDialog;
import org.acra.CrashReportFileNameParser;
import org.acra.CrashReportFinder;
import org.acra.CrashReportPersister;
import org.acra.ExceptionHandlerInitializer;
import org.acra.ReportField;
import org.acra.ReportingInteractionMode;
import org.acra.SendWorker;
import org.acra.collector.Compatibility;
import org.acra.collector.ConfigurationCollector;
import org.acra.collector.CrashReportData;
import org.acra.collector.CrashReportDataFactory;
import org.acra.jraf.android.util.activitylifecyclecallbackscompat.ActivityLifecycleCallbacksCompat;
import org.acra.jraf.android.util.activitylifecyclecallbackscompat.ApplicationHelper;
import org.acra.sender.EmailIntentSender;
import org.acra.sender.HttpSender;
import org.acra.sender.ReportSender;
import org.acra.util.PackageManagerWrapper;
import org.acra.util.ToastSender;

public class ErrorReporter
implements Thread.UncaughtExceptionHandler {
    private boolean enabled = false;
    private final Application mContext;
    private final SharedPreferences prefs;
    private final List<ReportSender> mReportSenders = new ArrayList<ReportSender>();
    private final CrashReportDataFactory crashReportDataFactory;
    private final CrashReportFileNameParser fileNameParser = new CrashReportFileNameParser();
    private final Thread.UncaughtExceptionHandler mDfltExceptionHandler;
    private WeakReference<Activity> lastActivityCreated = new WeakReference<Object>(null);
    private boolean toastWaitEnded = true;
    private static final ExceptionHandlerInitializer NULL_EXCEPTION_HANDLER_INITIALIZER = new ExceptionHandlerInitializer(){

        @Override
        public void initializeExceptionHandler(ErrorReporter reporter) {
        }
    };
    private volatile ExceptionHandlerInitializer exceptionHandlerInitializer = NULL_EXCEPTION_HANDLER_INITIALIZER;
    private static int mNotificationCounter = 0;

    ErrorReporter(Application context, SharedPreferences prefs, boolean enabled) {
        this.mContext = context;
        this.prefs = prefs;
        this.enabled = enabled;
        String initialConfiguration = ACRA.getConfig().getReportFields().contains((Object)ReportField.INITIAL_CONFIGURATION) ? ConfigurationCollector.collectConfiguration((Context)this.mContext) : null;
        Time appStartDate = new Time();
        appStartDate.setToNow();
        if (Compatibility.getAPILevel() >= 14) {
            ApplicationHelper.registerActivityLifecycleCallbacks(context, new ActivityLifecycleCallbacksCompat(){

                @Override
                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                    if (!(activity instanceof BaseCrashReportDialog)) {
                        ErrorReporter.this.lastActivityCreated = new WeakReference<Activity>(activity);
                    }
                }

                @Override
                public void onActivityStarted(Activity activity) {
                }

                @Override
                public void onActivityResumed(Activity activity) {
                }

                @Override
                public void onActivityPaused(Activity activity) {
                }

                @Override
                public void onActivityStopped(Activity activity) {
                }

                @Override
                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                }

                @Override
                public void onActivityDestroyed(Activity activity) {
                }
            });
        }
        this.crashReportDataFactory = new CrashReportDataFactory((Context)this.mContext, prefs, appStartDate, initialConfiguration);
        this.mDfltExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Deprecated
    public static ErrorReporter getInstance() {
        return ACRA.getErrorReporter();
    }

    @Deprecated
    public void addCustomData(String key, String value) {
        this.crashReportDataFactory.putCustomData(key, value);
    }

    public String putCustomData(String key, String value) {
        return this.crashReportDataFactory.putCustomData(key, value);
    }

    public void setExceptionHandlerInitializer(ExceptionHandlerInitializer initializer) {
        this.exceptionHandlerInitializer = initializer != null ? initializer : NULL_EXCEPTION_HANDLER_INITIALIZER;
    }

    public String removeCustomData(String key) {
        return this.crashReportDataFactory.removeCustomData(key);
    }

    public void clearCustomData() {
        this.crashReportDataFactory.clearCustomData();
    }

    public String getCustomData(String key) {
        return this.crashReportDataFactory.getCustomData(key);
    }

    public void addReportSender(ReportSender sender) {
        this.mReportSenders.add(sender);
    }

    public void removeReportSender(ReportSender sender) {
        this.mReportSenders.remove(sender);
    }

    public void removeReportSenders(Class<?> senderClass) {
        if (ReportSender.class.isAssignableFrom(senderClass)) {
            for (ReportSender sender : this.mReportSenders) {
                if (!senderClass.isInstance(sender)) continue;
                this.mReportSenders.remove(sender);
            }
        }
    }

    public void removeAllReportSenders() {
        this.mReportSenders.clear();
    }

    public void setReportSender(ReportSender sender) {
        this.removeAllReportSenders();
        this.addReportSender(sender);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        block5: {
            try {
                if (!this.enabled) {
                    if (this.mDfltExceptionHandler != null) {
                        ACRA.log.e(ACRA.LOG_TAG, "ACRA is disabled for " + this.mContext.getPackageName() + " - forwarding uncaught Exception on to default ExceptionHandler");
                        this.mDfltExceptionHandler.uncaughtException(t, e);
                    } else {
                        ACRA.log.e(ACRA.LOG_TAG, "ACRA is disabled for " + this.mContext.getPackageName() + " - no default ExceptionHandler");
                        ACRA.log.e(ACRA.LOG_TAG, "ACRA caught a " + e.getClass().getSimpleName() + " for " + this.mContext.getPackageName(), e);
                    }
                    return;
                }
                ACRA.log.e(ACRA.LOG_TAG, "ACRA caught a " + e.getClass().getSimpleName() + " for " + this.mContext.getPackageName(), e);
                ACRA.log.d(ACRA.LOG_TAG, "Building report");
                this.reportBuilder().uncaughtExceptionThread(t).exception(e).endsApplication().send();
            }
            catch (Throwable fatality) {
                if (this.mDfltExceptionHandler == null) break block5;
                this.mDfltExceptionHandler.uncaughtException(t, e);
            }
        }
    }

    private void endApplication(Thread uncaughtExceptionThread, Throwable th) {
        boolean handlingUncaughtException;
        boolean letDefaultHandlerEndApplication = ACRA.getConfig().mode() == ReportingInteractionMode.SILENT || ACRA.getConfig().mode() == ReportingInteractionMode.TOAST && ACRA.getConfig().forceCloseDialogAfterToast();
        boolean bl = handlingUncaughtException = uncaughtExceptionThread != null;
        if (handlingUncaughtException && letDefaultHandlerEndApplication && this.mDfltExceptionHandler != null) {
            ACRA.log.d(ACRA.LOG_TAG, "Handing Exception on to default ExceptionHandler");
            this.mDfltExceptionHandler.uncaughtException(uncaughtExceptionThread, th);
        } else {
            ACRA.log.e(ACRA.LOG_TAG, String.valueOf(this.mContext.getPackageName()) + " fatal error : " + th.getMessage(), th);
            Activity lastActivity = (Activity)this.lastActivityCreated.get();
            if (lastActivity != null) {
                ACRA.log.i(ACRA.LOG_TAG, "Finishing the last Activity prior to killing the Process");
                lastActivity.finish();
                ACRA.log.i(ACRA.LOG_TAG, "Finished " + lastActivity.getClass());
                this.lastActivityCreated.clear();
            }
            Process.killProcess((int)Process.myPid());
            System.exit(10);
        }
    }

    public void handleSilentException(Throwable e) {
        if (this.enabled) {
            this.reportBuilder().exception(e).forceSilent().send();
            ACRA.log.d(ACRA.LOG_TAG, "ACRA sent Silent report.");
            return;
        }
        ACRA.log.d(ACRA.LOG_TAG, "ACRA is disabled. Silent report not sent.");
    }

    public void setEnabled(boolean enabled) {
        ACRA.log.i(ACRA.LOG_TAG, "ACRA is " + (enabled ? "enabled" : "disabled") + " for " + this.mContext.getPackageName());
        this.enabled = enabled;
    }

    SendWorker startSendingReports(boolean onlySendSilentReports, boolean approveReportsFirst) {
        SendWorker worker = new SendWorker((Context)this.mContext, this.mReportSenders, onlySendSilentReports, approveReportsFirst);
        worker.start();
        return worker;
    }

    void deletePendingReports() {
        this.deletePendingReports(true, true, 0);
    }

    public void checkReportsOnApplicationStart() {
        CrashReportFinder reportFinder;
        String[] filesList;
        ReportingInteractionMode reportingInteractionMode;
        if (ACRA.getConfig().deleteOldUnsentReportsOnApplicationStart()) {
            long lastVersionNr = this.prefs.getInt("acra.lastVersionNr", 0);
            PackageManagerWrapper packageManagerWrapper = new PackageManagerWrapper((Context)this.mContext);
            PackageInfo packageInfo = packageManagerWrapper.getPackageInfo();
            if (packageInfo != null) {
                boolean newVersion;
                boolean bl = newVersion = (long)packageInfo.versionCode > lastVersionNr;
                if (newVersion) {
                    this.deletePendingReports();
                }
                SharedPreferences.Editor prefsEditor = this.prefs.edit();
                prefsEditor.putInt("acra.lastVersionNr", packageInfo.versionCode);
                prefsEditor.commit();
            }
        }
        if (((reportingInteractionMode = ACRA.getConfig().mode()) == ReportingInteractionMode.NOTIFICATION || reportingInteractionMode == ReportingInteractionMode.DIALOG) && ACRA.getConfig().deleteUnapprovedReportsOnApplicationStart()) {
            this.deletePendingNonApprovedReports(true);
        }
        if ((filesList = (reportFinder = new CrashReportFinder((Context)this.mContext)).getCrashReportFiles()) != null && filesList.length > 0) {
            boolean onlySilentOrApprovedReports = this.containsOnlySilentOrApprovedReports(filesList);
            if (reportingInteractionMode == ReportingInteractionMode.SILENT || reportingInteractionMode == ReportingInteractionMode.TOAST || onlySilentOrApprovedReports && (reportingInteractionMode == ReportingInteractionMode.NOTIFICATION || reportingInteractionMode == ReportingInteractionMode.DIALOG)) {
                if (reportingInteractionMode == ReportingInteractionMode.TOAST && !onlySilentOrApprovedReports) {
                    ToastSender.sendToast((Context)this.mContext, ACRA.getConfig().resToastText(), 1);
                }
                ACRA.log.v(ACRA.LOG_TAG, "About to start ReportSenderWorker from #checkReportOnApplicationStart");
                this.startSendingReports(false, false);
            }
        }
    }

    void deletePendingNonApprovedReports(boolean keepOne) {
        int nbReportsToKeep = keepOne ? 1 : 0;
        this.deletePendingReports(false, true, nbReportsToKeep);
    }

    public void handleException(Throwable e, boolean endApplication) {
        ReportBuilder builder = this.reportBuilder().exception(e);
        if (endApplication) {
            builder.endsApplication();
        }
        builder.send();
    }

    public void handleException(Throwable e) {
        this.reportBuilder().exception(e).send();
    }

    public ReportBuilder reportBuilder() {
        return new ReportBuilder();
    }

    private void report(final ReportBuilder reportBuilder) {
        ReportingInteractionMode reportingInteractionMode;
        if (!this.enabled) {
            return;
        }
        try {
            this.exceptionHandlerInitializer.initializeExceptionHandler(this);
        }
        catch (Exception exceptionInRunnable) {
            ACRA.log.d(ACRA.LOG_TAG, "Failed to initlize " + this.exceptionHandlerInitializer + " from #handleException");
        }
        boolean sendOnlySilentReports = false;
        if (!reportBuilder.mForceSilent) {
            reportingInteractionMode = ACRA.getConfig().mode();
        } else {
            reportingInteractionMode = ReportingInteractionMode.SILENT;
            if (ACRA.getConfig().mode() != ReportingInteractionMode.SILENT) {
                sendOnlySilentReports = true;
            }
        }
        boolean shouldDisplayToast = reportingInteractionMode == ReportingInteractionMode.TOAST || ACRA.getConfig().resToastText() != 0 && (reportingInteractionMode == ReportingInteractionMode.NOTIFICATION || reportingInteractionMode == ReportingInteractionMode.DIALOG);
        final TimeHelper sentToastTimeMillis = new TimeHelper();
        if (shouldDisplayToast) {
            new Thread(){

                @Override
                public void run() {
                    Looper.prepare();
                    ToastSender.sendToast((Context)ErrorReporter.this.mContext, ACRA.getConfig().resToastText(), 1);
                    sentToastTimeMillis.setInitialTimeMillis(System.currentTimeMillis());
                    Looper.loop();
                }
            }.start();
        }
        CrashReportData crashReportData = this.crashReportDataFactory.createCrashData(reportBuilder.mMessage, reportBuilder.mException, reportBuilder.mCustomData, reportBuilder.mForceSilent, reportBuilder.mUncaughtExceptionThread);
        final String reportFileName = this.getReportFileName(crashReportData);
        this.saveCrashReportFile(reportFileName, crashReportData);
        if (reportBuilder.mEndsApplication && !ACRA.getConfig().sendReportsAtShutdown()) {
            this.endApplication(reportBuilder.mUncaughtExceptionThread, reportBuilder.mException);
        }
        SendWorker sender = null;
        if (reportingInteractionMode == ReportingInteractionMode.SILENT || reportingInteractionMode == ReportingInteractionMode.TOAST || this.prefs.getBoolean("acra.alwaysaccept", false)) {
            ACRA.log.d(ACRA.LOG_TAG, "About to start ReportSenderWorker from #handleException");
            sender = this.startSendingReports(sendOnlySilentReports, true);
            if (reportingInteractionMode == ReportingInteractionMode.SILENT && !reportBuilder.mEndsApplication) {
                return;
            }
        } else if (reportingInteractionMode == ReportingInteractionMode.NOTIFICATION) {
            ACRA.log.d(ACRA.LOG_TAG, "Creating Notification.");
            this.createNotification(reportFileName, reportBuilder);
        }
        this.toastWaitEnded = true;
        if (shouldDisplayToast) {
            this.toastWaitEnded = false;
            new Thread(){

                @Override
                public void run() {
                    ACRA.log.d(ACRA.LOG_TAG, "Waiting for 2000 millis from " + sentToastTimeMillis.initialTimeMillis + " currentMillis=" + System.currentTimeMillis());
                    while (sentToastTimeMillis.getElapsedTime() < 2000L) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e1) {
                            ACRA.log.d(ACRA.LOG_TAG, "Interrupted while waiting for Toast to end.", e1);
                        }
                    }
                    ErrorReporter.this.toastWaitEnded = true;
                }
            }.start();
        }
        final SendWorker worker = sender;
        final boolean showDirectDialog = reportingInteractionMode == ReportingInteractionMode.DIALOG && !this.prefs.getBoolean("acra.alwaysaccept", false);
        new Thread(){

            @Override
            public void run() {
                ACRA.log.d(ACRA.LOG_TAG, "Waiting for Toast");
                while (!ErrorReporter.this.toastWaitEnded) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {
                        ACRA.log.d(ACRA.LOG_TAG, "Error : ", e1);
                    }
                }
                ACRA.log.d(ACRA.LOG_TAG, "Finished waiting for Toast");
                if (worker != null) {
                    ACRA.log.d(ACRA.LOG_TAG, "Waiting for Worker");
                    while (worker.isAlive()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e1) {
                            ACRA.log.d(ACRA.LOG_TAG, "Error : ", e1);
                        }
                    }
                    ACRA.log.d(ACRA.LOG_TAG, "Finished waiting for Worker");
                }
                if (showDirectDialog) {
                    ACRA.log.d(ACRA.LOG_TAG, "Creating CrashReportDialog for " + reportFileName);
                    Intent dialogIntent = ErrorReporter.this.createCrashReportDialogIntent(reportFileName, reportBuilder);
                    dialogIntent.setFlags(0x10000000);
                    ErrorReporter.this.mContext.startActivity(dialogIntent);
                }
                ACRA.log.d(ACRA.LOG_TAG, "Wait for Toast + worker ended. Kill Application ? " + reportBuilder.mEndsApplication);
                if (reportBuilder.mEndsApplication) {
                    ErrorReporter.this.endApplication(reportBuilder.mUncaughtExceptionThread, reportBuilder.mException);
                }
            }
        }.start();
    }

    private Intent createCrashReportDialogIntent(String reportFileName, ReportBuilder reportBuilder) {
        ACRA.log.d(ACRA.LOG_TAG, "Creating DialogIntent for " + reportFileName + " exception=" + reportBuilder.mException);
        Intent dialogIntent = new Intent((Context)this.mContext, ACRA.getConfig().reportDialogClass());
        dialogIntent.putExtra("REPORT_FILE_NAME", reportFileName);
        dialogIntent.putExtra("REPORT_EXCEPTION", (Serializable)reportBuilder.mException);
        return dialogIntent;
    }

    private void createNotification(String reportFileName, ReportBuilder reportBuilder) {
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        ACRAConfiguration conf = ACRA.getConfig();
        int icon = conf.resNotifIcon();
        CharSequence tickerText = this.mContext.getText(conf.resNotifTickerText());
        long when = System.currentTimeMillis();
        Notification notification = new Notification(icon, tickerText, when);
        CharSequence contentTitle = this.mContext.getText(conf.resNotifTitle());
        CharSequence contentText = this.mContext.getText(conf.resNotifText());
        ACRA.log.d(ACRA.LOG_TAG, "Creating Notification for " + reportFileName);
        Intent crashReportDialogIntent = this.createCrashReportDialogIntent(reportFileName, reportBuilder);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this.mContext, (int)mNotificationCounter++, (Intent)crashReportDialogIntent, (int)0x8000000);
        notification.setLatestEventInfo((Context)this.mContext, contentTitle, contentText, contentIntent);
        notification.flags |= 0x10;
        Intent deleteIntent = this.createCrashReportDialogIntent(reportFileName, reportBuilder);
        deleteIntent.putExtra("FORCE_CANCEL", true);
        notification.deleteIntent = PendingIntent.getActivity((Context)this.mContext, (int)-1, (Intent)deleteIntent, (int)0);
        notificationManager.notify(666, notification);
    }

    private String getReportFileName(CrashReportData crashData) {
        Time now = new Time();
        now.setToNow();
        long timestamp = now.toMillis(false);
        String isSilent = crashData.getProperty(ReportField.IS_SILENT);
        return timestamp + (isSilent != null ? ACRAConstants.SILENT_SUFFIX : "") + ".stacktrace";
    }

    private void saveCrashReportFile(String fileName, CrashReportData crashData) {
        try {
            ACRA.log.d(ACRA.LOG_TAG, "Writing crash report file " + fileName + ".");
            CrashReportPersister persister = new CrashReportPersister((Context)this.mContext);
            persister.store(crashData, fileName);
        }
        catch (Exception e) {
            ACRA.log.e(ACRA.LOG_TAG, "An error occurred while writing the report file...", e);
        }
    }

    private void deletePendingReports(boolean deleteApprovedReports, boolean deleteNonApprovedReports, int nbOfLatestToKeep) {
        CrashReportFinder reportFinder = new CrashReportFinder((Context)this.mContext);
        Object[] filesList = reportFinder.getCrashReportFiles();
        Arrays.sort(filesList);
        int iFile = 0;
        while (iFile < filesList.length - nbOfLatestToKeep) {
            Object fileName = filesList[iFile];
            boolean isReportApproved = this.fileNameParser.isApproved((String)fileName);
            if (isReportApproved && deleteApprovedReports || !isReportApproved && deleteNonApprovedReports) {
                File fileToDelete = new File(this.mContext.getFilesDir(), (String)fileName);
                ACRA.log.d(ACRA.LOG_TAG, "Deleting file " + (String)fileName);
                if (!fileToDelete.delete()) {
                    ACRA.log.e(ACRA.LOG_TAG, "Could not delete report : " + fileToDelete);
                }
            }
            ++iFile;
        }
    }

    private boolean containsOnlySilentOrApprovedReports(String[] reportFileNames) {
        String[] stringArray = reportFileNames;
        int n = reportFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String reportFileName = stringArray[n2];
            if (!this.fileNameParser.isApproved(reportFileName)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void setDefaultReportSenders() {
        ACRAConfiguration conf = ACRA.getConfig();
        Application mApplication = ACRA.getApplication();
        this.removeAllReportSenders();
        if (!"".equals(conf.mailTo())) {
            ACRA.log.w(ACRA.LOG_TAG, String.valueOf(mApplication.getPackageName()) + " reports will be sent by email (if accepted by user).");
            this.setReportSender(new EmailIntentSender((Context)mApplication));
            return;
        }
        PackageManagerWrapper pm = new PackageManagerWrapper((Context)mApplication);
        if (!pm.hasPermission("android.permission.INTERNET")) {
            ACRA.log.e(ACRA.LOG_TAG, String.valueOf(mApplication.getPackageName()) + " should be granted permission " + "android.permission.INTERNET" + " if you want your crash reports to be sent. If you don't want to add this permission to your application you can also enable sending reports by email. If this is your will then provide your email address in @ReportsCrashes(mailTo=\"your.account@domain.com\"");
            return;
        }
        if (conf.formUri() != null && !"".equals(conf.formUri())) {
            this.setReportSender(new HttpSender(ACRA.getConfig().httpMethod(), ACRA.getConfig().reportType(), null));
        }
    }

    public final class ReportBuilder {
        private String mMessage;
        private Thread mUncaughtExceptionThread;
        private Throwable mException;
        private Map<String, String> mCustomData;
        private boolean mForceSilent = false;
        private boolean mEndsApplication = false;

        public ReportBuilder message(String msg) {
            this.mMessage = msg;
            return this;
        }

        private ReportBuilder uncaughtExceptionThread(Thread thread) {
            this.mUncaughtExceptionThread = thread;
            return this;
        }

        public ReportBuilder exception(Throwable e) {
            this.mException = e;
            return this;
        }

        private void initCustomData() {
            if (this.mCustomData == null) {
                this.mCustomData = new HashMap<String, String>();
            }
        }

        public ReportBuilder customData(Map<String, String> customData) {
            this.initCustomData();
            this.mCustomData.putAll(customData);
            return this;
        }

        public ReportBuilder customData(String key, String value) {
            this.initCustomData();
            this.mCustomData.put(key, value);
            return this;
        }

        public ReportBuilder forceSilent() {
            this.mForceSilent = true;
            return this;
        }

        public ReportBuilder endsApplication() {
            this.mEndsApplication = true;
            return this;
        }

        public void send() {
            if (this.mMessage == null && this.mException == null) {
                this.mMessage = "Report requested by developer";
            }
            ErrorReporter.this.report(this);
        }
    }

    private static class TimeHelper {
        private Long initialTimeMillis;

        private TimeHelper() {
        }

        public void setInitialTimeMillis(long initialTimeMillis) {
            this.initialTimeMillis = initialTimeMillis;
        }

        public long getElapsedTime() {
            return this.initialTimeMillis == null ? 0L : System.currentTimeMillis() - this.initialTimeMillis;
        }
    }
}

