/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.content.pm.PackageManager;
import java.lang.reflect.Method;
import org.acra.ACRA;
import org.acra.collector.Compatibility;

final class DeviceFeaturesCollector {
    DeviceFeaturesCollector() {
    }

    public static String getFeatures(Context ctx) {
        if (Compatibility.getAPILevel() < 5) {
            return "Data available only with API Level >= 5";
        }
        StringBuilder result = new StringBuilder();
        try {
            Object[] features;
            PackageManager pm = ctx.getPackageManager();
            Method getSystemAvailableFeatures = PackageManager.class.getMethod("getSystemAvailableFeatures", null);
            Object[] objectArray = features = (Object[])getSystemAvailableFeatures.invoke((Object)pm, new Object[0]);
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                Object feature = objectArray[n2];
                String featureName = (String)feature.getClass().getField("name").get(feature);
                if (featureName != null) {
                    result.append(featureName);
                } else {
                    Method getGlEsVersion = feature.getClass().getMethod("getGlEsVersion", null);
                    String glEsVersion = (String)getGlEsVersion.invoke(feature, new Object[0]);
                    result.append("glEsVersion = ");
                    result.append(glEsVersion);
                }
                result.append("\n");
                ++n2;
            }
        }
        catch (Throwable e) {
            ACRA.log.w(ACRA.LOG_TAG, "Couldn't retrieve DeviceFeatures for " + ctx.getPackageName(), e);
            result.append("Could not retrieve data: ");
            result.append(e.getMessage());
        }
        return result.toString();
    }
}

