/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.messageinterpolation.HibernateMessageInterpolatorContext;

public class MessageInterpolatorContext
implements HibernateMessageInterpolatorContext {
    private static final Log log = LoggerFactory.make();
    private final ConstraintDescriptor<?> constraintDescriptor;
    private final Object validatedValue;
    private final Class<?> rootBeanType;

    public MessageInterpolatorContext(ConstraintDescriptor<?> constraintDescriptor, Object validatedValue, Class<?> rootBeanType) {
        this.constraintDescriptor = constraintDescriptor;
        this.validatedValue = validatedValue;
        this.rootBeanType = rootBeanType;
    }

    public ConstraintDescriptor<?> getConstraintDescriptor() {
        return this.constraintDescriptor;
    }

    public Object getValidatedValue() {
        return this.validatedValue;
    }

    @Override
    public Class<?> getRootBeanType() {
        return this.rootBeanType;
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(HibernateMessageInterpolatorContext.class)) {
            return type.cast(this);
        }
        throw log.getTypeNotSupportedForUnwrappingException(type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageInterpolatorContext that = (MessageInterpolatorContext)o;
        if (this.constraintDescriptor != null ? !this.constraintDescriptor.equals(that.constraintDescriptor) : that.constraintDescriptor != null) {
            return false;
        }
        if (this.rootBeanType != null ? !this.rootBeanType.equals(that.rootBeanType) : that.rootBeanType != null) {
            return false;
        }
        return !(this.validatedValue != null ? !this.validatedValue.equals(that.validatedValue) : that.validatedValue != null);
    }

    public int hashCode() {
        int result = this.constraintDescriptor != null ? this.constraintDescriptor.hashCode() : 0;
        result = 31 * result + (this.validatedValue != null ? this.validatedValue.hashCode() : 0);
        result = 31 * result + (this.rootBeanType != null ? this.rootBeanType.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MessageInterpolatorContext");
        sb.append("{constraintDescriptor=").append(this.constraintDescriptor);
        sb.append(", validatedValue=").append(this.validatedValue);
        sb.append('}');
        return sb.toString();
    }
}

