/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.CRC32;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.LongHashMap;
import org.mapdb.LongMap;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.StoreDirect;
import org.mapdb.Volume;

public class StoreWAL
extends StoreDirect {
    protected static final long LOG_MASK_OFFSET = 0xFFFFFFFFFFFFL;
    protected static final byte WAL_INDEX_LONG = 101;
    protected static final byte WAL_LONGSTACK_PAGE = 102;
    protected static final byte WAL_PHYS_ARRAY_ONE_LONG = 103;
    protected static final byte WAL_PHYS_ARRAY = 104;
    protected static final byte WAL_SKIP_REST_OF_BLOCK = 105;
    protected static final byte WAL_SEAL = 111;
    protected static final long LOG_SEAL = 4566556446554645L;
    public static final String TRANS_LOG_FILE_EXT = ".t";
    protected static final long[] TOMBSTONE = new long[0];
    protected static final long[] PREALLOC = new long[0];
    protected final Volume.Factory volFac;
    protected Volume log;
    protected volatile long logSize;
    protected final LongConcurrentHashMap<long[]> modified = new LongConcurrentHashMap();
    protected final LongMap<byte[]> longStackPages = new LongHashMap<byte[]>();
    protected final long[] indexVals = new long[4112];
    protected final boolean[] indexValsModified = new boolean[this.indexVals.length];
    protected boolean replayPending = true;
    protected final AtomicInteger logChecksum = new AtomicInteger();

    public StoreWAL(Volume.Factory volFac) {
        this(volFac, false, false, 5, false, 0L, false, false, null, false, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreWAL(Volume.Factory volFac, boolean readOnly, boolean deleteFilesAfterClose, int spaceReclaimMode, boolean syncOnCommitDisabled, long sizeLimit, boolean checksum, boolean compress, byte[] password, boolean disableLocks, int sizeIncrement) {
        super(volFac, readOnly, deleteFilesAfterClose, spaceReclaimMode, syncOnCommitDisabled, sizeLimit, checksum, compress, password, disableLocks, sizeIncrement);
        this.volFac = volFac;
        this.log = volFac.createTransLogVolume();
        boolean allGood = false;
        this.structuralLock.lock();
        try {
            this.reloadIndexFile();
            if (this.verifyLogFile()) {
                this.replayLogFile();
            }
            this.replayPending = false;
            this.checkHeaders();
            if (!readOnly) {
                this.logReset();
            }
            allGood = true;
        }
        finally {
            if (!allGood) {
                if (this.log != null) {
                    this.log.close();
                    this.log = null;
                }
                if (this.index != null) {
                    this.index.close();
                    this.index = null;
                }
                if (this.phys != null) {
                    this.phys.close();
                    this.phys = null;
                }
            }
            this.structuralLock.unlock();
        }
    }

    @Override
    protected void checkHeaders() {
        if (this.replayPending) {
            return;
        }
        super.checkHeaders();
    }

    protected void reloadIndexFile() {
        assert (this.structuralLock.isHeldByCurrentThread());
        this.logSize = 16L;
        this.modified.clear();
        this.longStackPages.clear();
        this.indexSize = this.index.getLong(8L);
        this.physSize = this.index.getLong(16L);
        this.freeSize = this.index.getLong(24L);
        for (int i = 0; i < 32896; i += 8) {
            this.indexVals[i / 8] = this.index.getLong(i);
        }
        Arrays.fill(this.indexValsModified, false);
        this.logChecksum.set(0);
        this.maxUsedIoList = 32888L;
        while (this.indexVals[(int)(this.maxUsedIoList / 8L)] != 0L && this.maxUsedIoList > 120L) {
            this.maxUsedIoList -= 8L;
        }
    }

    protected void logReset() {
        assert (this.structuralLock.isHeldByCurrentThread());
        this.log.truncate(16L);
        this.log.ensureAvailable(16L);
        this.log.putInt(0L, 234243482);
        this.log.putUnsignedShort(4L, 10000);
        this.log.putUnsignedShort(6L, this.expectedMasks());
        this.log.putLong(8L, 0L);
        this.logSize = 16L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long preallocate() {
        long ioRecid;
        this.newRecidLock.readLock().lock();
        try {
            long logPos;
            this.structuralLock.lock();
            try {
                ioRecid = this.freeIoRecidTake(false);
                logPos = this.logSize;
                this.logSize += 17L;
                this.log.ensureAvailable(this.logSize);
            }
            finally {
                this.structuralLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(ioRecid)].writeLock();
            lock.lock();
            try {
                this.walIndexVal(logPos, ioRecid, 4L);
                this.modified.put(ioRecid, PREALLOC);
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            this.newRecidLock.readLock().unlock();
        }
        long recid = (ioRecid - 32896L) / 8L;
        assert (recid > 0L);
        return recid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preallocate(long[] recids) {
        this.newRecidLock.readLock().lock();
        try {
            int i;
            long logPos;
            this.structuralLock.lock();
            try {
                logPos = this.logSize;
                for (i = 0; i < recids.length; ++i) {
                    recids[i] = this.freeIoRecidTake(false);
                }
                this.logSize += (long)(recids.length * 17);
                this.log.ensureAvailable(this.logSize);
            }
            finally {
                this.structuralLock.unlock();
            }
            for (i = 0; i < recids.length; ++i) {
                long ioRecid = recids[i];
                ReentrantReadWriteLock.WriteLock lock2 = this.locks[Store.lockPos(ioRecid)].writeLock();
                lock2.lock();
                try {
                    this.walIndexVal(logPos, ioRecid, 4L);
                    logPos += 17L;
                    this.modified.put(ioRecid, PREALLOC);
                }
                finally {
                    lock2.unlock();
                }
                recids[i] = (ioRecid - 32896L) / 8L;
                assert (recids[i] > 0L);
            }
        }
        finally {
            this.newRecidLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        long ioRecid;
        assert (value != null);
        DataOutput2 out = this.serialize(value, serializer);
        this.newRecidLock.readLock().lock();
        try {
            long[] logPos;
            long[] physPos;
            this.structuralLock.lock();
            try {
                ioRecid = this.freeIoRecidTake(false);
                physPos = this.physAllocate(out.pos, false, false);
                logPos = this.logAllocate(physPos);
            }
            finally {
                this.structuralLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(ioRecid)].writeLock();
            lock.lock();
            try {
                this.walIndexVal((logPos[0] & 0xFFFFFFFFFFFFL) - 1L - 8L - 8L - 1L - 8L, ioRecid, physPos[0] | 2L);
                this.walPhysArray(out, physPos, logPos);
                this.modified.put(ioRecid, logPos);
                this.recycledDataOuts.offer(out);
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            this.newRecidLock.readLock().unlock();
        }
        long recid = (ioRecid - 32896L) / 8L;
        assert (recid > 0L);
        return recid;
    }

    protected void walPhysArray(DataOutput2 out, long[] physPos, long[] logPos) {
        int outPos = 0;
        int logC = 0;
        CRC32 crc32 = new CRC32();
        for (int i = 0; i < logPos.length; ++i) {
            int c = i == logPos.length - 1 ? 0 : 8;
            long pos = logPos[i] & 0xFFFFFFFFFFFFL;
            int size = (int)(logPos[i] >>> 48);
            byte header = c == 0 ? (byte)104 : 103;
            this.log.putByte(pos - 8L - 1L, header);
            this.log.putLong(pos - 8L, physPos[i]);
            if (c > 0) {
                this.log.putLong(pos, physPos[i + 1]);
            }
            this.log.putData(pos + (long)c, out.buf, outPos, size - c);
            crc32.reset();
            crc32.update(out.buf, outPos, size - c);
            logC |= LongHashMap.longHash(pos | (long)header | physPos[i] | (c > 0 ? physPos[i + 1] : 0L) | crc32.getValue());
            assert (this.logSize >= (long)(outPos += size - c));
        }
        this.logChecksumAdd(logC);
        assert (outPos == out.pos);
    }

    protected void walIndexVal(long logPos, long ioRecid, long indexVal) {
        assert (this.locks[Store.lockPos(ioRecid)].writeLock().isHeldByCurrentThread());
        assert (this.logSize >= logPos + 1L + 8L + 8L);
        this.log.putByte(logPos, (byte)101);
        this.log.putLong(logPos + 1L, ioRecid);
        this.log.putLong(logPos + 9L, indexVal);
        this.logChecksumAdd(LongHashMap.longHash(logPos | 0x65L | ioRecid | indexVal));
    }

    protected long[] logAllocate(long[] physPos) {
        assert (this.structuralLock.isHeldByCurrentThread());
        this.logSize += 17L;
        long[] ret = new long[physPos.length];
        for (int i = 0; i < physPos.length; ++i) {
            long size = physPos[i] >>> 48;
            this.logSize += 9L;
            ret[i] = size << 48 | this.logSize;
            this.logSize += size;
            this.checkLogRounding();
        }
        this.log.ensureAvailable(this.logSize);
        return ret;
    }

    protected void checkLogRounding() {
        assert (this.structuralLock.isHeldByCurrentThread());
        if ((this.logSize & 0xFFFFFL) + 131070L > 0x100000L) {
            this.log.ensureAvailable(this.logSize + 1L);
            this.log.putByte(this.logSize, (byte)105);
            this.logSize += 0x100000L - (this.logSize & 0xFFFFFL);
        }
    }

    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        assert (recid > 0L);
        long ioRecid = 32896L + recid * 8L;
        ReentrantReadWriteLock.ReadLock lock = this.locks[Store.lockPos(ioRecid)].readLock();
        lock.lock();
        try {
            A a = this.get2(ioRecid, serializer);
            return a;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    protected <A> A get2(long ioRecid, Serializer<A> serializer) throws IOException {
        assert (this.locks[Store.lockPos(ioRecid)].getWriteHoldCount() == 0 || this.locks[Store.lockPos(ioRecid)].writeLock().isHeldByCurrentThread());
        long[] r = this.modified.get(ioRecid);
        if (r == null) {
            return super.get2(ioRecid, serializer);
        }
        if (r == TOMBSTONE || r == PREALLOC || r.length == 0) {
            return null;
        }
        if (r.length == 1) {
            int size = (int)(r[0] >>> 48);
            DataInput2 in = (DataInput2)this.log.getDataInput(r[0] & 0xFFFFFFFFFFFFL, size);
            return this.deserialize(serializer, size, in);
        }
        int totalSize = 0;
        for (int i = 0; i < r.length; ++i) {
            int c = i == r.length - 1 ? 0 : 8;
            totalSize += (int)(r[i] >>> 48) - c;
        }
        byte[] b = new byte[totalSize];
        int pos = 0;
        for (int i = 0; i < r.length; ++i) {
            int c = i == r.length - 1 ? 0 : 8;
            int size = (int)(r[i] >>> 48) - c;
            this.log.getDataInput((r[i] & 0xFFFFFFFFFFFFL) + (long)c, size).readFully(b, pos, size);
            pos += size;
        }
        if (pos != totalSize) {
            throw new AssertionError();
        }
        return this.deserialize(serializer, totalSize, new DataInput2(b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        assert (recid > 0L);
        assert (value != null);
        DataOutput2 out = this.serialize(value, serializer);
        long ioRecid = 32896L + recid * 8L;
        ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(ioRecid)].writeLock();
        lock.lock();
        try {
            long[] logPos;
            long[] physPos;
            long indexVal = 0L;
            long[] linkedRecords = this.getLinkedRecordsFromLog(ioRecid);
            if (linkedRecords == null) {
                indexVal = this.index.getLong(ioRecid);
                linkedRecords = this.getLinkedRecordsIndexVals(indexVal);
            } else if (linkedRecords == PREALLOC) {
                linkedRecords = null;
            }
            this.structuralLock.lock();
            try {
                if (indexVal >>> 48 > 0L) {
                    this.freePhysPut(indexVal, false);
                }
                if (linkedRecords != null) {
                    for (int i = 0; i < linkedRecords.length && linkedRecords[i] != 0L; ++i) {
                        this.freePhysPut(linkedRecords[i], false);
                    }
                }
                physPos = this.physAllocate(out.pos, false, false);
                logPos = this.logAllocate(physPos);
            }
            finally {
                this.structuralLock.unlock();
            }
            this.walIndexVal((logPos[0] & 0xFFFFFFFFFFFFL) - 1L - 8L - 8L - 1L - 8L, ioRecid, physPos[0] | 2L);
            this.walPhysArray(out, physPos, logPos);
            this.modified.put(ioRecid, logPos);
        }
        finally {
            lock.unlock();
        }
        this.recycledDataOuts.offer(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        DataOutput2 out;
        assert (recid > 0L);
        assert (expectedOldValue != null && newValue != null);
        long ioRecid = 32896L + recid * 8L;
        ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(ioRecid)].writeLock();
        lock.lock();
        try {
            long[] logPos;
            long[] physPos;
            A oldVal = this.get2(ioRecid, serializer);
            if (oldVal == null && expectedOldValue != null || oldVal != null && !oldVal.equals(expectedOldValue)) {
                boolean bl = false;
                return bl;
            }
            out = this.serialize(newValue, serializer);
            long indexVal = 0L;
            long[] linkedRecords = this.getLinkedRecordsFromLog(ioRecid);
            if (linkedRecords == null) {
                indexVal = this.index.getLong(ioRecid);
                linkedRecords = this.getLinkedRecordsIndexVals(indexVal);
            }
            this.structuralLock.lock();
            try {
                if (indexVal >>> 48 > 0L) {
                    this.freePhysPut(indexVal, false);
                }
                if (linkedRecords != null) {
                    for (int i = 0; i < linkedRecords.length && linkedRecords[i] != 0L; ++i) {
                        this.freePhysPut(linkedRecords[i], false);
                    }
                }
                physPos = this.physAllocate(out.pos, false, false);
                logPos = this.logAllocate(physPos);
            }
            finally {
                this.structuralLock.unlock();
            }
            this.walIndexVal((logPos[0] & 0xFFFFFFFFFFFFL) - 1L - 8L - 8L - 1L - 8L, ioRecid, physPos[0] | 2L);
            this.walPhysArray(out, physPos, logPos);
            this.modified.put(ioRecid, logPos);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            lock.unlock();
        }
        this.recycledDataOuts.offer(out);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        assert (recid > 0L);
        long ioRecid = 32896L + recid * 8L;
        ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(ioRecid)].writeLock();
        lock.lock();
        try {
            long logPos;
            long indexVal = 0L;
            long[] linkedRecords = this.getLinkedRecordsFromLog(ioRecid);
            if (linkedRecords == null) {
                indexVal = this.index.getLong(ioRecid);
                if (indexVal == 4L) {
                    return;
                }
                linkedRecords = this.getLinkedRecordsIndexVals(indexVal);
            }
            this.structuralLock.lock();
            try {
                logPos = this.logSize;
                this.checkLogRounding();
                this.logSize += 17L;
                this.log.ensureAvailable(this.logSize);
                this.longStackPut(120L, ioRecid, false);
                if (indexVal >>> 48 > 0L) {
                    this.freePhysPut(indexVal, false);
                }
                if (linkedRecords != null) {
                    for (int i = 0; i < linkedRecords.length && linkedRecords[i] != 0L; ++i) {
                        this.freePhysPut(linkedRecords[i], false);
                    }
                }
            }
            finally {
                this.structuralLock.unlock();
            }
            this.walIndexVal(logPos, ioRecid, 2L);
            this.modified.put(ioRecid, TOMBSTONE);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        this.lockAllWrite();
        try {
            if (this.serializerPojo != null && this.serializerPojo.hasUnsavedChanges()) {
                this.serializerPojo.save(this);
            }
            if (!this.logDirty()) {
                return;
            }
            int crc = 0;
            LongMap.LongMapIterator<byte[]> iter = this.longStackPages.longMapIterator();
            while (iter.moveToNext()) {
                assert (iter.key() >>> 48 == 0L);
                byte[] array = iter.value();
                long pageSize = (array[0] & 0xFF) << 8 | array[1] & 0xFF;
                assert ((long)array.length == pageSize);
                long firstVal = pageSize << 48 | iter.key();
                this.log.ensureAvailable(this.logSize + 1L + 8L + pageSize);
                crc |= LongHashMap.longHash(this.logSize | 0x66L | firstVal);
                this.log.putByte(this.logSize, (byte)102);
                ++this.logSize;
                this.log.putLong(this.logSize, firstVal);
                this.logSize += 8L;
                CRC32 crc32 = new CRC32();
                crc32.update(array);
                crc = (int)((long)crc | crc32.getValue());
                this.log.putData(this.logSize, array, 0, array.length);
                this.logSize += (long)array.length;
                this.checkLogRounding();
            }
            for (int i = 120; i < 32896; i += 8) {
                if (!this.indexValsModified[i / 8]) continue;
                this.log.ensureAvailable(this.logSize + 17L);
                this.logSize += 17L;
                this.walIndexVal(this.logSize - 17L, i, this.indexVals[i / 8]);
            }
            this.log.ensureAvailable(this.logSize + 1L + 18L + 8L + 4L);
            long indexChecksum = this.indexHeaderChecksumUncommited();
            crc |= LongHashMap.longHash(this.logSize | 0x6FL | this.indexSize | this.physSize | this.freeSize | indexChecksum);
            this.log.putByte(this.logSize, (byte)111);
            ++this.logSize;
            this.log.putSixLong(this.logSize, this.indexSize);
            this.logSize += 6L;
            this.log.putSixLong(this.logSize, this.physSize);
            this.logSize += 6L;
            this.log.putSixLong(this.logSize, this.freeSize);
            this.logSize += 6L;
            this.log.putLong(this.logSize, indexChecksum);
            this.logSize += 8L;
            this.log.putInt(this.logSize, crc | this.logChecksum.get());
            this.logSize += 4L;
            this.log.putLong(8L, 4566556446554645L);
            if (!this.syncOnCommitDisabled) {
                this.log.sync();
            }
            this.replayLogFile();
            this.reloadIndexFile();
        }
        finally {
            this.unlockAllWrite();
        }
    }

    protected boolean logDirty() {
        if (this.logSize != 16L || !this.longStackPages.isEmpty() || !this.modified.isEmpty()) {
            return true;
        }
        for (boolean b : this.indexValsModified) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    protected long indexHeaderChecksumUncommited() {
        long ret = 0L;
        for (int offset = 0; offset < 32896; offset += 8) {
            if (offset == 32) continue;
            long indexVal = offset == 8 ? this.indexSize : (offset == 16 ? this.physSize : (offset == 24 ? this.freeSize : this.indexVals[offset / 8]));
            ret |= indexVal | (long)LongHashMap.longHash(indexVal | (long)offset);
        }
        return ret;
    }

    protected boolean verifyLogFile() {
        assert (this.structuralLock.isHeldByCurrentThread());
        if (this.readOnly && this.log == null) {
            return false;
        }
        this.logSize = 0L;
        if (this.log.isEmpty() || this.log.getFile() != null && this.log.getFile().length() < 16L || this.log.getInt(0L) != 234243482 || this.log.getLong(8L) != 4566556446554645L) {
            return false;
        }
        if (this.log.getUnsignedShort(4L) > 10000) {
            throw new IOError(new IOException("New store format version, please use newer MapDB version"));
        }
        if (this.log.getUnsignedShort(6L) != this.expectedMasks()) {
            throw new IllegalArgumentException("Log file created with different features. Please check compression, checksum or encryption");
        }
        try {
            CRC32 crc32 = new CRC32();
            this.logSize = 16L;
            byte ins = this.log.getByte(this.logSize);
            ++this.logSize;
            int crc = 0;
            while (ins != 111) {
                byte[] b;
                long offset2;
                if (ins == 101) {
                    long ioRecid = this.log.getLong(this.logSize);
                    this.logSize += 8L;
                    long indexVal = this.log.getLong(this.logSize);
                    this.logSize += 8L;
                    crc |= LongHashMap.longHash(this.logSize - 1L - 8L - 8L | 0x65L | ioRecid | indexVal);
                } else if (ins == 104) {
                    offset2 = this.log.getLong(this.logSize);
                    this.logSize += 8L;
                    int size = (int)(offset2 >>> 48);
                    byte[] b2 = new byte[size];
                    this.log.getDataInput(this.logSize, size).readFully(b2);
                    crc32.reset();
                    crc32.update(b2);
                    crc |= LongHashMap.longHash(this.logSize | 0x68L | offset2 | crc32.getValue());
                    this.logSize += (long)size;
                } else if (ins == 103) {
                    offset2 = this.log.getLong(this.logSize);
                    this.logSize += 8L;
                    int size = (int)(offset2 >>> 48) - 8;
                    long nextPageLink = this.log.getLong(this.logSize);
                    this.logSize += 8L;
                    b = new byte[size];
                    this.log.getDataInput(this.logSize, size).readFully(b);
                    crc32.reset();
                    crc32.update(b);
                    crc |= LongHashMap.longHash(this.logSize | 0x67L | offset2 | nextPageLink | crc32.getValue());
                    this.logSize += (long)size;
                } else if (ins == 102) {
                    long offset = this.log.getLong(this.logSize);
                    this.logSize += 8L;
                    long origLogSize = this.logSize;
                    int size = (int)(offset >>> 48);
                    crc |= LongHashMap.longHash(origLogSize | 0x66L | offset);
                    b = new byte[size];
                    this.log.getDataInput(this.logSize, size).readFully(b);
                    crc32.reset();
                    crc32.update(b);
                    crc = (int)((long)crc | crc32.getValue());
                    this.log.getDataInput(this.logSize, size).readFully(b);
                } else if (ins == 105) {
                    this.logSize += 0x100000L - (this.logSize & 0xFFFFFL);
                } else {
                    return false;
                }
                ins = this.log.getByte(this.logSize);
                ++this.logSize;
            }
            long indexSize = this.log.getSixLong(this.logSize);
            this.logSize += 6L;
            long physSize = this.log.getSixLong(this.logSize);
            this.logSize += 6L;
            long freeSize = this.log.getSixLong(this.logSize);
            this.logSize += 6L;
            long indexSum = this.log.getLong(this.logSize);
            this.logSize += 8L;
            crc |= LongHashMap.longHash(this.logSize - 1L - 18L - 8L | indexSize | physSize | freeSize | indexSum);
            int realCrc = this.log.getInt(this.logSize);
            this.logSize += 4L;
            this.logSize = 0L;
            assert (this.structuralLock.isHeldByCurrentThread());
            if ((long)realCrc == Long.MIN_VALUE) {
                return true;
            }
            return realCrc == crc;
        }
        catch (IOException e) {
            return false;
        }
        catch (IOError e) {
            return false;
        }
    }

    protected void replayLogFile() {
        assert (this.structuralLock.isHeldByCurrentThread());
        if (this.readOnly && this.log == null) {
            return;
        }
        this.logSize = 0L;
        if (this.log.isEmpty() || this.log.getInt(0L) != 234243482 || this.log.getUnsignedShort(4L) > 10000 || this.log.getLong(8L) != 4566556446554645L || this.log.getUnsignedShort(6L) != this.expectedMasks()) {
            this.logReset();
            return;
        }
        this.logSize = 16L;
        byte ins = this.log.getByte(this.logSize);
        ++this.logSize;
        while (ins != 111) {
            if (ins == 101) {
                long ioRecid = this.log.getLong(this.logSize);
                this.logSize += 8L;
                long indexVal = this.log.getLong(this.logSize);
                this.logSize += 8L;
                this.index.ensureAvailable(ioRecid + 8L);
                this.index.putLong(ioRecid, indexVal);
            } else if (ins == 104 || ins == 102 || ins == 103) {
                long offset = this.log.getLong(this.logSize);
                this.logSize += 8L;
                int size = (int)(offset >>> 48);
                offset &= 0xFFFFFFFFFFF0L;
                DataInput2 input = (DataInput2)this.log.getDataInput(this.logSize, size);
                ByteBuffer buf = input.buf.duplicate();
                buf.position(input.pos);
                buf.limit(input.pos + size);
                this.phys.ensureAvailable(offset + (long)size);
                this.phys.putData(offset, buf);
                this.logSize += (long)size;
            } else if (ins == 105) {
                this.logSize += 0x100000L - (this.logSize & 0xFFFFFL);
            } else {
                throw new AssertionError((Object)("unknown trans log instruction '" + ins + "' at log offset: " + (this.logSize - 1L)));
            }
            ins = this.log.getByte(this.logSize);
            ++this.logSize;
        }
        this.index.putLong(8L, this.log.getSixLong(this.logSize));
        this.logSize += 6L;
        this.index.putLong(16L, this.log.getSixLong(this.logSize));
        this.logSize += 6L;
        this.index.putLong(24L, this.log.getSixLong(this.logSize));
        this.logSize += 6L;
        this.index.putLong(32L, this.log.getLong(this.logSize));
        this.logSize += 8L;
        if (!this.syncOnCommitDisabled) {
            this.phys.sync();
            this.index.sync();
        }
        this.logReset();
        assert (this.structuralLock.isHeldByCurrentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws UnsupportedOperationException {
        this.lockAllWrite();
        try {
            this.logReset();
            this.reloadIndexFile();
        }
        finally {
            this.unlockAllWrite();
        }
    }

    protected long[] getLinkedRecordsFromLog(long ioRecid) {
        assert (this.locks[Store.lockPos(ioRecid)].writeLock().isHeldByCurrentThread());
        long[] ret0 = this.modified.get(ioRecid);
        if (ret0 == PREALLOC) {
            return ret0;
        }
        if (ret0 != null && ret0 != TOMBSTONE) {
            long[] ret = new long[ret0.length];
            for (int i = 0; i < ret0.length; ++i) {
                long offset = ret0[i] & 0xFFFFFFFFFFFFL;
                ret[i] = this.log.getLong(offset - 8L);
            }
            return ret;
        }
        return null;
    }

    @Override
    protected long longStackTake(long ioList, boolean recursive) {
        assert (this.structuralLock.isHeldByCurrentThread());
        assert (ioList >= 120L && ioList < 32896L) : "wrong ioList: " + ioList;
        long dataOffset = this.indexVals[(int)ioList / 8];
        if (dataOffset == 0L) {
            return 0L;
        }
        long pos = dataOffset >>> 48;
        byte[] page = this.longStackGetPage(dataOffset &= 0xFFFFFFFFFFF0L);
        if (pos < 8L) {
            throw new AssertionError();
        }
        long ret = StoreWAL.longStackGetSixLong(page, (int)pos);
        if (pos == 8L) {
            long next = StoreWAL.longStackGetSixLong(page, 2);
            long size = (page[0] & 0xFF) << 8 | page[1] & 0xFF;
            assert (size == (long)page.length);
            if (next != 0L) {
                byte[] nextPage = this.longStackGetPage(next);
                long nextSize = (nextPage[0] & 0xFF) << 8 | nextPage[1] & 0xFF;
                assert ((nextSize - 8L) % 6L == 0L);
                this.indexVals[(int)ioList / 8] = nextSize - 6L << 48 | next;
                this.indexValsModified[(int)ioList / 8] = true;
            } else {
                this.indexVals[(int)ioList / 8] = 0L;
                this.indexValsModified[(int)ioList / 8] = true;
                if (this.maxUsedIoList == ioList) {
                    while (this.indexVals[(int)this.maxUsedIoList / 8] == 0L && this.maxUsedIoList > 120L) {
                        this.maxUsedIoList -= 8L;
                    }
                }
            }
            this.freePhysPut(size << 48 | dataOffset, true);
            assert (dataOffset >>> 48 == 0L);
            this.longStackPages.remove(dataOffset);
        } else {
            this.indexVals[(int)ioList / 8] = (pos -= 6L) << 48 | dataOffset;
            this.indexValsModified[(int)ioList / 8] = true;
        }
        return ret;
    }

    @Override
    protected void longStackPut(long ioList, long offset, boolean recursive) {
        assert (this.structuralLock.isHeldByCurrentThread());
        assert (offset >>> 48 == 0L);
        assert (ioList >= 120L && ioList <= 32896L) : "wrong ioList: " + ioList;
        long dataOffset = this.indexVals[(int)ioList / 8];
        long pos = dataOffset >>> 48;
        if ((dataOffset &= 0xFFFFFFFFFFF0L) == 0L) {
            long listPhysid = this.freePhysTake(1232, true, true) & 0xFFFFFFFFFFF0L;
            if (listPhysid == 0L) {
                throw new AssertionError();
            }
            assert (listPhysid >>> 48 == 0L);
            byte[] page = new byte[1232];
            page[0] = (byte)(0xFF & page.length >>> 8);
            page[1] = (byte)(0xFF & page.length);
            StoreWAL.longStackPutSixLong(page, 2, 0L);
            StoreWAL.longStackPutSixLong(page, 8, offset);
            this.indexVals[(int)ioList / 8] = 0x8000000000000L | listPhysid;
            this.indexValsModified[(int)ioList / 8] = true;
            if (this.maxUsedIoList <= ioList) {
                this.maxUsedIoList = ioList;
            }
            this.longStackPages.put(listPhysid, page);
        } else {
            byte[] page = this.longStackGetPage(dataOffset);
            long size = (page[0] & 0xFF) << 8 | page[1] & 0xFF;
            assert (pos + 6L <= size);
            if (pos + 6L == size) {
                long listPhysid;
                long newPageSize = 1232L;
                if (ioList == StoreWAL.size2ListIoRecid(1232L)) {
                    newPageSize = 1280L;
                }
                if ((listPhysid = this.freePhysTake((int)newPageSize, true, true) & 0xFFFFFFFFFFF0L) == 0L) {
                    throw new AssertionError();
                }
                byte[] newPage = new byte[(int)newPageSize];
                newPage[0] = (byte)(0xFFL & newPageSize >>> 8);
                newPage[1] = (byte)(0xFFL & newPageSize);
                StoreWAL.longStackPutSixLong(newPage, 2, dataOffset & 0xFFFFFFFFFFF0L);
                StoreWAL.longStackPutSixLong(newPage, 8, offset);
                assert (listPhysid >>> 48 == 0L);
                this.longStackPages.put(listPhysid, newPage);
                this.indexVals[(int)ioList / 8] = 0x8000000000000L | listPhysid;
                this.indexValsModified[(int)ioList / 8] = true;
            } else {
                StoreWAL.longStackPutSixLong(page, (int)(pos += 6L), offset);
                this.indexVals[(int)ioList / 8] = pos << 48 | dataOffset;
                this.indexValsModified[(int)ioList / 8] = true;
            }
        }
    }

    protected static long longStackGetSixLong(byte[] page, int pos) {
        return (long)(page[pos + 0] & 0xFF) << 40 | (long)(page[pos + 1] & 0xFF) << 32 | (long)(page[pos + 2] & 0xFF) << 24 | (long)(page[pos + 3] & 0xFF) << 16 | (long)(page[pos + 4] & 0xFF) << 8 | (long)(page[pos + 5] & 0xFF) << 0;
    }

    protected static void longStackPutSixLong(byte[] page, int pos, long value) {
        assert (value >= 0L && value >>> 48 == 0L) : "value does not fit";
        page[pos + 0] = (byte)(0xFFL & value >> 40);
        page[pos + 1] = (byte)(0xFFL & value >> 32);
        page[pos + 2] = (byte)(0xFFL & value >> 24);
        page[pos + 3] = (byte)(0xFFL & value >> 16);
        page[pos + 4] = (byte)(0xFFL & value >> 8);
        page[pos + 5] = (byte)(0xFFL & value >> 0);
    }

    protected byte[] longStackGetPage(long offset) {
        assert (offset >= 16L);
        assert (offset >>> 48 == 0L);
        byte[] ret = this.longStackPages.get(offset);
        if (ret == null) {
            int size = this.phys.getUnsignedShort(offset);
            assert (size >= 14);
            ret = new byte[size];
            try {
                this.phys.getDataInput(offset, size).readFully(ret);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            this.longStackPages.put(offset, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        for (Runnable closeListener : this.closeListeners) {
            closeListener.run();
        }
        if (this.serializerPojo != null && this.serializerPojo.hasUnsavedChanges()) {
            this.serializerPojo.save(this);
        }
        this.lockAllWrite();
        try {
            if (this.log != null) {
                this.log.sync();
                this.log.close();
                if (this.deleteFilesAfterClose) {
                    this.log.deleteFile();
                }
            }
            this.index.sync();
            this.phys.sync();
            this.index.close();
            this.phys.close();
            if (this.deleteFilesAfterClose) {
                this.index.deleteFile();
                this.phys.deleteFile();
            }
            this.index = null;
            this.phys = null;
        }
        finally {
            this.unlockAllWrite();
        }
    }

    @Override
    protected void compactPreUnderLock() {
        assert (this.structuralLock.isLocked());
        if (this.logDirty()) {
            throw new IllegalAccessError("WAL not empty; commit first, than compact");
        }
    }

    @Override
    protected void compactPostUnderLock() {
        assert (this.structuralLock.isLocked());
        this.reloadIndexFile();
    }

    @Override
    public boolean canRollback() {
        return true;
    }

    protected void logChecksumAdd(int cs) {
        int old;
        while (!this.logChecksum.compareAndSet(old = this.logChecksum.get(), old | cs)) {
        }
    }
}

