/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bson.util.Assertions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Tags
implements Map<String, String> {
    private final boolean frozen;
    private final Map<String, String> wrapped;

    public static Tags freeze(Tags tags) {
        return new Tags(tags);
    }

    public Tags() {
        this.wrapped = new HashMap<String, String>();
        this.frozen = false;
    }

    public Tags(String key, String value) {
        this.wrapped = new HashMap<String, String>();
        this.wrapped.put(key, value);
        this.frozen = false;
    }

    Tags(Map<String, String> wrapped) {
        this.wrapped = new HashMap<String, String>(wrapped);
        this.frozen = true;
    }

    public Tags append(String key, String value) {
        Assertions.isTrue("not frozen", !this.frozen);
        this.wrapped.put(key, value);
        return this;
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrapped.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrapped.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.wrapped.get(key);
    }

    @Override
    public String put(String key, String value) {
        Assertions.isTrue("not frozen", !this.frozen);
        return this.wrapped.put(key, value);
    }

    @Override
    public String remove(Object key) {
        Assertions.isTrue("not frozen", !this.frozen);
        return this.wrapped.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        Assertions.isTrue("not frozen", !this.frozen);
        this.wrapped.putAll(m);
    }

    @Override
    public void clear() {
        Assertions.isTrue("not frozen", !this.frozen);
        this.wrapped.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.wrapped.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.wrapped.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.wrapped.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tags tags = (Tags)o;
        return this.wrapped.equals(tags.wrapped);
    }

    @Override
    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public String toString() {
        return "TagSet" + this.wrapped.toString();
    }
}

